// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package spark

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opStopApplicationCommon = "stopApplication"

// StopApplicationCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the StopApplicationCommon operation. The "output" return
// value will be populated with the StopApplicationCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned StopApplicationCommon Request to send the API call to the service.
// the "output" return value is not valid until after StopApplicationCommon Send returns without error.
//
// See StopApplicationCommon for more information on using the StopApplicationCommon
// API call, and error handling.
//
//	// Example sending a request using the StopApplicationCommonRequest method.
//	req, resp := client.StopApplicationCommonRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *SPARK) StopApplicationCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opStopApplicationCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// StopApplicationCommon API operation for SPARK.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for SPARK's
// API operation StopApplicationCommon for usage and error information.
func (c *SPARK) StopApplicationCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.StopApplicationCommonRequest(input)
	return out, req.Send()
}

// StopApplicationCommonWithContext is the same as StopApplicationCommon with the addition of
// the ability to pass a context and additional request options.
//
// See StopApplicationCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SPARK) StopApplicationCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.StopApplicationCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopApplication = "stopApplication"

// StopApplicationRequest generates a "volcengine/request.Request" representing the
// client's request for the StopApplication operation. The "output" return
// value will be populated with the StopApplicationCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned StopApplicationCommon Request to send the API call to the service.
// the "output" return value is not valid until after StopApplicationCommon Send returns without error.
//
// See StopApplication for more information on using the StopApplication
// API call, and error handling.
//
//	// Example sending a request using the StopApplicationRequest method.
//	req, resp := client.StopApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *SPARK) StopApplicationRequest(input *StopApplicationInput) (req *request.Request, output *StopApplicationOutput) {
	op := &request.Operation{
		Name:       opStopApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopApplicationInput{}
	}

	output = &StopApplicationOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// StopApplication API operation for SPARK.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for SPARK's
// API operation StopApplication for usage and error information.
func (c *SPARK) StopApplication(input *StopApplicationInput) (*StopApplicationOutput, error) {
	req, out := c.StopApplicationRequest(input)
	return out, req.Send()
}

// StopApplicationWithContext is the same as StopApplication with the addition of
// the ability to pass a context and additional request options.
//
// See StopApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SPARK) StopApplicationWithContext(ctx volcengine.Context, input *StopApplicationInput, opts ...request.Option) (*StopApplicationOutput, error) {
	req, out := c.StopApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type StopApplicationInput struct {
	_ struct{} `type:"structure"`

	AccountId *string `type:"string"`

	Id *int64 `type:"int64"`

	InstanceId *int64 `type:"int64"`

	JobType *string `type:"string" enum:"EnumOfJobTypeForstopApplicationInput"`

	ProjectId *string `type:"string"`

	UniqueKey *string `type:"string"`

	UserId *string `type:"string"`
}

// String returns the string representation
func (s StopApplicationInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StopApplicationInput) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *StopApplicationInput) SetAccountId(v string) *StopApplicationInput {
	s.AccountId = &v
	return s
}

// SetId sets the Id field's value.
func (s *StopApplicationInput) SetId(v int64) *StopApplicationInput {
	s.Id = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *StopApplicationInput) SetInstanceId(v int64) *StopApplicationInput {
	s.InstanceId = &v
	return s
}

// SetJobType sets the JobType field's value.
func (s *StopApplicationInput) SetJobType(v string) *StopApplicationInput {
	s.JobType = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *StopApplicationInput) SetProjectId(v string) *StopApplicationInput {
	s.ProjectId = &v
	return s
}

// SetUniqueKey sets the UniqueKey field's value.
func (s *StopApplicationInput) SetUniqueKey(v string) *StopApplicationInput {
	s.UniqueKey = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *StopApplicationInput) SetUserId(v string) *StopApplicationInput {
	s.UserId = &v
	return s
}

type StopApplicationOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	Id *string `type:"string"`

	InstanceId *string `type:"string"`

	Status *string `type:"string"`

	Success *bool `type:"boolean"`
}

// String returns the string representation
func (s StopApplicationOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StopApplicationOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *StopApplicationOutput) SetId(v string) *StopApplicationOutput {
	s.Id = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *StopApplicationOutput) SetInstanceId(v string) *StopApplicationOutput {
	s.InstanceId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StopApplicationOutput) SetStatus(v string) *StopApplicationOutput {
	s.Status = &v
	return s
}

// SetSuccess sets the Success field's value.
func (s *StopApplicationOutput) SetSuccess(v bool) *StopApplicationOutput {
	s.Success = &v
	return s
}

const (
	// EnumOfJobTypeForstopApplicationInputFlinkStreamingJar is a EnumOfJobTypeForstopApplicationInput enum value
	EnumOfJobTypeForstopApplicationInputFlinkStreamingJar = "FLINK_STREAMING_JAR"

	// EnumOfJobTypeForstopApplicationInputFlinkStreamingSql is a EnumOfJobTypeForstopApplicationInput enum value
	EnumOfJobTypeForstopApplicationInputFlinkStreamingSql = "FLINK_STREAMING_SQL"

	// EnumOfJobTypeForstopApplicationInputSparkBatchJar is a EnumOfJobTypeForstopApplicationInput enum value
	EnumOfJobTypeForstopApplicationInputSparkBatchJar = "SPARK_BATCH_JAR"

	// EnumOfJobTypeForstopApplicationInputSparkBatchSql is a EnumOfJobTypeForstopApplicationInput enum value
	EnumOfJobTypeForstopApplicationInputSparkBatchSql = "SPARK_BATCH_SQL"

	// EnumOfJobTypeForstopApplicationInputFlinkBatchSql is a EnumOfJobTypeForstopApplicationInput enum value
	EnumOfJobTypeForstopApplicationInputFlinkBatchSql = "FLINK_BATCH_SQL"

	// EnumOfJobTypeForstopApplicationInputRayJob is a EnumOfJobTypeForstopApplicationInput enum value
	EnumOfJobTypeForstopApplicationInputRayJob = "RAY_JOB"

	// EnumOfJobTypeForstopApplicationInputFlinkBatchJar is a EnumOfJobTypeForstopApplicationInput enum value
	EnumOfJobTypeForstopApplicationInputFlinkBatchJar = "FLINK_BATCH_JAR"

	// EnumOfJobTypeForstopApplicationInputPrimusStreamingJob is a EnumOfJobTypeForstopApplicationInput enum value
	EnumOfJobTypeForstopApplicationInputPrimusStreamingJob = "PRIMUS_STREAMING_JOB"

	// EnumOfJobTypeForstopApplicationInputJupyterNotebook is a EnumOfJobTypeForstopApplicationInput enum value
	EnumOfJobTypeForstopApplicationInputJupyterNotebook = "JUPYTER_NOTEBOOK"

	// EnumOfJobTypeForstopApplicationInputSparkBatchPython is a EnumOfJobTypeForstopApplicationInput enum value
	EnumOfJobTypeForstopApplicationInputSparkBatchPython = "SPARK_BATCH_PYTHON"

	// EnumOfJobTypeForstopApplicationInputSyncStreaming is a EnumOfJobTypeForstopApplicationInput enum value
	EnumOfJobTypeForstopApplicationInputSyncStreaming = "SYNC_STREAMING"

	// EnumOfJobTypeForstopApplicationInputSyncBatch is a EnumOfJobTypeForstopApplicationInput enum value
	EnumOfJobTypeForstopApplicationInputSyncBatch = "SYNC_BATCH"
)
