// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package spark

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opModifyApplicationCommon = "modifyApplication"

// ModifyApplicationCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifyApplicationCommon operation. The "output" return
// value will be populated with the ModifyApplicationCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifyApplicationCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifyApplicationCommon Send returns without error.
//
// See ModifyApplicationCommon for more information on using the ModifyApplicationCommon
// API call, and error handling.
//
//	// Example sending a request using the ModifyApplicationCommonRequest method.
//	req, resp := client.ModifyApplicationCommonRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *SPARK) ModifyApplicationCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opModifyApplicationCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ModifyApplicationCommon API operation for SPARK.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for SPARK's
// API operation ModifyApplicationCommon for usage and error information.
func (c *SPARK) ModifyApplicationCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ModifyApplicationCommonRequest(input)
	return out, req.Send()
}

// ModifyApplicationCommonWithContext is the same as ModifyApplicationCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyApplicationCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SPARK) ModifyApplicationCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ModifyApplicationCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyApplication = "modifyApplication"

// ModifyApplicationRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifyApplication operation. The "output" return
// value will be populated with the ModifyApplicationCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifyApplicationCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifyApplicationCommon Send returns without error.
//
// See ModifyApplication for more information on using the ModifyApplication
// API call, and error handling.
//
//	// Example sending a request using the ModifyApplicationRequest method.
//	req, resp := client.ModifyApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *SPARK) ModifyApplicationRequest(input *ModifyApplicationInput) (req *request.Request, output *ModifyApplicationOutput) {
	op := &request.Operation{
		Name:       opModifyApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyApplicationInput{}
	}

	output = &ModifyApplicationOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ModifyApplication API operation for SPARK.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for SPARK's
// API operation ModifyApplication for usage and error information.
func (c *SPARK) ModifyApplication(input *ModifyApplicationInput) (*ModifyApplicationOutput, error) {
	req, out := c.ModifyApplicationRequest(input)
	return out, req.Send()
}

// ModifyApplicationWithContext is the same as ModifyApplication with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SPARK) ModifyApplicationWithContext(ctx volcengine.Context, input *ModifyApplicationInput, opts ...request.Option) (*ModifyApplicationOutput, error) {
	req, out := c.ModifyApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DependencyFormodifyApplicationInput struct {
	_ struct{} `type:"structure"`

	Archives []*string `type:"list"`

	Files []*string `type:"list"`

	Jars []*string `type:"list"`

	PyFiles []*string `type:"list"`
}

// String returns the string representation
func (s DependencyFormodifyApplicationInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DependencyFormodifyApplicationInput) GoString() string {
	return s.String()
}

// SetArchives sets the Archives field's value.
func (s *DependencyFormodifyApplicationInput) SetArchives(v []*string) *DependencyFormodifyApplicationInput {
	s.Archives = v
	return s
}

// SetFiles sets the Files field's value.
func (s *DependencyFormodifyApplicationInput) SetFiles(v []*string) *DependencyFormodifyApplicationInput {
	s.Files = v
	return s
}

// SetJars sets the Jars field's value.
func (s *DependencyFormodifyApplicationInput) SetJars(v []*string) *DependencyFormodifyApplicationInput {
	s.Jars = v
	return s
}

// SetPyFiles sets the PyFiles field's value.
func (s *DependencyFormodifyApplicationInput) SetPyFiles(v []*string) *DependencyFormodifyApplicationInput {
	s.PyFiles = v
	return s
}

type DeployRequestFormodifyApplicationInput struct {
	_ struct{} `type:"structure"`

	Priority *string `type:"string"`

	ResourcePoolTrn *string `type:"string"`

	SchedulePolicy *string `type:"string"`

	ScheduleTimeout *string `type:"string"`
}

// String returns the string representation
func (s DeployRequestFormodifyApplicationInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DeployRequestFormodifyApplicationInput) GoString() string {
	return s.String()
}

// SetPriority sets the Priority field's value.
func (s *DeployRequestFormodifyApplicationInput) SetPriority(v string) *DeployRequestFormodifyApplicationInput {
	s.Priority = &v
	return s
}

// SetResourcePoolTrn sets the ResourcePoolTrn field's value.
func (s *DeployRequestFormodifyApplicationInput) SetResourcePoolTrn(v string) *DeployRequestFormodifyApplicationInput {
	s.ResourcePoolTrn = &v
	return s
}

// SetSchedulePolicy sets the SchedulePolicy field's value.
func (s *DeployRequestFormodifyApplicationInput) SetSchedulePolicy(v string) *DeployRequestFormodifyApplicationInput {
	s.SchedulePolicy = &v
	return s
}

// SetScheduleTimeout sets the ScheduleTimeout field's value.
func (s *DeployRequestFormodifyApplicationInput) SetScheduleTimeout(v string) *DeployRequestFormodifyApplicationInput {
	s.ScheduleTimeout = &v
	return s
}

type ModifyApplicationInput struct {
	_ struct{} `type:"structure"`

	ApplicationTrn *string `type:"string"`

	Args *string `type:"string"`

	Conf map[string]*string `type:"map"`

	Dependency *DependencyFormodifyApplicationInput `type:"structure"`

	DeployRequest *DeployRequestFormodifyApplicationInput `type:"structure"`

	EngineVersion *string `type:"string" enum:"EnumOfEngineVersionFormodifyApplicationInput"`

	Image *string `type:"string"`

	Jar *string `type:"string"`

	JobName *string `type:"string"`

	MainClass *string `type:"string"`

	SqlText *string `type:"string"`

	UniqueKey *string `type:"string"`
}

// String returns the string representation
func (s ModifyApplicationInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyApplicationInput) GoString() string {
	return s.String()
}

// SetApplicationTrn sets the ApplicationTrn field's value.
func (s *ModifyApplicationInput) SetApplicationTrn(v string) *ModifyApplicationInput {
	s.ApplicationTrn = &v
	return s
}

// SetArgs sets the Args field's value.
func (s *ModifyApplicationInput) SetArgs(v string) *ModifyApplicationInput {
	s.Args = &v
	return s
}

// SetConf sets the Conf field's value.
func (s *ModifyApplicationInput) SetConf(v map[string]*string) *ModifyApplicationInput {
	s.Conf = v
	return s
}

// SetDependency sets the Dependency field's value.
func (s *ModifyApplicationInput) SetDependency(v *DependencyFormodifyApplicationInput) *ModifyApplicationInput {
	s.Dependency = v
	return s
}

// SetDeployRequest sets the DeployRequest field's value.
func (s *ModifyApplicationInput) SetDeployRequest(v *DeployRequestFormodifyApplicationInput) *ModifyApplicationInput {
	s.DeployRequest = v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *ModifyApplicationInput) SetEngineVersion(v string) *ModifyApplicationInput {
	s.EngineVersion = &v
	return s
}

// SetImage sets the Image field's value.
func (s *ModifyApplicationInput) SetImage(v string) *ModifyApplicationInput {
	s.Image = &v
	return s
}

// SetJar sets the Jar field's value.
func (s *ModifyApplicationInput) SetJar(v string) *ModifyApplicationInput {
	s.Jar = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *ModifyApplicationInput) SetJobName(v string) *ModifyApplicationInput {
	s.JobName = &v
	return s
}

// SetMainClass sets the MainClass field's value.
func (s *ModifyApplicationInput) SetMainClass(v string) *ModifyApplicationInput {
	s.MainClass = &v
	return s
}

// SetSqlText sets the SqlText field's value.
func (s *ModifyApplicationInput) SetSqlText(v string) *ModifyApplicationInput {
	s.SqlText = &v
	return s
}

// SetUniqueKey sets the UniqueKey field's value.
func (s *ModifyApplicationInput) SetUniqueKey(v string) *ModifyApplicationInput {
	s.UniqueKey = &v
	return s
}

type ModifyApplicationOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	Message *string `type:"string"`

	Status *string `type:"string"`
}

// String returns the string representation
func (s ModifyApplicationOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyApplicationOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ModifyApplicationOutput) SetMessage(v string) *ModifyApplicationOutput {
	s.Message = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ModifyApplicationOutput) SetStatus(v string) *ModifyApplicationOutput {
	s.Status = &v
	return s
}

const (
	// EnumOfEngineVersionFormodifyApplicationInputSparkVersion301Os is a EnumOfEngineVersionFormodifyApplicationInput enum value
	EnumOfEngineVersionFormodifyApplicationInputSparkVersion301Os = "SPARK_VERSION_3_0_1_OS"

	// EnumOfEngineVersionFormodifyApplicationInputSparkVersion322 is a EnumOfEngineVersionFormodifyApplicationInput enum value
	EnumOfEngineVersionFormodifyApplicationInputSparkVersion322 = "SPARK_VERSION_3_2_2"
)
