// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package rdsmysql

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opRecoveryDBInstanceCommon = "RecoveryDBInstance"

// RecoveryDBInstanceCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the RecoveryDBInstanceCommon operation. The "output" return
// value will be populated with the RecoveryDBInstanceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RecoveryDBInstanceCommon Request to send the API call to the service.
// the "output" return value is not valid until after RecoveryDBInstanceCommon Send returns without error.
//
// See RecoveryDBInstanceCommon for more information on using the RecoveryDBInstanceCommon
// API call, and error handling.
//
//    // Example sending a request using the RecoveryDBInstanceCommonRequest method.
//    req, resp := client.RecoveryDBInstanceCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *RDSMYSQL) RecoveryDBInstanceCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opRecoveryDBInstanceCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// RecoveryDBInstanceCommon API operation for RDS_MYSQL.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for RDS_MYSQL's
// API operation RecoveryDBInstanceCommon for usage and error information.
func (c *RDSMYSQL) RecoveryDBInstanceCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.RecoveryDBInstanceCommonRequest(input)
	return out, req.Send()
}

// RecoveryDBInstanceCommonWithContext is the same as RecoveryDBInstanceCommon with the addition of
// the ability to pass a context and additional request options.
//
// See RecoveryDBInstanceCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDSMYSQL) RecoveryDBInstanceCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.RecoveryDBInstanceCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRecoveryDBInstance = "RecoveryDBInstance"

// RecoveryDBInstanceRequest generates a "volcengine/request.Request" representing the
// client's request for the RecoveryDBInstance operation. The "output" return
// value will be populated with the RecoveryDBInstanceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RecoveryDBInstanceCommon Request to send the API call to the service.
// the "output" return value is not valid until after RecoveryDBInstanceCommon Send returns without error.
//
// See RecoveryDBInstance for more information on using the RecoveryDBInstance
// API call, and error handling.
//
//    // Example sending a request using the RecoveryDBInstanceRequest method.
//    req, resp := client.RecoveryDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *RDSMYSQL) RecoveryDBInstanceRequest(input *RecoveryDBInstanceInput) (req *request.Request, output *RecoveryDBInstanceOutput) {
	op := &request.Operation{
		Name:       opRecoveryDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RecoveryDBInstanceInput{}
	}

	output = &RecoveryDBInstanceOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// RecoveryDBInstance API operation for RDS_MYSQL.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for RDS_MYSQL's
// API operation RecoveryDBInstance for usage and error information.
func (c *RDSMYSQL) RecoveryDBInstance(input *RecoveryDBInstanceInput) (*RecoveryDBInstanceOutput, error) {
	req, out := c.RecoveryDBInstanceRequest(input)
	return out, req.Send()
}

// RecoveryDBInstanceWithContext is the same as RecoveryDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RecoveryDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDSMYSQL) RecoveryDBInstanceWithContext(ctx volcengine.Context, input *RecoveryDBInstanceInput, opts ...request.Option) (*RecoveryDBInstanceOutput, error) {
	req, out := c.RecoveryDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type RecoveryDBInstanceInput struct {
	_ struct{} `type:"structure"`

	AutoRenew *bool `type:"boolean"`

	BackupId *string `type:"string"`

	ChargeType *string `type:"string" enum:"EnumOfChargeTypeForRecoveryDBInstanceInput"`

	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	InstanceName *string `type:"string"`

	InstanceSpecName *string `type:"string"`

	PrepaidPeriod *string `type:"string" enum:"EnumOfPrepaidPeriodForRecoveryDBInstanceInput"`

	RecoveryType *string `type:"string" enum:"EnumOfRecoveryTypeForRecoveryDBInstanceInput"`

	RestoreTime *string `type:"string"`

	StorageSpaceGB *int32 `type:"int32"`

	StorageType *string `type:"string" enum:"EnumOfStorageTypeForRecoveryDBInstanceInput"`

	UsedTime *int32 `type:"int32"`

	VpcID *string `type:"string"`
}

// String returns the string representation
func (s RecoveryDBInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RecoveryDBInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecoveryDBInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecoveryDBInstanceInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoRenew sets the AutoRenew field's value.
func (s *RecoveryDBInstanceInput) SetAutoRenew(v bool) *RecoveryDBInstanceInput {
	s.AutoRenew = &v
	return s
}

// SetBackupId sets the BackupId field's value.
func (s *RecoveryDBInstanceInput) SetBackupId(v string) *RecoveryDBInstanceInput {
	s.BackupId = &v
	return s
}

// SetChargeType sets the ChargeType field's value.
func (s *RecoveryDBInstanceInput) SetChargeType(v string) *RecoveryDBInstanceInput {
	s.ChargeType = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *RecoveryDBInstanceInput) SetInstanceId(v string) *RecoveryDBInstanceInput {
	s.InstanceId = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *RecoveryDBInstanceInput) SetInstanceName(v string) *RecoveryDBInstanceInput {
	s.InstanceName = &v
	return s
}

// SetInstanceSpecName sets the InstanceSpecName field's value.
func (s *RecoveryDBInstanceInput) SetInstanceSpecName(v string) *RecoveryDBInstanceInput {
	s.InstanceSpecName = &v
	return s
}

// SetPrepaidPeriod sets the PrepaidPeriod field's value.
func (s *RecoveryDBInstanceInput) SetPrepaidPeriod(v string) *RecoveryDBInstanceInput {
	s.PrepaidPeriod = &v
	return s
}

// SetRecoveryType sets the RecoveryType field's value.
func (s *RecoveryDBInstanceInput) SetRecoveryType(v string) *RecoveryDBInstanceInput {
	s.RecoveryType = &v
	return s
}

// SetRestoreTime sets the RestoreTime field's value.
func (s *RecoveryDBInstanceInput) SetRestoreTime(v string) *RecoveryDBInstanceInput {
	s.RestoreTime = &v
	return s
}

// SetStorageSpaceGB sets the StorageSpaceGB field's value.
func (s *RecoveryDBInstanceInput) SetStorageSpaceGB(v int32) *RecoveryDBInstanceInput {
	s.StorageSpaceGB = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *RecoveryDBInstanceInput) SetStorageType(v string) *RecoveryDBInstanceInput {
	s.StorageType = &v
	return s
}

// SetUsedTime sets the UsedTime field's value.
func (s *RecoveryDBInstanceInput) SetUsedTime(v int32) *RecoveryDBInstanceInput {
	s.UsedTime = &v
	return s
}

// SetVpcID sets the VpcID field's value.
func (s *RecoveryDBInstanceInput) SetVpcID(v string) *RecoveryDBInstanceInput {
	s.VpcID = &v
	return s
}

type RecoveryDBInstanceOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	InstanceId *string `type:"string"`
}

// String returns the string representation
func (s RecoveryDBInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RecoveryDBInstanceOutput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *RecoveryDBInstanceOutput) SetInstanceId(v string) *RecoveryDBInstanceOutput {
	s.InstanceId = &v
	return s
}

const (
	// EnumOfChargeTypeForRecoveryDBInstanceInputNotEnabled is a EnumOfChargeTypeForRecoveryDBInstanceInput enum value
	EnumOfChargeTypeForRecoveryDBInstanceInputNotEnabled = "NotEnabled"

	// EnumOfChargeTypeForRecoveryDBInstanceInputPostPaid is a EnumOfChargeTypeForRecoveryDBInstanceInput enum value
	EnumOfChargeTypeForRecoveryDBInstanceInputPostPaid = "PostPaid"

	// EnumOfChargeTypeForRecoveryDBInstanceInputPrepaid is a EnumOfChargeTypeForRecoveryDBInstanceInput enum value
	EnumOfChargeTypeForRecoveryDBInstanceInputPrepaid = "Prepaid"
)

const (
	// EnumOfPrepaidPeriodForRecoveryDBInstanceInputMonth is a EnumOfPrepaidPeriodForRecoveryDBInstanceInput enum value
	EnumOfPrepaidPeriodForRecoveryDBInstanceInputMonth = "Month"

	// EnumOfPrepaidPeriodForRecoveryDBInstanceInputYear is a EnumOfPrepaidPeriodForRecoveryDBInstanceInput enum value
	EnumOfPrepaidPeriodForRecoveryDBInstanceInputYear = "Year"
)

const (
	// EnumOfRecoveryTypeForRecoveryDBInstanceInputInstance is a EnumOfRecoveryTypeForRecoveryDBInstanceInput enum value
	EnumOfRecoveryTypeForRecoveryDBInstanceInputInstance = "Instance"
)

const (
	// EnumOfStorageTypeForRecoveryDBInstanceInputCloudStorage is a EnumOfStorageTypeForRecoveryDBInstanceInput enum value
	EnumOfStorageTypeForRecoveryDBInstanceInputCloudStorage = "CloudStorage"

	// EnumOfStorageTypeForRecoveryDBInstanceInputEssdpl1 is a EnumOfStorageTypeForRecoveryDBInstanceInput enum value
	EnumOfStorageTypeForRecoveryDBInstanceInputEssdpl1 = "ESSDPL1"

	// EnumOfStorageTypeForRecoveryDBInstanceInputEssdpl2 is a EnumOfStorageTypeForRecoveryDBInstanceInput enum value
	EnumOfStorageTypeForRecoveryDBInstanceInputEssdpl2 = "ESSDPL2"

	// EnumOfStorageTypeForRecoveryDBInstanceInputLocalSsd is a EnumOfStorageTypeForRecoveryDBInstanceInput enum value
	EnumOfStorageTypeForRecoveryDBInstanceInputLocalSsd = "LocalSSD"
)
