// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package rdsmysql

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeDBInstanceConnectionCommon = "DescribeDBInstanceConnection"

// DescribeDBInstanceConnectionCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeDBInstanceConnectionCommon operation. The "output" return
// value will be populated with the DescribeDBInstanceConnectionCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeDBInstanceConnectionCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeDBInstanceConnectionCommon Send returns without error.
//
// See DescribeDBInstanceConnectionCommon for more information on using the DescribeDBInstanceConnectionCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeDBInstanceConnectionCommonRequest method.
//    req, resp := client.DescribeDBInstanceConnectionCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *RDSMYSQL) DescribeDBInstanceConnectionCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeDBInstanceConnectionCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeDBInstanceConnectionCommon API operation for RDS_MYSQL.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for RDS_MYSQL's
// API operation DescribeDBInstanceConnectionCommon for usage and error information.
func (c *RDSMYSQL) DescribeDBInstanceConnectionCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeDBInstanceConnectionCommonRequest(input)
	return out, req.Send()
}

// DescribeDBInstanceConnectionCommonWithContext is the same as DescribeDBInstanceConnectionCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBInstanceConnectionCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDSMYSQL) DescribeDBInstanceConnectionCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeDBInstanceConnectionCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBInstanceConnection = "DescribeDBInstanceConnection"

// DescribeDBInstanceConnectionRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeDBInstanceConnection operation. The "output" return
// value will be populated with the DescribeDBInstanceConnectionCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeDBInstanceConnectionCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeDBInstanceConnectionCommon Send returns without error.
//
// See DescribeDBInstanceConnection for more information on using the DescribeDBInstanceConnection
// API call, and error handling.
//
//    // Example sending a request using the DescribeDBInstanceConnectionRequest method.
//    req, resp := client.DescribeDBInstanceConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *RDSMYSQL) DescribeDBInstanceConnectionRequest(input *DescribeDBInstanceConnectionInput) (req *request.Request, output *DescribeDBInstanceConnectionOutput) {
	op := &request.Operation{
		Name:       opDescribeDBInstanceConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBInstanceConnectionInput{}
	}

	output = &DescribeDBInstanceConnectionOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeDBInstanceConnection API operation for RDS_MYSQL.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for RDS_MYSQL's
// API operation DescribeDBInstanceConnection for usage and error information.
func (c *RDSMYSQL) DescribeDBInstanceConnection(input *DescribeDBInstanceConnectionInput) (*DescribeDBInstanceConnectionOutput, error) {
	req, out := c.DescribeDBInstanceConnectionRequest(input)
	return out, req.Send()
}

// DescribeDBInstanceConnectionWithContext is the same as DescribeDBInstanceConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBInstanceConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDSMYSQL) DescribeDBInstanceConnectionWithContext(ctx volcengine.Context, input *DescribeDBInstanceConnectionInput, opts ...request.Option) (*DescribeDBInstanceConnectionOutput, error) {
	req, out := c.DescribeDBInstanceConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ConnectionInfoForDescribeDBInstanceConnectionOutput struct {
	_ struct{} `type:"structure"`

	EnableReadOnly *string `type:"string" enum:"EnumOfEnableReadOnlyForDescribeDBInstanceConnectionOutput"`

	EnableReadWriteSplitting *string `type:"string" enum:"EnumOfEnableReadWriteSplittingForDescribeDBInstanceConnectionOutput"`

	InternalDomain *string `type:"string"`

	InternalPort *string `type:"string"`

	PublicDomain *string `type:"string"`

	PublicPort *string `type:"string"`
}

// String returns the string representation
func (s ConnectionInfoForDescribeDBInstanceConnectionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectionInfoForDescribeDBInstanceConnectionOutput) GoString() string {
	return s.String()
}

// SetEnableReadOnly sets the EnableReadOnly field's value.
func (s *ConnectionInfoForDescribeDBInstanceConnectionOutput) SetEnableReadOnly(v string) *ConnectionInfoForDescribeDBInstanceConnectionOutput {
	s.EnableReadOnly = &v
	return s
}

// SetEnableReadWriteSplitting sets the EnableReadWriteSplitting field's value.
func (s *ConnectionInfoForDescribeDBInstanceConnectionOutput) SetEnableReadWriteSplitting(v string) *ConnectionInfoForDescribeDBInstanceConnectionOutput {
	s.EnableReadWriteSplitting = &v
	return s
}

// SetInternalDomain sets the InternalDomain field's value.
func (s *ConnectionInfoForDescribeDBInstanceConnectionOutput) SetInternalDomain(v string) *ConnectionInfoForDescribeDBInstanceConnectionOutput {
	s.InternalDomain = &v
	return s
}

// SetInternalPort sets the InternalPort field's value.
func (s *ConnectionInfoForDescribeDBInstanceConnectionOutput) SetInternalPort(v string) *ConnectionInfoForDescribeDBInstanceConnectionOutput {
	s.InternalPort = &v
	return s
}

// SetPublicDomain sets the PublicDomain field's value.
func (s *ConnectionInfoForDescribeDBInstanceConnectionOutput) SetPublicDomain(v string) *ConnectionInfoForDescribeDBInstanceConnectionOutput {
	s.PublicDomain = &v
	return s
}

// SetPublicPort sets the PublicPort field's value.
func (s *ConnectionInfoForDescribeDBInstanceConnectionOutput) SetPublicPort(v string) *ConnectionInfoForDescribeDBInstanceConnectionOutput {
	s.PublicPort = &v
	return s
}

type DescribeDBInstanceConnectionInput struct {
	_ struct{} `type:"structure"`

	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDBInstanceConnectionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBInstanceConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBInstanceConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBInstanceConnectionInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeDBInstanceConnectionInput) SetInstanceId(v string) *DescribeDBInstanceConnectionInput {
	s.InstanceId = &v
	return s
}

type DescribeDBInstanceConnectionOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	ConnectionInfo *ConnectionInfoForDescribeDBInstanceConnectionOutput `type:"structure"`
}

// String returns the string representation
func (s DescribeDBInstanceConnectionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBInstanceConnectionOutput) GoString() string {
	return s.String()
}

// SetConnectionInfo sets the ConnectionInfo field's value.
func (s *DescribeDBInstanceConnectionOutput) SetConnectionInfo(v *ConnectionInfoForDescribeDBInstanceConnectionOutput) *DescribeDBInstanceConnectionOutput {
	s.ConnectionInfo = v
	return s
}

const (
	// EnumOfEnableReadOnlyForDescribeDBInstanceConnectionOutputDisable is a EnumOfEnableReadOnlyForDescribeDBInstanceConnectionOutput enum value
	EnumOfEnableReadOnlyForDescribeDBInstanceConnectionOutputDisable = "Disable"

	// EnumOfEnableReadOnlyForDescribeDBInstanceConnectionOutputEnable is a EnumOfEnableReadOnlyForDescribeDBInstanceConnectionOutput enum value
	EnumOfEnableReadOnlyForDescribeDBInstanceConnectionOutputEnable = "Enable"
)

const (
	// EnumOfEnableReadWriteSplittingForDescribeDBInstanceConnectionOutputDisable is a EnumOfEnableReadWriteSplittingForDescribeDBInstanceConnectionOutput enum value
	EnumOfEnableReadWriteSplittingForDescribeDBInstanceConnectionOutputDisable = "Disable"

	// EnumOfEnableReadWriteSplittingForDescribeDBInstanceConnectionOutputEnable is a EnumOfEnableReadWriteSplittingForDescribeDBInstanceConnectionOutput enum value
	EnumOfEnableReadWriteSplittingForDescribeDBInstanceConnectionOutputEnable = "Enable"
)
