// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package natgateway

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateDnatEntryCommon = "CreateDnatEntry"

// CreateDnatEntryCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDnatEntryCommon operation. The "output" return
// value will be populated with the CreateDnatEntryCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDnatEntryCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDnatEntryCommon Send returns without error.
//
// See CreateDnatEntryCommon for more information on using the CreateDnatEntryCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateDnatEntryCommonRequest method.
//    req, resp := client.CreateDnatEntryCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *NATGATEWAY) CreateDnatEntryCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateDnatEntryCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// CreateDnatEntryCommon API operation for NATGATEWAY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for NATGATEWAY's
// API operation CreateDnatEntryCommon for usage and error information.
func (c *NATGATEWAY) CreateDnatEntryCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateDnatEntryCommonRequest(input)
	return out, req.Send()
}

// CreateDnatEntryCommonWithContext is the same as CreateDnatEntryCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDnatEntryCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NATGATEWAY) CreateDnatEntryCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateDnatEntryCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDnatEntry = "CreateDnatEntry"

// CreateDnatEntryRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDnatEntry operation. The "output" return
// value will be populated with the CreateDnatEntryCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDnatEntryCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDnatEntryCommon Send returns without error.
//
// See CreateDnatEntry for more information on using the CreateDnatEntry
// API call, and error handling.
//
//    // Example sending a request using the CreateDnatEntryRequest method.
//    req, resp := client.CreateDnatEntryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *NATGATEWAY) CreateDnatEntryRequest(input *CreateDnatEntryInput) (req *request.Request, output *CreateDnatEntryOutput) {
	op := &request.Operation{
		Name:       opCreateDnatEntry,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDnatEntryInput{}
	}

	output = &CreateDnatEntryOutput{}
	req = c.newRequest(op, input, output)

	return
}

// CreateDnatEntry API operation for NATGATEWAY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for NATGATEWAY's
// API operation CreateDnatEntry for usage and error information.
func (c *NATGATEWAY) CreateDnatEntry(input *CreateDnatEntryInput) (*CreateDnatEntryOutput, error) {
	req, out := c.CreateDnatEntryRequest(input)
	return out, req.Send()
}

// CreateDnatEntryWithContext is the same as CreateDnatEntry with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDnatEntry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NATGATEWAY) CreateDnatEntryWithContext(ctx volcengine.Context, input *CreateDnatEntryInput, opts ...request.Option) (*CreateDnatEntryOutput, error) {
	req, out := c.CreateDnatEntryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateDnatEntryInput struct {
	_ struct{} `type:"structure"`

	DnatEntryName *string `min:"1" max:"128" type:"string"`

	// ExternalIp is a required field
	ExternalIp *string `type:"string" required:"true"`

	// ExternalPort is a required field
	ExternalPort *string `type:"string" required:"true"`

	// InternalIp is a required field
	InternalIp *string `type:"string" required:"true"`

	// InternalPort is a required field
	InternalPort *string `type:"string" required:"true"`

	// NatGatewayId is a required field
	NatGatewayId *string `type:"string" required:"true"`

	PortType *string `type:"string"`

	// Protocol is a required field
	Protocol *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDnatEntryInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDnatEntryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDnatEntryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDnatEntryInput"}
	if s.DnatEntryName != nil && len(*s.DnatEntryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DnatEntryName", 1))
	}
	if s.DnatEntryName != nil && len(*s.DnatEntryName) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("DnatEntryName", 128, *s.DnatEntryName))
	}
	if s.ExternalIp == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalIp"))
	}
	if s.ExternalPort == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalPort"))
	}
	if s.InternalIp == nil {
		invalidParams.Add(request.NewErrParamRequired("InternalIp"))
	}
	if s.InternalPort == nil {
		invalidParams.Add(request.NewErrParamRequired("InternalPort"))
	}
	if s.NatGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("NatGatewayId"))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDnatEntryName sets the DnatEntryName field's value.
func (s *CreateDnatEntryInput) SetDnatEntryName(v string) *CreateDnatEntryInput {
	s.DnatEntryName = &v
	return s
}

// SetExternalIp sets the ExternalIp field's value.
func (s *CreateDnatEntryInput) SetExternalIp(v string) *CreateDnatEntryInput {
	s.ExternalIp = &v
	return s
}

// SetExternalPort sets the ExternalPort field's value.
func (s *CreateDnatEntryInput) SetExternalPort(v string) *CreateDnatEntryInput {
	s.ExternalPort = &v
	return s
}

// SetInternalIp sets the InternalIp field's value.
func (s *CreateDnatEntryInput) SetInternalIp(v string) *CreateDnatEntryInput {
	s.InternalIp = &v
	return s
}

// SetInternalPort sets the InternalPort field's value.
func (s *CreateDnatEntryInput) SetInternalPort(v string) *CreateDnatEntryInput {
	s.InternalPort = &v
	return s
}

// SetNatGatewayId sets the NatGatewayId field's value.
func (s *CreateDnatEntryInput) SetNatGatewayId(v string) *CreateDnatEntryInput {
	s.NatGatewayId = &v
	return s
}

// SetPortType sets the PortType field's value.
func (s *CreateDnatEntryInput) SetPortType(v string) *CreateDnatEntryInput {
	s.PortType = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *CreateDnatEntryInput) SetProtocol(v string) *CreateDnatEntryInput {
	s.Protocol = &v
	return s
}

type CreateDnatEntryOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	DnatEntryId *string `type:"string"`

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s CreateDnatEntryOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDnatEntryOutput) GoString() string {
	return s.String()
}

// SetDnatEntryId sets the DnatEntryId field's value.
func (s *CreateDnatEntryOutput) SetDnatEntryId(v string) *CreateDnatEntryOutput {
	s.DnatEntryId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateDnatEntryOutput) SetRequestId(v string) *CreateDnatEntryOutput {
	s.RequestId = &v
	return s
}
