// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mongodb

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeBackupsCommon = "DescribeBackups"

// DescribeBackupsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeBackupsCommon operation. The "output" return
// value will be populated with the DescribeBackupsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeBackupsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeBackupsCommon Send returns without error.
//
// See DescribeBackupsCommon for more information on using the DescribeBackupsCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeBackupsCommonRequest method.
//    req, resp := client.DescribeBackupsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MONGODB) DescribeBackupsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeBackupsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeBackupsCommon API operation for MONGODB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for MONGODB's
// API operation DescribeBackupsCommon for usage and error information.
func (c *MONGODB) DescribeBackupsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeBackupsCommonRequest(input)
	return out, req.Send()
}

// DescribeBackupsCommonWithContext is the same as DescribeBackupsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBackupsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MONGODB) DescribeBackupsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeBackupsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBackups = "DescribeBackups"

// DescribeBackupsRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeBackups operation. The "output" return
// value will be populated with the DescribeBackupsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeBackupsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeBackupsCommon Send returns without error.
//
// See DescribeBackups for more information on using the DescribeBackups
// API call, and error handling.
//
//    // Example sending a request using the DescribeBackupsRequest method.
//    req, resp := client.DescribeBackupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MONGODB) DescribeBackupsRequest(input *DescribeBackupsInput) (req *request.Request, output *DescribeBackupsOutput) {
	op := &request.Operation{
		Name:       opDescribeBackups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBackupsInput{}
	}

	output = &DescribeBackupsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeBackups API operation for MONGODB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for MONGODB's
// API operation DescribeBackups for usage and error information.
func (c *MONGODB) DescribeBackups(input *DescribeBackupsInput) (*DescribeBackupsOutput, error) {
	req, out := c.DescribeBackupsRequest(input)
	return out, req.Send()
}

// DescribeBackupsWithContext is the same as DescribeBackups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBackups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MONGODB) DescribeBackupsWithContext(ctx volcengine.Context, input *DescribeBackupsInput, opts ...request.Option) (*DescribeBackupsOutput, error) {
	req, out := c.DescribeBackupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type BackupForDescribeBackupsOutput struct {
	_ struct{} `type:"structure"`

	BackupDownloadStatus *string `type:"string" enum:"EnumOfBackupDownloadStatusForDescribeBackupsOutput"`

	BackupEndTime *string `type:"string"`

	BackupFileName *string `type:"string"`

	BackupFileSize *int64 `type:"int64"`

	BackupId *string `type:"string"`

	BackupObject *string `type:"string" enum:"EnumOfBackupObjectForDescribeBackupsOutput"`

	BackupStartTime *string `type:"string"`

	BackupStatus *string `type:"string" enum:"EnumOfBackupStatusForDescribeBackupsOutput"`

	BackupType *string `type:"string" enum:"EnumOfBackupTypeForDescribeBackupsOutput"`

	Creator *string `type:"string" enum:"EnumOfCreatorForDescribeBackupsOutput"`
}

// String returns the string representation
func (s BackupForDescribeBackupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BackupForDescribeBackupsOutput) GoString() string {
	return s.String()
}

// SetBackupDownloadStatus sets the BackupDownloadStatus field's value.
func (s *BackupForDescribeBackupsOutput) SetBackupDownloadStatus(v string) *BackupForDescribeBackupsOutput {
	s.BackupDownloadStatus = &v
	return s
}

// SetBackupEndTime sets the BackupEndTime field's value.
func (s *BackupForDescribeBackupsOutput) SetBackupEndTime(v string) *BackupForDescribeBackupsOutput {
	s.BackupEndTime = &v
	return s
}

// SetBackupFileName sets the BackupFileName field's value.
func (s *BackupForDescribeBackupsOutput) SetBackupFileName(v string) *BackupForDescribeBackupsOutput {
	s.BackupFileName = &v
	return s
}

// SetBackupFileSize sets the BackupFileSize field's value.
func (s *BackupForDescribeBackupsOutput) SetBackupFileSize(v int64) *BackupForDescribeBackupsOutput {
	s.BackupFileSize = &v
	return s
}

// SetBackupId sets the BackupId field's value.
func (s *BackupForDescribeBackupsOutput) SetBackupId(v string) *BackupForDescribeBackupsOutput {
	s.BackupId = &v
	return s
}

// SetBackupObject sets the BackupObject field's value.
func (s *BackupForDescribeBackupsOutput) SetBackupObject(v string) *BackupForDescribeBackupsOutput {
	s.BackupObject = &v
	return s
}

// SetBackupStartTime sets the BackupStartTime field's value.
func (s *BackupForDescribeBackupsOutput) SetBackupStartTime(v string) *BackupForDescribeBackupsOutput {
	s.BackupStartTime = &v
	return s
}

// SetBackupStatus sets the BackupStatus field's value.
func (s *BackupForDescribeBackupsOutput) SetBackupStatus(v string) *BackupForDescribeBackupsOutput {
	s.BackupStatus = &v
	return s
}

// SetBackupType sets the BackupType field's value.
func (s *BackupForDescribeBackupsOutput) SetBackupType(v string) *BackupForDescribeBackupsOutput {
	s.BackupType = &v
	return s
}

// SetCreator sets the Creator field's value.
func (s *BackupForDescribeBackupsOutput) SetCreator(v string) *BackupForDescribeBackupsOutput {
	s.Creator = &v
	return s
}

type DescribeBackupsInput struct {
	_ struct{} `type:"structure"`

	BackupObject *string `type:"string" enum:"EnumOfBackupObjectForDescribeBackupsInput"`

	BackupStatus *string `type:"string" enum:"EnumOfBackupStatusForDescribeBackupsInput"`

	BackupType *string `type:"string" enum:"EnumOfBackupTypeForDescribeBackupsInput"`

	EndTime *string `type:"string"`

	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	PageNumber *int32 `type:"int32"`

	PageSize *int32 `type:"int32"`

	StartTime *string `type:"string"`
}

// String returns the string representation
func (s DescribeBackupsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBackupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBackupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBackupsInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupObject sets the BackupObject field's value.
func (s *DescribeBackupsInput) SetBackupObject(v string) *DescribeBackupsInput {
	s.BackupObject = &v
	return s
}

// SetBackupStatus sets the BackupStatus field's value.
func (s *DescribeBackupsInput) SetBackupStatus(v string) *DescribeBackupsInput {
	s.BackupStatus = &v
	return s
}

// SetBackupType sets the BackupType field's value.
func (s *DescribeBackupsInput) SetBackupType(v string) *DescribeBackupsInput {
	s.BackupType = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeBackupsInput) SetEndTime(v string) *DescribeBackupsInput {
	s.EndTime = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeBackupsInput) SetInstanceId(v string) *DescribeBackupsInput {
	s.InstanceId = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeBackupsInput) SetPageNumber(v int32) *DescribeBackupsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeBackupsInput) SetPageSize(v int32) *DescribeBackupsInput {
	s.PageSize = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeBackupsInput) SetStartTime(v string) *DescribeBackupsInput {
	s.StartTime = &v
	return s
}

type DescribeBackupsOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	Backups []*BackupForDescribeBackupsOutput `type:"list"`

	Total *int32 `type:"int32"`
}

// String returns the string representation
func (s DescribeBackupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBackupsOutput) GoString() string {
	return s.String()
}

// SetBackups sets the Backups field's value.
func (s *DescribeBackupsOutput) SetBackups(v []*BackupForDescribeBackupsOutput) *DescribeBackupsOutput {
	s.Backups = v
	return s
}

// SetTotal sets the Total field's value.
func (s *DescribeBackupsOutput) SetTotal(v int32) *DescribeBackupsOutput {
	s.Total = &v
	return s
}

const (
	// EnumOfBackupDownloadStatusForDescribeBackupsOutputNotDownLoad is a EnumOfBackupDownloadStatusForDescribeBackupsOutput enum value
	EnumOfBackupDownloadStatusForDescribeBackupsOutputNotDownLoad = "NotDownLoad"

	// EnumOfBackupDownloadStatusForDescribeBackupsOutputSuccess is a EnumOfBackupDownloadStatusForDescribeBackupsOutput enum value
	EnumOfBackupDownloadStatusForDescribeBackupsOutputSuccess = "Success"

	// EnumOfBackupDownloadStatusForDescribeBackupsOutputRunning is a EnumOfBackupDownloadStatusForDescribeBackupsOutput enum value
	EnumOfBackupDownloadStatusForDescribeBackupsOutputRunning = "Running"
)

const (
	// EnumOfBackupObjectForDescribeBackupsInputData is a EnumOfBackupObjectForDescribeBackupsInput enum value
	EnumOfBackupObjectForDescribeBackupsInputData = "Data"

	// EnumOfBackupObjectForDescribeBackupsInputLog is a EnumOfBackupObjectForDescribeBackupsInput enum value
	EnumOfBackupObjectForDescribeBackupsInputLog = "Log"
)

const (
	// EnumOfBackupObjectForDescribeBackupsOutputData is a EnumOfBackupObjectForDescribeBackupsOutput enum value
	EnumOfBackupObjectForDescribeBackupsOutputData = "Data"

	// EnumOfBackupObjectForDescribeBackupsOutputLog is a EnumOfBackupObjectForDescribeBackupsOutput enum value
	EnumOfBackupObjectForDescribeBackupsOutputLog = "Log"
)

const (
	// EnumOfBackupStatusForDescribeBackupsInputSuccess is a EnumOfBackupStatusForDescribeBackupsInput enum value
	EnumOfBackupStatusForDescribeBackupsInputSuccess = "Success"

	// EnumOfBackupStatusForDescribeBackupsInputFailed is a EnumOfBackupStatusForDescribeBackupsInput enum value
	EnumOfBackupStatusForDescribeBackupsInputFailed = "Failed"

	// EnumOfBackupStatusForDescribeBackupsInputRunning is a EnumOfBackupStatusForDescribeBackupsInput enum value
	EnumOfBackupStatusForDescribeBackupsInputRunning = "Running"
)

const (
	// EnumOfBackupStatusForDescribeBackupsOutputSuccess is a EnumOfBackupStatusForDescribeBackupsOutput enum value
	EnumOfBackupStatusForDescribeBackupsOutputSuccess = "Success"

	// EnumOfBackupStatusForDescribeBackupsOutputFailed is a EnumOfBackupStatusForDescribeBackupsOutput enum value
	EnumOfBackupStatusForDescribeBackupsOutputFailed = "Failed"

	// EnumOfBackupStatusForDescribeBackupsOutputRunning is a EnumOfBackupStatusForDescribeBackupsOutput enum value
	EnumOfBackupStatusForDescribeBackupsOutputRunning = "Running"
)

const (
	// EnumOfBackupTypeForDescribeBackupsInputLogical is a EnumOfBackupTypeForDescribeBackupsInput enum value
	EnumOfBackupTypeForDescribeBackupsInputLogical = "Logical"

	// EnumOfBackupTypeForDescribeBackupsInputPhysical is a EnumOfBackupTypeForDescribeBackupsInput enum value
	EnumOfBackupTypeForDescribeBackupsInputPhysical = "Physical"
)

const (
	// EnumOfBackupTypeForDescribeBackupsOutputLogical is a EnumOfBackupTypeForDescribeBackupsOutput enum value
	EnumOfBackupTypeForDescribeBackupsOutputLogical = "Logical"

	// EnumOfBackupTypeForDescribeBackupsOutputPhysical is a EnumOfBackupTypeForDescribeBackupsOutput enum value
	EnumOfBackupTypeForDescribeBackupsOutputPhysical = "Physical"
)

const (
	// EnumOfCreatorForDescribeBackupsOutputSystem is a EnumOfCreatorForDescribeBackupsOutput enum value
	EnumOfCreatorForDescribeBackupsOutputSystem = "System"

	// EnumOfCreatorForDescribeBackupsOutputUser is a EnumOfCreatorForDescribeBackupsOutput enum value
	EnumOfCreatorForDescribeBackupsOutputUser = "User"
)
