// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opUpdateKeyCommon = "UpdateKey"

// UpdateKeyCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateKeyCommon operation. The "output" return
// value will be populated with the UpdateKeyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateKeyCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateKeyCommon Send returns without error.
//
// See UpdateKeyCommon for more information on using the UpdateKeyCommon
// API call, and error handling.
//
//    // Example sending a request using the UpdateKeyCommonRequest method.
//    req, resp := client.UpdateKeyCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) UpdateKeyCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opUpdateKeyCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateKeyCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation UpdateKeyCommon for usage and error information.
func (c *KMS) UpdateKeyCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.UpdateKeyCommonRequest(input)
	return out, req.Send()
}

// UpdateKeyCommonWithContext is the same as UpdateKeyCommon with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateKeyCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) UpdateKeyCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.UpdateKeyCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateKey = "UpdateKey"

// UpdateKeyRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateKey operation. The "output" return
// value will be populated with the UpdateKeyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateKeyCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateKeyCommon Send returns without error.
//
// See UpdateKey for more information on using the UpdateKey
// API call, and error handling.
//
//    // Example sending a request using the UpdateKeyRequest method.
//    req, resp := client.UpdateKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) UpdateKeyRequest(input *UpdateKeyInput) (req *request.Request, output *UpdateKeyOutput) {
	op := &request.Operation{
		Name:       opUpdateKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateKeyInput{}
	}

	output = &UpdateKeyOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateKey API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation UpdateKey for usage and error information.
func (c *KMS) UpdateKey(input *UpdateKeyInput) (*UpdateKeyOutput, error) {
	req, out := c.UpdateKeyRequest(input)
	return out, req.Send()
}

// UpdateKeyWithContext is the same as UpdateKey with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) UpdateKeyWithContext(ctx volcengine.Context, input *UpdateKeyInput, opts ...request.Option) (*UpdateKeyOutput, error) {
	req, out := c.UpdateKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type UpdateKeyInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `max:"8192" type:"string" json:",omitempty"`

	KeyID *string `type:"string" json:",omitempty"`

	KeyName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	KeyringName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	NewKeyName *string `min:"2" max:"31" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s UpdateKeyInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateKeyInput"}
	if s.Description != nil && len(*s.Description) > 8192 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 8192, *s.Description))
	}
	if s.KeyName != nil && len(*s.KeyName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 2))
	}
	if s.KeyName != nil && len(*s.KeyName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyName", 31, *s.KeyName))
	}
	if s.KeyringName != nil && len(*s.KeyringName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyringName", 2))
	}
	if s.KeyringName != nil && len(*s.KeyringName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyringName", 31, *s.KeyringName))
	}
	if s.NewKeyName != nil && len(*s.NewKeyName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("NewKeyName", 2))
	}
	if s.NewKeyName != nil && len(*s.NewKeyName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("NewKeyName", 31, *s.NewKeyName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateKeyInput) SetDescription(v string) *UpdateKeyInput {
	s.Description = &v
	return s
}

// SetKeyID sets the KeyID field's value.
func (s *UpdateKeyInput) SetKeyID(v string) *UpdateKeyInput {
	s.KeyID = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *UpdateKeyInput) SetKeyName(v string) *UpdateKeyInput {
	s.KeyName = &v
	return s
}

// SetKeyringName sets the KeyringName field's value.
func (s *UpdateKeyInput) SetKeyringName(v string) *UpdateKeyInput {
	s.KeyringName = &v
	return s
}

// SetNewKeyName sets the NewKeyName field's value.
func (s *UpdateKeyInput) SetNewKeyName(v string) *UpdateKeyInput {
	s.NewKeyName = &v
	return s
}

type UpdateKeyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s UpdateKeyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateKeyOutput) GoString() string {
	return s.String()
}
