// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opImportKeyMaterialCommon = "ImportKeyMaterial"

// ImportKeyMaterialCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ImportKeyMaterialCommon operation. The "output" return
// value will be populated with the ImportKeyMaterialCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ImportKeyMaterialCommon Request to send the API call to the service.
// the "output" return value is not valid until after ImportKeyMaterialCommon Send returns without error.
//
// See ImportKeyMaterialCommon for more information on using the ImportKeyMaterialCommon
// API call, and error handling.
//
//    // Example sending a request using the ImportKeyMaterialCommonRequest method.
//    req, resp := client.ImportKeyMaterialCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) ImportKeyMaterialCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opImportKeyMaterialCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ImportKeyMaterialCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation ImportKeyMaterialCommon for usage and error information.
func (c *KMS) ImportKeyMaterialCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ImportKeyMaterialCommonRequest(input)
	return out, req.Send()
}

// ImportKeyMaterialCommonWithContext is the same as ImportKeyMaterialCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ImportKeyMaterialCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ImportKeyMaterialCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ImportKeyMaterialCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportKeyMaterial = "ImportKeyMaterial"

// ImportKeyMaterialRequest generates a "volcengine/request.Request" representing the
// client's request for the ImportKeyMaterial operation. The "output" return
// value will be populated with the ImportKeyMaterialCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ImportKeyMaterialCommon Request to send the API call to the service.
// the "output" return value is not valid until after ImportKeyMaterialCommon Send returns without error.
//
// See ImportKeyMaterial for more information on using the ImportKeyMaterial
// API call, and error handling.
//
//    // Example sending a request using the ImportKeyMaterialRequest method.
//    req, resp := client.ImportKeyMaterialRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) ImportKeyMaterialRequest(input *ImportKeyMaterialInput) (req *request.Request, output *ImportKeyMaterialOutput) {
	op := &request.Operation{
		Name:       opImportKeyMaterial,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportKeyMaterialInput{}
	}

	output = &ImportKeyMaterialOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ImportKeyMaterial API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation ImportKeyMaterial for usage and error information.
func (c *KMS) ImportKeyMaterial(input *ImportKeyMaterialInput) (*ImportKeyMaterialOutput, error) {
	req, out := c.ImportKeyMaterialRequest(input)
	return out, req.Send()
}

// ImportKeyMaterialWithContext is the same as ImportKeyMaterial with the addition of
// the ability to pass a context and additional request options.
//
// See ImportKeyMaterial for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ImportKeyMaterialWithContext(ctx volcengine.Context, input *ImportKeyMaterialInput, opts ...request.Option) (*ImportKeyMaterialOutput, error) {
	req, out := c.ImportKeyMaterialRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ImportKeyMaterialInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// EncryptedKeyMaterial is a required field
	EncryptedKeyMaterial *string `type:"string" json:",omitempty" required:"true"`

	ExpirationModel *string `type:"string" json:",omitempty"`

	// ImportToken is a required field
	ImportToken *string `type:"string" json:",omitempty" required:"true"`

	KeyID *string `type:"string" json:",omitempty"`

	KeyName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	KeyringName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	ValidTo *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ImportKeyMaterialInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportKeyMaterialInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportKeyMaterialInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportKeyMaterialInput"}
	if s.EncryptedKeyMaterial == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptedKeyMaterial"))
	}
	if s.ImportToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportToken"))
	}
	if s.KeyName != nil && len(*s.KeyName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 2))
	}
	if s.KeyName != nil && len(*s.KeyName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyName", 31, *s.KeyName))
	}
	if s.KeyringName != nil && len(*s.KeyringName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyringName", 2))
	}
	if s.KeyringName != nil && len(*s.KeyringName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyringName", 31, *s.KeyringName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptedKeyMaterial sets the EncryptedKeyMaterial field's value.
func (s *ImportKeyMaterialInput) SetEncryptedKeyMaterial(v string) *ImportKeyMaterialInput {
	s.EncryptedKeyMaterial = &v
	return s
}

// SetExpirationModel sets the ExpirationModel field's value.
func (s *ImportKeyMaterialInput) SetExpirationModel(v string) *ImportKeyMaterialInput {
	s.ExpirationModel = &v
	return s
}

// SetImportToken sets the ImportToken field's value.
func (s *ImportKeyMaterialInput) SetImportToken(v string) *ImportKeyMaterialInput {
	s.ImportToken = &v
	return s
}

// SetKeyID sets the KeyID field's value.
func (s *ImportKeyMaterialInput) SetKeyID(v string) *ImportKeyMaterialInput {
	s.KeyID = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *ImportKeyMaterialInput) SetKeyName(v string) *ImportKeyMaterialInput {
	s.KeyName = &v
	return s
}

// SetKeyringName sets the KeyringName field's value.
func (s *ImportKeyMaterialInput) SetKeyringName(v string) *ImportKeyMaterialInput {
	s.KeyringName = &v
	return s
}

// SetValidTo sets the ValidTo field's value.
func (s *ImportKeyMaterialInput) SetValidTo(v int64) *ImportKeyMaterialInput {
	s.ValidTo = &v
	return s
}

type ImportKeyMaterialOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s ImportKeyMaterialOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportKeyMaterialOutput) GoString() string {
	return s.String()
}
