// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeSecretVersionsCommon = "DescribeSecretVersions"

// DescribeSecretVersionsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeSecretVersionsCommon operation. The "output" return
// value will be populated with the DescribeSecretVersionsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeSecretVersionsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeSecretVersionsCommon Send returns without error.
//
// See DescribeSecretVersionsCommon for more information on using the DescribeSecretVersionsCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeSecretVersionsCommonRequest method.
//    req, resp := client.DescribeSecretVersionsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) DescribeSecretVersionsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeSecretVersionsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeSecretVersionsCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation DescribeSecretVersionsCommon for usage and error information.
func (c *KMS) DescribeSecretVersionsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeSecretVersionsCommonRequest(input)
	return out, req.Send()
}

// DescribeSecretVersionsCommonWithContext is the same as DescribeSecretVersionsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSecretVersionsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DescribeSecretVersionsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeSecretVersionsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSecretVersions = "DescribeSecretVersions"

// DescribeSecretVersionsRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeSecretVersions operation. The "output" return
// value will be populated with the DescribeSecretVersionsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeSecretVersionsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeSecretVersionsCommon Send returns without error.
//
// See DescribeSecretVersions for more information on using the DescribeSecretVersions
// API call, and error handling.
//
//    // Example sending a request using the DescribeSecretVersionsRequest method.
//    req, resp := client.DescribeSecretVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) DescribeSecretVersionsRequest(input *DescribeSecretVersionsInput) (req *request.Request, output *DescribeSecretVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeSecretVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSecretVersionsInput{}
	}

	output = &DescribeSecretVersionsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeSecretVersions API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation DescribeSecretVersions for usage and error information.
func (c *KMS) DescribeSecretVersions(input *DescribeSecretVersionsInput) (*DescribeSecretVersionsOutput, error) {
	req, out := c.DescribeSecretVersionsRequest(input)
	return out, req.Send()
}

// DescribeSecretVersionsWithContext is the same as DescribeSecretVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSecretVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DescribeSecretVersionsWithContext(ctx volcengine.Context, input *DescribeSecretVersionsInput, opts ...request.Option) (*DescribeSecretVersionsOutput, error) {
	req, out := c.DescribeSecretVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DescribeSecretVersionsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CurrentPage *int32 `min:"1" type:"int32" json:",omitempty"`

	PageSize *int32 `min:"1" max:"100" type:"int32" json:",omitempty"`

	// SecretName is a required field
	SecretName *string `min:"2" max:"31" type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s DescribeSecretVersionsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSecretVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSecretVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSecretVersionsInput"}
	if s.CurrentPage != nil && *s.CurrentPage < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentPage", 1))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}
	if s.SecretName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretName"))
	}
	if s.SecretName != nil && len(*s.SecretName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SecretName", 2))
	}
	if s.SecretName != nil && len(*s.SecretName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("SecretName", 31, *s.SecretName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCurrentPage sets the CurrentPage field's value.
func (s *DescribeSecretVersionsInput) SetCurrentPage(v int32) *DescribeSecretVersionsInput {
	s.CurrentPage = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeSecretVersionsInput) SetPageSize(v int32) *DescribeSecretVersionsInput {
	s.PageSize = &v
	return s
}

// SetSecretName sets the SecretName field's value.
func (s *DescribeSecretVersionsInput) SetSecretName(v string) *DescribeSecretVersionsInput {
	s.SecretName = &v
	return s
}

type DescribeSecretVersionsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	PageInfo *PageInfoForDescribeSecretVersionsOutput `type:"structure" json:",omitempty"`

	SecretVersions []*SecretVersionForDescribeSecretVersionsOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s DescribeSecretVersionsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSecretVersionsOutput) GoString() string {
	return s.String()
}

// SetPageInfo sets the PageInfo field's value.
func (s *DescribeSecretVersionsOutput) SetPageInfo(v *PageInfoForDescribeSecretVersionsOutput) *DescribeSecretVersionsOutput {
	s.PageInfo = v
	return s
}

// SetSecretVersions sets the SecretVersions field's value.
func (s *DescribeSecretVersionsOutput) SetSecretVersions(v []*SecretVersionForDescribeSecretVersionsOutput) *DescribeSecretVersionsOutput {
	s.SecretVersions = v
	return s
}

type PageInfoForDescribeSecretVersionsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Count *int32 `type:"int32" json:",omitempty"`

	CurrentPage *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s PageInfoForDescribeSecretVersionsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PageInfoForDescribeSecretVersionsOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *PageInfoForDescribeSecretVersionsOutput) SetCount(v int32) *PageInfoForDescribeSecretVersionsOutput {
	s.Count = &v
	return s
}

// SetCurrentPage sets the CurrentPage field's value.
func (s *PageInfoForDescribeSecretVersionsOutput) SetCurrentPage(v int32) *PageInfoForDescribeSecretVersionsOutput {
	s.CurrentPage = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *PageInfoForDescribeSecretVersionsOutput) SetPageSize(v int32) *PageInfoForDescribeSecretVersionsOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *PageInfoForDescribeSecretVersionsOutput) SetTotalCount(v int32) *PageInfoForDescribeSecretVersionsOutput {
	s.TotalCount = &v
	return s
}

type SecretVersionForDescribeSecretVersionsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreationDate *int64 `type:"int64" json:",omitempty"`

	VersionID *string `type:"string" json:",omitempty"`

	VersionStage *string `type:"string" json:",omitempty" enum:"EnumOfVersionStageForDescribeSecretVersionsOutput"`
}

// String returns the string representation
func (s SecretVersionForDescribeSecretVersionsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SecretVersionForDescribeSecretVersionsOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *SecretVersionForDescribeSecretVersionsOutput) SetCreationDate(v int64) *SecretVersionForDescribeSecretVersionsOutput {
	s.CreationDate = &v
	return s
}

// SetVersionID sets the VersionID field's value.
func (s *SecretVersionForDescribeSecretVersionsOutput) SetVersionID(v string) *SecretVersionForDescribeSecretVersionsOutput {
	s.VersionID = &v
	return s
}

// SetVersionStage sets the VersionStage field's value.
func (s *SecretVersionForDescribeSecretVersionsOutput) SetVersionStage(v string) *SecretVersionForDescribeSecretVersionsOutput {
	s.VersionStage = &v
	return s
}

const (
	// EnumOfVersionStageForDescribeSecretVersionsOutputCurrent is a EnumOfVersionStageForDescribeSecretVersionsOutput enum value
	EnumOfVersionStageForDescribeSecretVersionsOutputCurrent = "CURRENT"

	// EnumOfVersionStageForDescribeSecretVersionsOutputOlder is a EnumOfVersionStageForDescribeSecretVersionsOutput enum value
	EnumOfVersionStageForDescribeSecretVersionsOutputOlder = "OLDER"
)
