// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeSecretCommon = "DescribeSecret"

// DescribeSecretCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeSecretCommon operation. The "output" return
// value will be populated with the DescribeSecretCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeSecretCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeSecretCommon Send returns without error.
//
// See DescribeSecretCommon for more information on using the DescribeSecretCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeSecretCommonRequest method.
//    req, resp := client.DescribeSecretCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) DescribeSecretCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeSecretCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeSecretCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation DescribeSecretCommon for usage and error information.
func (c *KMS) DescribeSecretCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeSecretCommonRequest(input)
	return out, req.Send()
}

// DescribeSecretCommonWithContext is the same as DescribeSecretCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSecretCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DescribeSecretCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeSecretCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSecret = "DescribeSecret"

// DescribeSecretRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeSecret operation. The "output" return
// value will be populated with the DescribeSecretCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeSecretCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeSecretCommon Send returns without error.
//
// See DescribeSecret for more information on using the DescribeSecret
// API call, and error handling.
//
//    // Example sending a request using the DescribeSecretRequest method.
//    req, resp := client.DescribeSecretRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) DescribeSecretRequest(input *DescribeSecretInput) (req *request.Request, output *DescribeSecretOutput) {
	op := &request.Operation{
		Name:       opDescribeSecret,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSecretInput{}
	}

	output = &DescribeSecretOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeSecret API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation DescribeSecret for usage and error information.
func (c *KMS) DescribeSecret(input *DescribeSecretInput) (*DescribeSecretOutput, error) {
	req, out := c.DescribeSecretRequest(input)
	return out, req.Send()
}

// DescribeSecretWithContext is the same as DescribeSecret with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSecret for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DescribeSecretWithContext(ctx volcengine.Context, input *DescribeSecretInput, opts ...request.Option) (*DescribeSecretOutput, error) {
	req, out := c.DescribeSecretRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DescribeSecretInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// SecretName is a required field
	SecretName *string `min:"2" max:"31" type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s DescribeSecretInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSecretInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSecretInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSecretInput"}
	if s.SecretName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretName"))
	}
	if s.SecretName != nil && len(*s.SecretName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SecretName", 2))
	}
	if s.SecretName != nil && len(*s.SecretName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("SecretName", 31, *s.SecretName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretName sets the SecretName field's value.
func (s *DescribeSecretInput) SetSecretName(v string) *DescribeSecretInput {
	s.SecretName = &v
	return s
}

type DescribeSecretOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Secret *SecretForDescribeSecretOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s DescribeSecretOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSecretOutput) GoString() string {
	return s.String()
}

// SetSecret sets the Secret field's value.
func (s *DescribeSecretOutput) SetSecret(v *SecretForDescribeSecretOutput) *DescribeSecretOutput {
	s.Secret = v
	return s
}

type SecretForDescribeSecretOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreationDate *int64 `type:"int64" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	EncryptionKey *string `type:"string" json:",omitempty"`

	ExtendedConfig *string `max:"1024" type:"string" json:",omitempty"`

	ID *string `type:"string" json:",omitempty"`

	LastRotationTime *string `type:"string" json:",omitempty"`

	Managed *bool `type:"boolean" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	RotationInterval *int32 `type:"int32" json:",omitempty"`

	RotationState *string `type:"string" json:",omitempty"`

	ScheduleDeleteTime *string `type:"string" json:",omitempty"`

	ScheduleRotationTime *string `type:"string" json:",omitempty"`

	SecretName *string `type:"string" json:",omitempty"`

	SecretType *string `type:"string" json:",omitempty" enum:"EnumOfSecretTypeForDescribeSecretOutput"`

	Trn *string `type:"string" json:",omitempty"`

	UID *string `type:"string" json:",omitempty"`

	UpdateDate *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s SecretForDescribeSecretOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SecretForDescribeSecretOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *SecretForDescribeSecretOutput) SetCreationDate(v int64) *SecretForDescribeSecretOutput {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SecretForDescribeSecretOutput) SetDescription(v string) *SecretForDescribeSecretOutput {
	s.Description = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *SecretForDescribeSecretOutput) SetEncryptionKey(v string) *SecretForDescribeSecretOutput {
	s.EncryptionKey = &v
	return s
}

// SetExtendedConfig sets the ExtendedConfig field's value.
func (s *SecretForDescribeSecretOutput) SetExtendedConfig(v string) *SecretForDescribeSecretOutput {
	s.ExtendedConfig = &v
	return s
}

// SetID sets the ID field's value.
func (s *SecretForDescribeSecretOutput) SetID(v string) *SecretForDescribeSecretOutput {
	s.ID = &v
	return s
}

// SetLastRotationTime sets the LastRotationTime field's value.
func (s *SecretForDescribeSecretOutput) SetLastRotationTime(v string) *SecretForDescribeSecretOutput {
	s.LastRotationTime = &v
	return s
}

// SetManaged sets the Managed field's value.
func (s *SecretForDescribeSecretOutput) SetManaged(v bool) *SecretForDescribeSecretOutput {
	s.Managed = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *SecretForDescribeSecretOutput) SetProjectName(v string) *SecretForDescribeSecretOutput {
	s.ProjectName = &v
	return s
}

// SetRotationInterval sets the RotationInterval field's value.
func (s *SecretForDescribeSecretOutput) SetRotationInterval(v int32) *SecretForDescribeSecretOutput {
	s.RotationInterval = &v
	return s
}

// SetRotationState sets the RotationState field's value.
func (s *SecretForDescribeSecretOutput) SetRotationState(v string) *SecretForDescribeSecretOutput {
	s.RotationState = &v
	return s
}

// SetScheduleDeleteTime sets the ScheduleDeleteTime field's value.
func (s *SecretForDescribeSecretOutput) SetScheduleDeleteTime(v string) *SecretForDescribeSecretOutput {
	s.ScheduleDeleteTime = &v
	return s
}

// SetScheduleRotationTime sets the ScheduleRotationTime field's value.
func (s *SecretForDescribeSecretOutput) SetScheduleRotationTime(v string) *SecretForDescribeSecretOutput {
	s.ScheduleRotationTime = &v
	return s
}

// SetSecretName sets the SecretName field's value.
func (s *SecretForDescribeSecretOutput) SetSecretName(v string) *SecretForDescribeSecretOutput {
	s.SecretName = &v
	return s
}

// SetSecretType sets the SecretType field's value.
func (s *SecretForDescribeSecretOutput) SetSecretType(v string) *SecretForDescribeSecretOutput {
	s.SecretType = &v
	return s
}

// SetTrn sets the Trn field's value.
func (s *SecretForDescribeSecretOutput) SetTrn(v string) *SecretForDescribeSecretOutput {
	s.Trn = &v
	return s
}

// SetUID sets the UID field's value.
func (s *SecretForDescribeSecretOutput) SetUID(v string) *SecretForDescribeSecretOutput {
	s.UID = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *SecretForDescribeSecretOutput) SetUpdateDate(v int64) *SecretForDescribeSecretOutput {
	s.UpdateDate = &v
	return s
}

const (
	// EnumOfSecretTypeForDescribeSecretOutputGeneric is a EnumOfSecretTypeForDescribeSecretOutput enum value
	EnumOfSecretTypeForDescribeSecretOutputGeneric = "Generic"

	// EnumOfSecretTypeForDescribeSecretOutputIam is a EnumOfSecretTypeForDescribeSecretOutput enum value
	EnumOfSecretTypeForDescribeSecretOutputIam = "IAM"

	// EnumOfSecretTypeForDescribeSecretOutputRds is a EnumOfSecretTypeForDescribeSecretOutput enum value
	EnumOfSecretTypeForDescribeSecretOutputRds = "RDS"

	// EnumOfSecretTypeForDescribeSecretOutputRedis is a EnumOfSecretTypeForDescribeSecretOutput enum value
	EnumOfSecretTypeForDescribeSecretOutputRedis = "Redis"

	// EnumOfSecretTypeForDescribeSecretOutputEcs is a EnumOfSecretTypeForDescribeSecretOutput enum value
	EnumOfSecretTypeForDescribeSecretOutputEcs = "ECS"
)
