// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateKeyCommon = "CreateKey"

// CreateKeyCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateKeyCommon operation. The "output" return
// value will be populated with the CreateKeyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateKeyCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateKeyCommon Send returns without error.
//
// See CreateKeyCommon for more information on using the CreateKeyCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateKeyCommonRequest method.
//    req, resp := client.CreateKeyCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) CreateKeyCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateKeyCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateKeyCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation CreateKeyCommon for usage and error information.
func (c *KMS) CreateKeyCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateKeyCommonRequest(input)
	return out, req.Send()
}

// CreateKeyCommonWithContext is the same as CreateKeyCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKeyCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) CreateKeyCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateKeyCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKey = "CreateKey"

// CreateKeyRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateKey operation. The "output" return
// value will be populated with the CreateKeyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateKeyCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateKeyCommon Send returns without error.
//
// See CreateKey for more information on using the CreateKey
// API call, and error handling.
//
//    // Example sending a request using the CreateKeyRequest method.
//    req, resp := client.CreateKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) CreateKeyRequest(input *CreateKeyInput) (req *request.Request, output *CreateKeyOutput) {
	op := &request.Operation{
		Name:       opCreateKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateKeyInput{}
	}

	output = &CreateKeyOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateKey API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation CreateKey for usage and error information.
func (c *KMS) CreateKey(input *CreateKeyInput) (*CreateKeyOutput, error) {
	req, out := c.CreateKeyRequest(input)
	return out, req.Send()
}

// CreateKeyWithContext is the same as CreateKey with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) CreateKeyWithContext(ctx volcengine.Context, input *CreateKeyInput, opts ...request.Option) (*CreateKeyOutput, error) {
	req, out := c.CreateKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateKeyInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `max:"8192" type:"string" json:",omitempty"`

	// KeyName is a required field
	KeyName *string `min:"2" max:"31" type:"string" json:",omitempty" required:"true"`

	KeySpec *string `type:"string" json:",omitempty"`

	KeyUsage *string `type:"string" json:",omitempty"`

	// KeyringName is a required field
	KeyringName *string `min:"2" max:"31" type:"string" json:",omitempty" required:"true"`

	MultiRegion *bool `type:"boolean" json:",omitempty"`

	Origin *string `type:"string" json:",omitempty"`

	ProtectionLevel *string `type:"string" json:",omitempty"`

	RotateState *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateKeyInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKeyInput"}
	if s.Description != nil && len(*s.Description) > 8192 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 8192, *s.Description))
	}
	if s.KeyName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyName"))
	}
	if s.KeyName != nil && len(*s.KeyName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 2))
	}
	if s.KeyName != nil && len(*s.KeyName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyName", 31, *s.KeyName))
	}
	if s.KeyringName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyringName"))
	}
	if s.KeyringName != nil && len(*s.KeyringName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyringName", 2))
	}
	if s.KeyringName != nil && len(*s.KeyringName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyringName", 31, *s.KeyringName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateKeyInput) SetDescription(v string) *CreateKeyInput {
	s.Description = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *CreateKeyInput) SetKeyName(v string) *CreateKeyInput {
	s.KeyName = &v
	return s
}

// SetKeySpec sets the KeySpec field's value.
func (s *CreateKeyInput) SetKeySpec(v string) *CreateKeyInput {
	s.KeySpec = &v
	return s
}

// SetKeyUsage sets the KeyUsage field's value.
func (s *CreateKeyInput) SetKeyUsage(v string) *CreateKeyInput {
	s.KeyUsage = &v
	return s
}

// SetKeyringName sets the KeyringName field's value.
func (s *CreateKeyInput) SetKeyringName(v string) *CreateKeyInput {
	s.KeyringName = &v
	return s
}

// SetMultiRegion sets the MultiRegion field's value.
func (s *CreateKeyInput) SetMultiRegion(v bool) *CreateKeyInput {
	s.MultiRegion = &v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *CreateKeyInput) SetOrigin(v string) *CreateKeyInput {
	s.Origin = &v
	return s
}

// SetProtectionLevel sets the ProtectionLevel field's value.
func (s *CreateKeyInput) SetProtectionLevel(v string) *CreateKeyInput {
	s.ProtectionLevel = &v
	return s
}

// SetRotateState sets the RotateState field's value.
func (s *CreateKeyInput) SetRotateState(v string) *CreateKeyInput {
	s.RotateState = &v
	return s
}

type CreateKeyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Key *KeyForCreateKeyOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CreateKeyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *CreateKeyOutput) SetKey(v *KeyForCreateKeyOutput) *CreateKeyOutput {
	s.Key = v
	return s
}

type KeyForCreateKeyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreationDate *int64 `type:"int64" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	ID *string `type:"string" json:",omitempty"`

	KeyMaterialExpireTime *string `type:"string" json:",omitempty"`

	KeyName *string `type:"string" json:",omitempty"`

	KeySpec *string `type:"string" json:",omitempty"`

	KeyState *string `type:"string" json:",omitempty"`

	KeyUsage *string `type:"string" json:",omitempty"`

	LastRotationTime *string `type:"string" json:",omitempty"`

	MultiRegion *bool `type:"boolean" json:",omitempty"`

	MultiRegionConfiguration *MultiRegionConfigurationForCreateKeyOutput `type:"structure" json:",omitempty"`

	Origin *string `type:"string" json:",omitempty"`

	ProtectionLevel *string `type:"string" json:",omitempty"`

	RotationState *string `type:"string" json:",omitempty"`

	ScheduleDeleteTime *string `type:"string" json:",omitempty"`

	ScheduleRotationTime *string `type:"string" json:",omitempty"`

	Trn *string `type:"string" json:",omitempty"`

	UpdateDate *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s KeyForCreateKeyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyForCreateKeyOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *KeyForCreateKeyOutput) SetCreationDate(v int64) *KeyForCreateKeyOutput {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *KeyForCreateKeyOutput) SetDescription(v string) *KeyForCreateKeyOutput {
	s.Description = &v
	return s
}

// SetID sets the ID field's value.
func (s *KeyForCreateKeyOutput) SetID(v string) *KeyForCreateKeyOutput {
	s.ID = &v
	return s
}

// SetKeyMaterialExpireTime sets the KeyMaterialExpireTime field's value.
func (s *KeyForCreateKeyOutput) SetKeyMaterialExpireTime(v string) *KeyForCreateKeyOutput {
	s.KeyMaterialExpireTime = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *KeyForCreateKeyOutput) SetKeyName(v string) *KeyForCreateKeyOutput {
	s.KeyName = &v
	return s
}

// SetKeySpec sets the KeySpec field's value.
func (s *KeyForCreateKeyOutput) SetKeySpec(v string) *KeyForCreateKeyOutput {
	s.KeySpec = &v
	return s
}

// SetKeyState sets the KeyState field's value.
func (s *KeyForCreateKeyOutput) SetKeyState(v string) *KeyForCreateKeyOutput {
	s.KeyState = &v
	return s
}

// SetKeyUsage sets the KeyUsage field's value.
func (s *KeyForCreateKeyOutput) SetKeyUsage(v string) *KeyForCreateKeyOutput {
	s.KeyUsage = &v
	return s
}

// SetLastRotationTime sets the LastRotationTime field's value.
func (s *KeyForCreateKeyOutput) SetLastRotationTime(v string) *KeyForCreateKeyOutput {
	s.LastRotationTime = &v
	return s
}

// SetMultiRegion sets the MultiRegion field's value.
func (s *KeyForCreateKeyOutput) SetMultiRegion(v bool) *KeyForCreateKeyOutput {
	s.MultiRegion = &v
	return s
}

// SetMultiRegionConfiguration sets the MultiRegionConfiguration field's value.
func (s *KeyForCreateKeyOutput) SetMultiRegionConfiguration(v *MultiRegionConfigurationForCreateKeyOutput) *KeyForCreateKeyOutput {
	s.MultiRegionConfiguration = v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *KeyForCreateKeyOutput) SetOrigin(v string) *KeyForCreateKeyOutput {
	s.Origin = &v
	return s
}

// SetProtectionLevel sets the ProtectionLevel field's value.
func (s *KeyForCreateKeyOutput) SetProtectionLevel(v string) *KeyForCreateKeyOutput {
	s.ProtectionLevel = &v
	return s
}

// SetRotationState sets the RotationState field's value.
func (s *KeyForCreateKeyOutput) SetRotationState(v string) *KeyForCreateKeyOutput {
	s.RotationState = &v
	return s
}

// SetScheduleDeleteTime sets the ScheduleDeleteTime field's value.
func (s *KeyForCreateKeyOutput) SetScheduleDeleteTime(v string) *KeyForCreateKeyOutput {
	s.ScheduleDeleteTime = &v
	return s
}

// SetScheduleRotationTime sets the ScheduleRotationTime field's value.
func (s *KeyForCreateKeyOutput) SetScheduleRotationTime(v string) *KeyForCreateKeyOutput {
	s.ScheduleRotationTime = &v
	return s
}

// SetTrn sets the Trn field's value.
func (s *KeyForCreateKeyOutput) SetTrn(v string) *KeyForCreateKeyOutput {
	s.Trn = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *KeyForCreateKeyOutput) SetUpdateDate(v int64) *KeyForCreateKeyOutput {
	s.UpdateDate = &v
	return s
}

type MultiRegionConfigurationForCreateKeyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	MultiRegionKeyType *string `type:"string" json:",omitempty" enum:"EnumOfMultiRegionKeyTypeForCreateKeyOutput"`

	PrimaryKey *PrimaryKeyForCreateKeyOutput `type:"structure" json:",omitempty"`

	ReplicaKeys []*ReplicaKeyForCreateKeyOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s MultiRegionConfigurationForCreateKeyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiRegionConfigurationForCreateKeyOutput) GoString() string {
	return s.String()
}

// SetMultiRegionKeyType sets the MultiRegionKeyType field's value.
func (s *MultiRegionConfigurationForCreateKeyOutput) SetMultiRegionKeyType(v string) *MultiRegionConfigurationForCreateKeyOutput {
	s.MultiRegionKeyType = &v
	return s
}

// SetPrimaryKey sets the PrimaryKey field's value.
func (s *MultiRegionConfigurationForCreateKeyOutput) SetPrimaryKey(v *PrimaryKeyForCreateKeyOutput) *MultiRegionConfigurationForCreateKeyOutput {
	s.PrimaryKey = v
	return s
}

// SetReplicaKeys sets the ReplicaKeys field's value.
func (s *MultiRegionConfigurationForCreateKeyOutput) SetReplicaKeys(v []*ReplicaKeyForCreateKeyOutput) *MultiRegionConfigurationForCreateKeyOutput {
	s.ReplicaKeys = v
	return s
}

type PrimaryKeyForCreateKeyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Region *string `type:"string" json:",omitempty"`

	Trn *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s PrimaryKeyForCreateKeyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PrimaryKeyForCreateKeyOutput) GoString() string {
	return s.String()
}

// SetRegion sets the Region field's value.
func (s *PrimaryKeyForCreateKeyOutput) SetRegion(v string) *PrimaryKeyForCreateKeyOutput {
	s.Region = &v
	return s
}

// SetTrn sets the Trn field's value.
func (s *PrimaryKeyForCreateKeyOutput) SetTrn(v string) *PrimaryKeyForCreateKeyOutput {
	s.Trn = &v
	return s
}

type ReplicaKeyForCreateKeyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Region *string `type:"string" json:",omitempty"`

	Trn *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ReplicaKeyForCreateKeyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicaKeyForCreateKeyOutput) GoString() string {
	return s.String()
}

// SetRegion sets the Region field's value.
func (s *ReplicaKeyForCreateKeyOutput) SetRegion(v string) *ReplicaKeyForCreateKeyOutput {
	s.Region = &v
	return s
}

// SetTrn sets the Trn field's value.
func (s *ReplicaKeyForCreateKeyOutput) SetTrn(v string) *ReplicaKeyForCreateKeyOutput {
	s.Trn = &v
	return s
}

const (
	// EnumOfMultiRegionKeyTypeForCreateKeyOutputPrimary is a EnumOfMultiRegionKeyTypeForCreateKeyOutput enum value
	EnumOfMultiRegionKeyTypeForCreateKeyOutputPrimary = "PRIMARY"

	// EnumOfMultiRegionKeyTypeForCreateKeyOutputReplica is a EnumOfMultiRegionKeyTypeForCreateKeyOutput enum value
	EnumOfMultiRegionKeyTypeForCreateKeyOutputReplica = "REPLICA"
)
