// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opBackupSecretCommon = "BackupSecret"

// BackupSecretCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the BackupSecretCommon operation. The "output" return
// value will be populated with the BackupSecretCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned BackupSecretCommon Request to send the API call to the service.
// the "output" return value is not valid until after BackupSecretCommon Send returns without error.
//
// See BackupSecretCommon for more information on using the BackupSecretCommon
// API call, and error handling.
//
//    // Example sending a request using the BackupSecretCommonRequest method.
//    req, resp := client.BackupSecretCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) BackupSecretCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opBackupSecretCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// BackupSecretCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation BackupSecretCommon for usage and error information.
func (c *KMS) BackupSecretCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.BackupSecretCommonRequest(input)
	return out, req.Send()
}

// BackupSecretCommonWithContext is the same as BackupSecretCommon with the addition of
// the ability to pass a context and additional request options.
//
// See BackupSecretCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) BackupSecretCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.BackupSecretCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBackupSecret = "BackupSecret"

// BackupSecretRequest generates a "volcengine/request.Request" representing the
// client's request for the BackupSecret operation. The "output" return
// value will be populated with the BackupSecretCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned BackupSecretCommon Request to send the API call to the service.
// the "output" return value is not valid until after BackupSecretCommon Send returns without error.
//
// See BackupSecret for more information on using the BackupSecret
// API call, and error handling.
//
//    // Example sending a request using the BackupSecretRequest method.
//    req, resp := client.BackupSecretRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) BackupSecretRequest(input *BackupSecretInput) (req *request.Request, output *BackupSecretOutput) {
	op := &request.Operation{
		Name:       opBackupSecret,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BackupSecretInput{}
	}

	output = &BackupSecretOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// BackupSecret API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation BackupSecret for usage and error information.
func (c *KMS) BackupSecret(input *BackupSecretInput) (*BackupSecretOutput, error) {
	req, out := c.BackupSecretRequest(input)
	return out, req.Send()
}

// BackupSecretWithContext is the same as BackupSecret with the addition of
// the ability to pass a context and additional request options.
//
// See BackupSecret for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) BackupSecretWithContext(ctx volcengine.Context, input *BackupSecretInput, opts ...request.Option) (*BackupSecretOutput, error) {
	req, out := c.BackupSecretRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type BackupSecretInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// SecretName is a required field
	SecretName *string `min:"2" max:"31" type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s BackupSecretInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BackupSecretInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BackupSecretInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BackupSecretInput"}
	if s.SecretName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretName"))
	}
	if s.SecretName != nil && len(*s.SecretName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SecretName", 2))
	}
	if s.SecretName != nil && len(*s.SecretName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("SecretName", 31, *s.SecretName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretName sets the SecretName field's value.
func (s *BackupSecretInput) SetSecretName(v string) *BackupSecretInput {
	s.SecretName = &v
	return s
}

type BackupSecretOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	BackupData *string `type:"string" json:",omitempty"`

	SecretDataKey *string `type:"string" json:",omitempty"`

	Signature *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s BackupSecretOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BackupSecretOutput) GoString() string {
	return s.String()
}

// SetBackupData sets the BackupData field's value.
func (s *BackupSecretOutput) SetBackupData(v string) *BackupSecretOutput {
	s.BackupData = &v
	return s
}

// SetSecretDataKey sets the SecretDataKey field's value.
func (s *BackupSecretOutput) SetSecretDataKey(v string) *BackupSecretOutput {
	s.SecretDataKey = &v
	return s
}

// SetSignature sets the Signature field's value.
func (s *BackupSecretOutput) SetSignature(v string) *BackupSecretOutput {
	s.Signature = &v
	return s
}
