// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListOIDCProvidersCommon = "ListOIDCProviders"

// ListOIDCProvidersCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListOIDCProvidersCommon operation. The "output" return
// value will be populated with the ListOIDCProvidersCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListOIDCProvidersCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListOIDCProvidersCommon Send returns without error.
//
// See ListOIDCProvidersCommon for more information on using the ListOIDCProvidersCommon
// API call, and error handling.
//
//    // Example sending a request using the ListOIDCProvidersCommonRequest method.
//    req, resp := client.ListOIDCProvidersCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IAM) ListOIDCProvidersCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListOIDCProvidersCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// ListOIDCProvidersCommon API operation for IAM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for IAM's
// API operation ListOIDCProvidersCommon for usage and error information.
func (c *IAM) ListOIDCProvidersCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListOIDCProvidersCommonRequest(input)
	return out, req.Send()
}

// ListOIDCProvidersCommonWithContext is the same as ListOIDCProvidersCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListOIDCProvidersCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IAM) ListOIDCProvidersCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListOIDCProvidersCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListOIDCProviders = "ListOIDCProviders"

// ListOIDCProvidersRequest generates a "volcengine/request.Request" representing the
// client's request for the ListOIDCProviders operation. The "output" return
// value will be populated with the ListOIDCProvidersCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListOIDCProvidersCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListOIDCProvidersCommon Send returns without error.
//
// See ListOIDCProviders for more information on using the ListOIDCProviders
// API call, and error handling.
//
//    // Example sending a request using the ListOIDCProvidersRequest method.
//    req, resp := client.ListOIDCProvidersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IAM) ListOIDCProvidersRequest(input *ListOIDCProvidersInput) (req *request.Request, output *ListOIDCProvidersOutput) {
	op := &request.Operation{
		Name:       opListOIDCProviders,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListOIDCProvidersInput{}
	}

	output = &ListOIDCProvidersOutput{}
	req = c.newRequest(op, input, output)

	return
}

// ListOIDCProviders API operation for IAM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for IAM's
// API operation ListOIDCProviders for usage and error information.
func (c *IAM) ListOIDCProviders(input *ListOIDCProvidersInput) (*ListOIDCProvidersOutput, error) {
	req, out := c.ListOIDCProvidersRequest(input)
	return out, req.Send()
}

// ListOIDCProvidersWithContext is the same as ListOIDCProviders with the addition of
// the ability to pass a context and additional request options.
//
// See ListOIDCProviders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IAM) ListOIDCProvidersWithContext(ctx volcengine.Context, input *ListOIDCProvidersInput, opts ...request.Option) (*ListOIDCProvidersOutput, error) {
	req, out := c.ListOIDCProvidersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ListOIDCProvidersInput struct {
	_ struct{} `type:"structure"`

	Limit *int32 `max:"100" type:"int32"`

	Offset *int32 `type:"int32"`
}

// String returns the string representation
func (s ListOIDCProvidersInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOIDCProvidersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOIDCProvidersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOIDCProvidersInput"}
	if s.Limit != nil && *s.Limit > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("Limit", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListOIDCProvidersInput) SetLimit(v int32) *ListOIDCProvidersInput {
	s.Limit = &v
	return s
}

// SetOffset sets the Offset field's value.
func (s *ListOIDCProvidersInput) SetOffset(v int32) *ListOIDCProvidersInput {
	s.Offset = &v
	return s
}

type ListOIDCProvidersOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	Limit *int32 `type:"int32"`

	OIDCProviders []*OIDCProviderForListOIDCProvidersOutput `type:"list"`

	Offset *int32 `type:"int32"`

	Total *int32 `type:"int32"`
}

// String returns the string representation
func (s ListOIDCProvidersOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOIDCProvidersOutput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *ListOIDCProvidersOutput) SetLimit(v int32) *ListOIDCProvidersOutput {
	s.Limit = &v
	return s
}

// SetOIDCProviders sets the OIDCProviders field's value.
func (s *ListOIDCProvidersOutput) SetOIDCProviders(v []*OIDCProviderForListOIDCProvidersOutput) *ListOIDCProvidersOutput {
	s.OIDCProviders = v
	return s
}

// SetOffset sets the Offset field's value.
func (s *ListOIDCProvidersOutput) SetOffset(v int32) *ListOIDCProvidersOutput {
	s.Offset = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *ListOIDCProvidersOutput) SetTotal(v int32) *ListOIDCProvidersOutput {
	s.Total = &v
	return s
}

type OIDCProviderForListOIDCProvidersOutput struct {
	_ struct{} `type:"structure"`

	CreateDate *string `type:"string"`

	Description *string `type:"string"`

	ProviderName *string `type:"string"`

	Trn *string `type:"string"`

	UpdateDate *string `type:"string"`
}

// String returns the string representation
func (s OIDCProviderForListOIDCProvidersOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OIDCProviderForListOIDCProvidersOutput) GoString() string {
	return s.String()
}

// SetCreateDate sets the CreateDate field's value.
func (s *OIDCProviderForListOIDCProvidersOutput) SetCreateDate(v string) *OIDCProviderForListOIDCProvidersOutput {
	s.CreateDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *OIDCProviderForListOIDCProvidersOutput) SetDescription(v string) *OIDCProviderForListOIDCProvidersOutput {
	s.Description = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *OIDCProviderForListOIDCProvidersOutput) SetProviderName(v string) *OIDCProviderForListOIDCProvidersOutput {
	s.ProviderName = &v
	return s
}

// SetTrn sets the Trn field's value.
func (s *OIDCProviderForListOIDCProvidersOutput) SetTrn(v string) *OIDCProviderForListOIDCProvidersOutput {
	s.Trn = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *OIDCProviderForListOIDCProvidersOutput) SetUpdateDate(v string) *OIDCProviderForListOIDCProvidersOutput {
	s.UpdateDate = &v
	return s
}
