// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateKeyPairCommon = "CreateKeyPair"

// CreateKeyPairCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateKeyPairCommon operation. The "output" return
// value will be populated with the CreateKeyPairCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateKeyPairCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateKeyPairCommon Send returns without error.
//
// See CreateKeyPairCommon for more information on using the CreateKeyPairCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateKeyPairCommonRequest method.
//    req, resp := client.CreateKeyPairCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ECS) CreateKeyPairCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateKeyPairCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// CreateKeyPairCommon API operation for ECS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ECS's
// API operation CreateKeyPairCommon for usage and error information.
func (c *ECS) CreateKeyPairCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateKeyPairCommonRequest(input)
	return out, req.Send()
}

// CreateKeyPairCommonWithContext is the same as CreateKeyPairCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKeyPairCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) CreateKeyPairCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateKeyPairCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKeyPair = "CreateKeyPair"

// CreateKeyPairRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateKeyPair operation. The "output" return
// value will be populated with the CreateKeyPairCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateKeyPairCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateKeyPairCommon Send returns without error.
//
// See CreateKeyPair for more information on using the CreateKeyPair
// API call, and error handling.
//
//    // Example sending a request using the CreateKeyPairRequest method.
//    req, resp := client.CreateKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ECS) CreateKeyPairRequest(input *CreateKeyPairInput) (req *request.Request, output *CreateKeyPairOutput) {
	op := &request.Operation{
		Name:       opCreateKeyPair,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateKeyPairInput{}
	}

	output = &CreateKeyPairOutput{}
	req = c.newRequest(op, input, output)

	return
}

// CreateKeyPair API operation for ECS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ECS's
// API operation CreateKeyPair for usage and error information.
func (c *ECS) CreateKeyPair(input *CreateKeyPairInput) (*CreateKeyPairOutput, error) {
	req, out := c.CreateKeyPairRequest(input)
	return out, req.Send()
}

// CreateKeyPairWithContext is the same as CreateKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) CreateKeyPairWithContext(ctx volcengine.Context, input *CreateKeyPairInput, opts ...request.Option) (*CreateKeyPairOutput, error) {
	req, out := c.CreateKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateKeyPairInput struct {
	_ struct{} `type:"structure"`

	ClientToken *string `type:"string"`

	Description *string `type:"string"`

	// KeyPairName is a required field
	KeyPairName *string `type:"string" required:"true"`

	ProjectName *string `type:"string"`

	Tags []*TagForCreateKeyPairInput `type:"list"`
}

// String returns the string representation
func (s CreateKeyPairInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKeyPairInput"}
	if s.KeyPairName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyPairName"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateKeyPairInput) SetClientToken(v string) *CreateKeyPairInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateKeyPairInput) SetDescription(v string) *CreateKeyPairInput {
	s.Description = &v
	return s
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *CreateKeyPairInput) SetKeyPairName(v string) *CreateKeyPairInput {
	s.KeyPairName = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateKeyPairInput) SetProjectName(v string) *CreateKeyPairInput {
	s.ProjectName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateKeyPairInput) SetTags(v []*TagForCreateKeyPairInput) *CreateKeyPairInput {
	s.Tags = v
	return s
}

type CreateKeyPairOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	FingerPrint *string `type:"string"`

	KeyPairId *string `type:"string"`

	KeyPairName *string `type:"string"`

	PrivateKey *string `type:"string"`
}

// String returns the string representation
func (s CreateKeyPairOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyPairOutput) GoString() string {
	return s.String()
}

// SetFingerPrint sets the FingerPrint field's value.
func (s *CreateKeyPairOutput) SetFingerPrint(v string) *CreateKeyPairOutput {
	s.FingerPrint = &v
	return s
}

// SetKeyPairId sets the KeyPairId field's value.
func (s *CreateKeyPairOutput) SetKeyPairId(v string) *CreateKeyPairOutput {
	s.KeyPairId = &v
	return s
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *CreateKeyPairOutput) SetKeyPairName(v string) *CreateKeyPairOutput {
	s.KeyPairName = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *CreateKeyPairOutput) SetPrivateKey(v string) *CreateKeyPairOutput {
	s.PrivateKey = &v
	return s
}

type TagForCreateKeyPairInput struct {
	_ struct{} `type:"structure"`

	// Key is a required field
	Key *string `type:"string" required:"true"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForCreateKeyPairInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagForCreateKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagForCreateKeyPairInput"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *TagForCreateKeyPairInput) SetKey(v string) *TagForCreateKeyPairInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateKeyPairInput) SetValue(v string) *TagForCreateKeyPairInput {
	s.Value = &v
	return s
}
