// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package dns

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListLinesCommon = "ListLines"

// ListLinesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListLinesCommon operation. The "output" return
// value will be populated with the ListLinesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListLinesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListLinesCommon Send returns without error.
//
// See ListLinesCommon for more information on using the ListLinesCommon
// API call, and error handling.
//
//    // Example sending a request using the ListLinesCommonRequest method.
//    req, resp := client.ListLinesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DNS) ListLinesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListLinesCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListLinesCommon API operation for DNS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DNS's
// API operation ListLinesCommon for usage and error information.
func (c *DNS) ListLinesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListLinesCommonRequest(input)
	return out, req.Send()
}

// ListLinesCommonWithContext is the same as ListLinesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListLinesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DNS) ListLinesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListLinesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLines = "ListLines"

// ListLinesRequest generates a "volcengine/request.Request" representing the
// client's request for the ListLines operation. The "output" return
// value will be populated with the ListLinesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListLinesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListLinesCommon Send returns without error.
//
// See ListLines for more information on using the ListLines
// API call, and error handling.
//
//    // Example sending a request using the ListLinesRequest method.
//    req, resp := client.ListLinesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DNS) ListLinesRequest(input *ListLinesInput) (req *request.Request, output *ListLinesOutput) {
	op := &request.Operation{
		Name:       opListLines,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListLinesInput{}
	}

	output = &ListLinesOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListLines API operation for DNS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DNS's
// API operation ListLines for usage and error information.
func (c *DNS) ListLines(input *ListLinesInput) (*ListLinesOutput, error) {
	req, out := c.ListLinesRequest(input)
	return out, req.Send()
}

// ListLinesWithContext is the same as ListLines with the addition of
// the ability to pass a context and additional request options.
//
// See ListLines for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DNS) ListLinesWithContext(ctx volcengine.Context, input *ListLinesInput, opts ...request.Option) (*ListLinesOutput, error) {
	req, out := c.ListLinesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type LineForListLinesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FatherValue *string `type:"string" json:",omitempty"`

	ID *string `type:"string" json:",omitempty"`

	Level *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	PartName *string `type:"string" json:",omitempty"`

	Type *int32 `type:"int32" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s LineForListLinesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LineForListLinesOutput) GoString() string {
	return s.String()
}

// SetFatherValue sets the FatherValue field's value.
func (s *LineForListLinesOutput) SetFatherValue(v string) *LineForListLinesOutput {
	s.FatherValue = &v
	return s
}

// SetID sets the ID field's value.
func (s *LineForListLinesOutput) SetID(v string) *LineForListLinesOutput {
	s.ID = &v
	return s
}

// SetLevel sets the Level field's value.
func (s *LineForListLinesOutput) SetLevel(v int32) *LineForListLinesOutput {
	s.Level = &v
	return s
}

// SetName sets the Name field's value.
func (s *LineForListLinesOutput) SetName(v string) *LineForListLinesOutput {
	s.Name = &v
	return s
}

// SetPartName sets the PartName field's value.
func (s *LineForListLinesOutput) SetPartName(v string) *LineForListLinesOutput {
	s.PartName = &v
	return s
}

// SetType sets the Type field's value.
func (s *LineForListLinesOutput) SetType(v int32) *LineForListLinesOutput {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *LineForListLinesOutput) SetValue(v string) *LineForListLinesOutput {
	s.Value = &v
	return s
}

type ListLinesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Hierarchy *string `type:"string" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	ZID *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ListLinesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLinesInput) GoString() string {
	return s.String()
}

// SetHierarchy sets the Hierarchy field's value.
func (s *ListLinesInput) SetHierarchy(v string) *ListLinesInput {
	s.Hierarchy = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListLinesInput) SetPageNumber(v int32) *ListLinesInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListLinesInput) SetPageSize(v int32) *ListLinesInput {
	s.PageSize = &v
	return s
}

// SetZID sets the ZID field's value.
func (s *ListLinesInput) SetZID(v int64) *ListLinesInput {
	s.ZID = &v
	return s
}

type ListLinesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Lines []*LineForListLinesOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListLinesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLinesOutput) GoString() string {
	return s.String()
}

// SetLines sets the Lines field's value.
func (s *ListLinesOutput) SetLines(v []*LineForListLinesOutput) *ListLinesOutput {
	s.Lines = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListLinesOutput) SetPageNumber(v int32) *ListLinesOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListLinesOutput) SetPageSize(v int32) *ListLinesOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListLinesOutput) SetTotalCount(v int32) *ListLinesOutput {
	s.TotalCount = &v
	return s
}
