// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cr

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateRepositoryCommon = "CreateRepository"

// CreateRepositoryCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateRepositoryCommon operation. The "output" return
// value will be populated with the CreateRepositoryCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateRepositoryCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateRepositoryCommon Send returns without error.
//
// See CreateRepositoryCommon for more information on using the CreateRepositoryCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateRepositoryCommonRequest method.
//    req, resp := client.CreateRepositoryCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CR) CreateRepositoryCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateRepositoryCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateRepositoryCommon API operation for CR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CR's
// API operation CreateRepositoryCommon for usage and error information.
func (c *CR) CreateRepositoryCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateRepositoryCommonRequest(input)
	return out, req.Send()
}

// CreateRepositoryCommonWithContext is the same as CreateRepositoryCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRepositoryCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CR) CreateRepositoryCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateRepositoryCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRepository = "CreateRepository"

// CreateRepositoryRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateRepository operation. The "output" return
// value will be populated with the CreateRepositoryCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateRepositoryCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateRepositoryCommon Send returns without error.
//
// See CreateRepository for more information on using the CreateRepository
// API call, and error handling.
//
//    // Example sending a request using the CreateRepositoryRequest method.
//    req, resp := client.CreateRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CR) CreateRepositoryRequest(input *CreateRepositoryInput) (req *request.Request, output *CreateRepositoryOutput) {
	op := &request.Operation{
		Name:       opCreateRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRepositoryInput{}
	}

	output = &CreateRepositoryOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateRepository API operation for CR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CR's
// API operation CreateRepository for usage and error information.
func (c *CR) CreateRepository(input *CreateRepositoryInput) (*CreateRepositoryOutput, error) {
	req, out := c.CreateRepositoryRequest(input)
	return out, req.Send()
}

// CreateRepositoryWithContext is the same as CreateRepository with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CR) CreateRepositoryWithContext(ctx volcengine.Context, input *CreateRepositoryInput, opts ...request.Option) (*CreateRepositoryOutput, error) {
	req, out := c.CreateRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateRepositoryInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessLevel *string `type:"string" json:",omitempty"`

	ClientToken *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	// Name is a required field
	Name *string `type:"string" json:",omitempty" required:"true"`

	// Namespace is a required field
	Namespace *string `min:"2" max:"90" type:"string" json:",omitempty" required:"true"`

	// Registry is a required field
	Registry *string `min:"3" max:"30" type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s CreateRepositoryInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRepositoryInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 2))
	}
	if s.Namespace != nil && len(*s.Namespace) > 90 {
		invalidParams.Add(request.NewErrParamMaxLen("Namespace", 90, *s.Namespace))
	}
	if s.Registry == nil {
		invalidParams.Add(request.NewErrParamRequired("Registry"))
	}
	if s.Registry != nil && len(*s.Registry) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Registry", 3))
	}
	if s.Registry != nil && len(*s.Registry) > 30 {
		invalidParams.Add(request.NewErrParamMaxLen("Registry", 30, *s.Registry))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessLevel sets the AccessLevel field's value.
func (s *CreateRepositoryInput) SetAccessLevel(v string) *CreateRepositoryInput {
	s.AccessLevel = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateRepositoryInput) SetClientToken(v string) *CreateRepositoryInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateRepositoryInput) SetDescription(v string) *CreateRepositoryInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRepositoryInput) SetName(v string) *CreateRepositoryInput {
	s.Name = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CreateRepositoryInput) SetNamespace(v string) *CreateRepositoryInput {
	s.Namespace = &v
	return s
}

// SetRegistry sets the Registry field's value.
func (s *CreateRepositoryInput) SetRegistry(v string) *CreateRepositoryInput {
	s.Registry = &v
	return s
}

type CreateRepositoryOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s CreateRepositoryOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRepositoryOutput) GoString() string {
	return s.String()
}
