// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cdn

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeDistrictDataCommon = "DescribeDistrictData"

// DescribeDistrictDataCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeDistrictDataCommon operation. The "output" return
// value will be populated with the DescribeDistrictDataCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeDistrictDataCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeDistrictDataCommon Send returns without error.
//
// See DescribeDistrictDataCommon for more information on using the DescribeDistrictDataCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeDistrictDataCommonRequest method.
//    req, resp := client.DescribeDistrictDataCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) DescribeDistrictDataCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeDistrictDataCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeDistrictDataCommon API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation DescribeDistrictDataCommon for usage and error information.
func (c *CDN) DescribeDistrictDataCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeDistrictDataCommonRequest(input)
	return out, req.Send()
}

// DescribeDistrictDataCommonWithContext is the same as DescribeDistrictDataCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDistrictDataCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) DescribeDistrictDataCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeDistrictDataCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDistrictData = "DescribeDistrictData"

// DescribeDistrictDataRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeDistrictData operation. The "output" return
// value will be populated with the DescribeDistrictDataCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeDistrictDataCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeDistrictDataCommon Send returns without error.
//
// See DescribeDistrictData for more information on using the DescribeDistrictData
// API call, and error handling.
//
//    // Example sending a request using the DescribeDistrictDataRequest method.
//    req, resp := client.DescribeDistrictDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) DescribeDistrictDataRequest(input *DescribeDistrictDataInput) (req *request.Request, output *DescribeDistrictDataOutput) {
	op := &request.Operation{
		Name:       opDescribeDistrictData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDistrictDataInput{}
	}

	output = &DescribeDistrictDataOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeDistrictData API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation DescribeDistrictData for usage and error information.
func (c *CDN) DescribeDistrictData(input *DescribeDistrictDataInput) (*DescribeDistrictDataOutput, error) {
	req, out := c.DescribeDistrictDataRequest(input)
	return out, req.Send()
}

// DescribeDistrictDataWithContext is the same as DescribeDistrictData with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDistrictData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) DescribeDistrictDataWithContext(ctx volcengine.Context, input *DescribeDistrictDataInput, opts ...request.Option) (*DescribeDistrictDataOutput, error) {
	req, out := c.DescribeDistrictDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DescribeDistrictDataInput struct {
	_ struct{} `type:"structure"`

	Domain *string `type:"string"`

	// EndTime is a required field
	EndTime *int64 `type:"int64" required:"true"`

	Interval *string `type:"string"`

	IpVersion *string `type:"string"`

	Isp *string `type:"string"`

	Location *string `type:"string"`

	// Metric is a required field
	Metric *string `type:"string" required:"true"`

	Project *string `type:"string"`

	Protocol *string `type:"string"`

	Province *string `type:"string"`

	// StartTime is a required field
	StartTime *int64 `type:"int64" required:"true"`
}

// String returns the string representation
func (s DescribeDistrictDataInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDistrictDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDistrictDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDistrictDataInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.Metric == nil {
		invalidParams.Add(request.NewErrParamRequired("Metric"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DescribeDistrictDataInput) SetDomain(v string) *DescribeDistrictDataInput {
	s.Domain = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeDistrictDataInput) SetEndTime(v int64) *DescribeDistrictDataInput {
	s.EndTime = &v
	return s
}

// SetInterval sets the Interval field's value.
func (s *DescribeDistrictDataInput) SetInterval(v string) *DescribeDistrictDataInput {
	s.Interval = &v
	return s
}

// SetIpVersion sets the IpVersion field's value.
func (s *DescribeDistrictDataInput) SetIpVersion(v string) *DescribeDistrictDataInput {
	s.IpVersion = &v
	return s
}

// SetIsp sets the Isp field's value.
func (s *DescribeDistrictDataInput) SetIsp(v string) *DescribeDistrictDataInput {
	s.Isp = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *DescribeDistrictDataInput) SetLocation(v string) *DescribeDistrictDataInput {
	s.Location = &v
	return s
}

// SetMetric sets the Metric field's value.
func (s *DescribeDistrictDataInput) SetMetric(v string) *DescribeDistrictDataInput {
	s.Metric = &v
	return s
}

// SetProject sets the Project field's value.
func (s *DescribeDistrictDataInput) SetProject(v string) *DescribeDistrictDataInput {
	s.Project = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *DescribeDistrictDataInput) SetProtocol(v string) *DescribeDistrictDataInput {
	s.Protocol = &v
	return s
}

// SetProvince sets the Province field's value.
func (s *DescribeDistrictDataInput) SetProvince(v string) *DescribeDistrictDataInput {
	s.Province = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeDistrictDataInput) SetStartTime(v int64) *DescribeDistrictDataInput {
	s.StartTime = &v
	return s
}

type DescribeDistrictDataOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	MetricDataList []*MetricDataListForDescribeDistrictDataOutput `type:"list"`
}

// String returns the string representation
func (s DescribeDistrictDataOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDistrictDataOutput) GoString() string {
	return s.String()
}

// SetMetricDataList sets the MetricDataList field's value.
func (s *DescribeDistrictDataOutput) SetMetricDataList(v []*MetricDataListForDescribeDistrictDataOutput) *DescribeDistrictDataOutput {
	s.MetricDataList = v
	return s
}

type MetricDataListForDescribeDistrictDataOutput struct {
	_ struct{} `type:"structure"`

	Metric *string `type:"string"`

	Values []*ValueForDescribeDistrictDataOutput `type:"list"`
}

// String returns the string representation
func (s MetricDataListForDescribeDistrictDataOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricDataListForDescribeDistrictDataOutput) GoString() string {
	return s.String()
}

// SetMetric sets the Metric field's value.
func (s *MetricDataListForDescribeDistrictDataOutput) SetMetric(v string) *MetricDataListForDescribeDistrictDataOutput {
	s.Metric = &v
	return s
}

// SetValues sets the Values field's value.
func (s *MetricDataListForDescribeDistrictDataOutput) SetValues(v []*ValueForDescribeDistrictDataOutput) *MetricDataListForDescribeDistrictDataOutput {
	s.Values = v
	return s
}

type ValueForDescribeDistrictDataOutput struct {
	_ struct{} `type:"structure"`

	Item *string `type:"string"`

	TimeStamp *int64 `type:"int64"`

	Value *float64 `type:"double"`
}

// String returns the string representation
func (s ValueForDescribeDistrictDataOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ValueForDescribeDistrictDataOutput) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *ValueForDescribeDistrictDataOutput) SetItem(v string) *ValueForDescribeDistrictDataOutput {
	s.Item = &v
	return s
}

// SetTimeStamp sets the TimeStamp field's value.
func (s *ValueForDescribeDistrictDataOutput) SetTimeStamp(v int64) *ValueForDescribeDistrictDataOutput {
	s.TimeStamp = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ValueForDescribeDistrictDataOutput) SetValue(v float64) *ValueForDescribeDistrictDataOutput {
	s.Value = &v
	return s
}
