// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package bio

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opUpdateWorkflowCommon = "UpdateWorkflow"

// UpdateWorkflowCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateWorkflowCommon operation. The "output" return
// value will be populated with the UpdateWorkflowCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateWorkflowCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateWorkflowCommon Send returns without error.
//
// See UpdateWorkflowCommon for more information on using the UpdateWorkflowCommon
// API call, and error handling.
//
//    // Example sending a request using the UpdateWorkflowCommonRequest method.
//    req, resp := client.UpdateWorkflowCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) UpdateWorkflowCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opUpdateWorkflowCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateWorkflowCommon API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation UpdateWorkflowCommon for usage and error information.
func (c *BIO) UpdateWorkflowCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.UpdateWorkflowCommonRequest(input)
	return out, req.Send()
}

// UpdateWorkflowCommonWithContext is the same as UpdateWorkflowCommon with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkflowCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) UpdateWorkflowCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.UpdateWorkflowCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkflow = "UpdateWorkflow"

// UpdateWorkflowRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateWorkflow operation. The "output" return
// value will be populated with the UpdateWorkflowCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateWorkflowCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateWorkflowCommon Send returns without error.
//
// See UpdateWorkflow for more information on using the UpdateWorkflow
// API call, and error handling.
//
//    // Example sending a request using the UpdateWorkflowRequest method.
//    req, resp := client.UpdateWorkflowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) UpdateWorkflowRequest(input *UpdateWorkflowInput) (req *request.Request, output *UpdateWorkflowOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkflow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateWorkflowInput{}
	}

	output = &UpdateWorkflowOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateWorkflow API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation UpdateWorkflow for usage and error information.
func (c *BIO) UpdateWorkflow(input *UpdateWorkflowInput) (*UpdateWorkflowOutput, error) {
	req, out := c.UpdateWorkflowRequest(input)
	return out, req.Send()
}

// UpdateWorkflowWithContext is the same as UpdateWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) UpdateWorkflowWithContext(ctx volcengine.Context, input *UpdateWorkflowInput, opts ...request.Option) (*UpdateWorkflowOutput, error) {
	req, out := c.UpdateWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type UpdateWorkflowInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Content *string `type:"string" json:",omitempty"`

	Description *string `max:"1000" type:"string" json:",omitempty"`

	// ID is a required field
	ID *string `type:"string" json:",omitempty" required:"true"`

	MainWorkflowPath *string `type:"string" json:",omitempty"`

	// Name is a required field
	Name *string `min:"1" max:"200" type:"string" json:",omitempty" required:"true"`

	Source *string `type:"string" json:",omitempty"`

	SourceType *string `type:"string" json:",omitempty"`

	Tag *string `type:"string" json:",omitempty"`

	Token *string `type:"string" json:",omitempty"`

	// WorkspaceID is a required field
	WorkspaceID *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s UpdateWorkflowInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkflowInput"}
	if s.Description != nil && len(*s.Description) > 1000 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 1000, *s.Description))
	}
	if s.ID == nil {
		invalidParams.Add(request.NewErrParamRequired("ID"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Name != nil && len(*s.Name) > 200 {
		invalidParams.Add(request.NewErrParamMaxLen("Name", 200, *s.Name))
	}
	if s.WorkspaceID == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *UpdateWorkflowInput) SetContent(v string) *UpdateWorkflowInput {
	s.Content = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateWorkflowInput) SetDescription(v string) *UpdateWorkflowInput {
	s.Description = &v
	return s
}

// SetID sets the ID field's value.
func (s *UpdateWorkflowInput) SetID(v string) *UpdateWorkflowInput {
	s.ID = &v
	return s
}

// SetMainWorkflowPath sets the MainWorkflowPath field's value.
func (s *UpdateWorkflowInput) SetMainWorkflowPath(v string) *UpdateWorkflowInput {
	s.MainWorkflowPath = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateWorkflowInput) SetName(v string) *UpdateWorkflowInput {
	s.Name = &v
	return s
}

// SetSource sets the Source field's value.
func (s *UpdateWorkflowInput) SetSource(v string) *UpdateWorkflowInput {
	s.Source = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *UpdateWorkflowInput) SetSourceType(v string) *UpdateWorkflowInput {
	s.SourceType = &v
	return s
}

// SetTag sets the Tag field's value.
func (s *UpdateWorkflowInput) SetTag(v string) *UpdateWorkflowInput {
	s.Tag = &v
	return s
}

// SetToken sets the Token field's value.
func (s *UpdateWorkflowInput) SetToken(v string) *UpdateWorkflowInput {
	s.Token = &v
	return s
}

// SetWorkspaceID sets the WorkspaceID field's value.
func (s *UpdateWorkflowInput) SetWorkspaceID(v string) *UpdateWorkflowInput {
	s.WorkspaceID = &v
	return s
}

type UpdateWorkflowOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s UpdateWorkflowOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateWorkflowOutput) GoString() string {
	return s.String()
}
