// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opRemoveInstancesCommon = "RemoveInstances"

// RemoveInstancesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the RemoveInstancesCommon operation. The "output" return
// value will be populated with the RemoveInstancesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RemoveInstancesCommon Request to send the API call to the service.
// the "output" return value is not valid until after RemoveInstancesCommon Send returns without error.
//
// See RemoveInstancesCommon for more information on using the RemoveInstancesCommon
// API call, and error handling.
//
//    // Example sending a request using the RemoveInstancesCommonRequest method.
//    req, resp := client.RemoveInstancesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *AUTOSCALING) RemoveInstancesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opRemoveInstancesCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// RemoveInstancesCommon API operation for AUTO_SCALING.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for AUTO_SCALING's
// API operation RemoveInstancesCommon for usage and error information.
func (c *AUTOSCALING) RemoveInstancesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.RemoveInstancesCommonRequest(input)
	return out, req.Send()
}

// RemoveInstancesCommonWithContext is the same as RemoveInstancesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveInstancesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AUTOSCALING) RemoveInstancesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.RemoveInstancesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveInstances = "RemoveInstances"

// RemoveInstancesRequest generates a "volcengine/request.Request" representing the
// client's request for the RemoveInstances operation. The "output" return
// value will be populated with the RemoveInstancesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RemoveInstancesCommon Request to send the API call to the service.
// the "output" return value is not valid until after RemoveInstancesCommon Send returns without error.
//
// See RemoveInstances for more information on using the RemoveInstances
// API call, and error handling.
//
//    // Example sending a request using the RemoveInstancesRequest method.
//    req, resp := client.RemoveInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *AUTOSCALING) RemoveInstancesRequest(input *RemoveInstancesInput) (req *request.Request, output *RemoveInstancesOutput) {
	op := &request.Operation{
		Name:       opRemoveInstances,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveInstancesInput{}
	}

	output = &RemoveInstancesOutput{}
	req = c.newRequest(op, input, output)

	return
}

// RemoveInstances API operation for AUTO_SCALING.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for AUTO_SCALING's
// API operation RemoveInstances for usage and error information.
func (c *AUTOSCALING) RemoveInstances(input *RemoveInstancesInput) (*RemoveInstancesOutput, error) {
	req, out := c.RemoveInstancesRequest(input)
	return out, req.Send()
}

// RemoveInstancesWithContext is the same as RemoveInstances with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AUTOSCALING) RemoveInstancesWithContext(ctx volcengine.Context, input *RemoveInstancesInput, opts ...request.Option) (*RemoveInstancesOutput, error) {
	req, out := c.RemoveInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type RemoveInstancesInput struct {
	_ struct{} `type:"structure"`

	DecreaseDesiredCapacity *bool `type:"boolean"`

	ForceDelete *bool `type:"boolean"`

	// InstanceIds is a required field
	InstanceIds []*string `type:"list" required:"true"`

	LifecycleHook *bool `type:"boolean"`

	RemoveMode *string `type:"string"`

	// ScalingGroupId is a required field
	ScalingGroupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveInstancesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveInstancesInput"}
	if s.InstanceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceIds"))
	}
	if s.ScalingGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDecreaseDesiredCapacity sets the DecreaseDesiredCapacity field's value.
func (s *RemoveInstancesInput) SetDecreaseDesiredCapacity(v bool) *RemoveInstancesInput {
	s.DecreaseDesiredCapacity = &v
	return s
}

// SetForceDelete sets the ForceDelete field's value.
func (s *RemoveInstancesInput) SetForceDelete(v bool) *RemoveInstancesInput {
	s.ForceDelete = &v
	return s
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *RemoveInstancesInput) SetInstanceIds(v []*string) *RemoveInstancesInput {
	s.InstanceIds = v
	return s
}

// SetLifecycleHook sets the LifecycleHook field's value.
func (s *RemoveInstancesInput) SetLifecycleHook(v bool) *RemoveInstancesInput {
	s.LifecycleHook = &v
	return s
}

// SetRemoveMode sets the RemoveMode field's value.
func (s *RemoveInstancesInput) SetRemoveMode(v string) *RemoveInstancesInput {
	s.RemoveMode = &v
	return s
}

// SetScalingGroupId sets the ScalingGroupId field's value.
func (s *RemoveInstancesInput) SetScalingGroupId(v string) *RemoveInstancesInput {
	s.ScalingGroupId = &v
	return s
}

type RemoveInstancesOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	ScalingActivityId *string `type:"string"`
}

// String returns the string representation
func (s RemoveInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveInstancesOutput) GoString() string {
	return s.String()
}

// SetScalingActivityId sets the ScalingActivityId field's value.
func (s *RemoveInstancesOutput) SetScalingActivityId(v string) *RemoveInstancesOutput {
	s.ScalingActivityId = &v
	return s
}
