// Example Code generated by Beijing Volcanoengine Technology.
package vpcexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/vpc"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func ModifySubnetAttributes() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := vpc.New(sess)
	modifySubnetAttributesInput := &vpc.ModifySubnetAttributesInput{
		Description: volcengine.String("This is my subnet"),
		SubnetId:    volcengine.String("subnet-bp15qtc7ywecf****"),
		SubnetName:  volcengine.String("subnet-1"),
	}

	resp, err := svc.ModifySubnetAttributes(modifySubnetAttributesInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
