// Example Code generated by Beijing Volcanoengine Technology.
package vpcexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/vpc"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func DisassociateVpcCidrBlock() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := vpc.New(sess)
	disassociateVpcCidrBlockInput := &vpc.DisassociateVpcCidrBlockInput{
		SecondaryCidrBlock: volcengine.String("172.16.XX.0/24"),
		VpcId:              volcengine.String("vpc-257gqcdfvx6n****"),
	}

	resp, err := svc.DisassociateVpcCidrBlock(disassociateVpcCidrBlockInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
