// Example Code generated by Beijing Volcanoengine Technology.
package directconnectexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/directconnect"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func ModifyBgpPeerAttributes() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := directconnect.New(sess)
	modifyBgpPeerAttributesInput := &directconnect.ModifyBgpPeerAttributesInput{
		BgpPeerId:   volcengine.String("bgp-2752hz4teko3k7f4c****"),
		BgpPeerName: volcengine.String("test"),
		Description: volcengine.String("test"),
	}

	resp, err := svc.ModifyBgpPeerAttributes(modifyBgpPeerAttributesInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
