// +build go1.9

// Copyright 2019 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package datafactory

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/datafactory/mgmt/2018-06-01/datafactory"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AuthenticationType = original.AuthenticationType

const (
	AuthenticationTypeAnonymous                      AuthenticationType = original.AuthenticationTypeAnonymous
	AuthenticationTypeBasic                          AuthenticationType = original.AuthenticationTypeBasic
	AuthenticationTypeClientCertificate              AuthenticationType = original.AuthenticationTypeClientCertificate
	AuthenticationTypeWebLinkedServiceTypeProperties AuthenticationType = original.AuthenticationTypeWebLinkedServiceTypeProperties
)

type AuthorizationType = original.AuthorizationType

const (
	AuthorizationTypeKey                          AuthorizationType = original.AuthorizationTypeKey
	AuthorizationTypeLinkedIntegrationRuntimeType AuthorizationType = original.AuthorizationTypeLinkedIntegrationRuntimeType
	AuthorizationTypeRBAC                         AuthorizationType = original.AuthorizationTypeRBAC
)

type AvroCompressionCodec = original.AvroCompressionCodec

const (
	Bzip2   AvroCompressionCodec = original.Bzip2
	Deflate AvroCompressionCodec = original.Deflate
	None    AvroCompressionCodec = original.None
	Snappy  AvroCompressionCodec = original.Snappy
	Xz      AvroCompressionCodec = original.Xz
)

type AzureFunctionActivityMethod = original.AzureFunctionActivityMethod

const (
	DELETE  AzureFunctionActivityMethod = original.DELETE
	GET     AzureFunctionActivityMethod = original.GET
	HEAD    AzureFunctionActivityMethod = original.HEAD
	OPTIONS AzureFunctionActivityMethod = original.OPTIONS
	POST    AzureFunctionActivityMethod = original.POST
	PUT     AzureFunctionActivityMethod = original.PUT
	TRACE   AzureFunctionActivityMethod = original.TRACE
)

type AzureSearchIndexWriteBehaviorType = original.AzureSearchIndexWriteBehaviorType

const (
	Merge  AzureSearchIndexWriteBehaviorType = original.Merge
	Upload AzureSearchIndexWriteBehaviorType = original.Upload
)

type BlobEventTypes = original.BlobEventTypes

const (
	MicrosoftStorageBlobCreated BlobEventTypes = original.MicrosoftStorageBlobCreated
	MicrosoftStorageBlobDeleted BlobEventTypes = original.MicrosoftStorageBlobDeleted
)

type CassandraSourceReadConsistencyLevels = original.CassandraSourceReadConsistencyLevels

const (
	ALL         CassandraSourceReadConsistencyLevels = original.ALL
	EACHQUORUM  CassandraSourceReadConsistencyLevels = original.EACHQUORUM
	LOCALONE    CassandraSourceReadConsistencyLevels = original.LOCALONE
	LOCALQUORUM CassandraSourceReadConsistencyLevels = original.LOCALQUORUM
	LOCALSERIAL CassandraSourceReadConsistencyLevels = original.LOCALSERIAL
	ONE         CassandraSourceReadConsistencyLevels = original.ONE
	QUORUM      CassandraSourceReadConsistencyLevels = original.QUORUM
	SERIAL      CassandraSourceReadConsistencyLevels = original.SERIAL
	THREE       CassandraSourceReadConsistencyLevels = original.THREE
	TWO         CassandraSourceReadConsistencyLevels = original.TWO
)

type DataFlowComputeType = original.DataFlowComputeType

const (
	ComputeOptimized DataFlowComputeType = original.ComputeOptimized
	General          DataFlowComputeType = original.General
	MemoryOptimized  DataFlowComputeType = original.MemoryOptimized
)

type DataFlowDebugCommandType = original.DataFlowDebugCommandType

const (
	ExecuteExpressionQuery DataFlowDebugCommandType = original.ExecuteExpressionQuery
	ExecutePreviewQuery    DataFlowDebugCommandType = original.ExecutePreviewQuery
	ExecuteStatisticsQuery DataFlowDebugCommandType = original.ExecuteStatisticsQuery
)

type DayOfWeek = original.DayOfWeek

const (
	Friday    DayOfWeek = original.Friday
	Monday    DayOfWeek = original.Monday
	Saturday  DayOfWeek = original.Saturday
	Sunday    DayOfWeek = original.Sunday
	Thursday  DayOfWeek = original.Thursday
	Tuesday   DayOfWeek = original.Tuesday
	Wednesday DayOfWeek = original.Wednesday
)

type DaysOfWeek = original.DaysOfWeek

const (
	DaysOfWeekFriday    DaysOfWeek = original.DaysOfWeekFriday
	DaysOfWeekMonday    DaysOfWeek = original.DaysOfWeekMonday
	DaysOfWeekSaturday  DaysOfWeek = original.DaysOfWeekSaturday
	DaysOfWeekSunday    DaysOfWeek = original.DaysOfWeekSunday
	DaysOfWeekThursday  DaysOfWeek = original.DaysOfWeekThursday
	DaysOfWeekTuesday   DaysOfWeek = original.DaysOfWeekTuesday
	DaysOfWeekWednesday DaysOfWeek = original.DaysOfWeekWednesday
)

type Db2AuthenticationType = original.Db2AuthenticationType

const (
	Basic Db2AuthenticationType = original.Basic
)

type DependencyCondition = original.DependencyCondition

const (
	Completed DependencyCondition = original.Completed
	Failed    DependencyCondition = original.Failed
	Skipped   DependencyCondition = original.Skipped
	Succeeded DependencyCondition = original.Succeeded
)

type DynamicsAuthenticationType = original.DynamicsAuthenticationType

const (
	AADServicePrincipal DynamicsAuthenticationType = original.AADServicePrincipal
	Ifd                 DynamicsAuthenticationType = original.Ifd
	Office365           DynamicsAuthenticationType = original.Office365
)

type DynamicsDeploymentType = original.DynamicsDeploymentType

const (
	Online            DynamicsDeploymentType = original.Online
	OnPremisesWithIfd DynamicsDeploymentType = original.OnPremisesWithIfd
)

type EventSubscriptionStatus = original.EventSubscriptionStatus

const (
	Deprovisioning EventSubscriptionStatus = original.Deprovisioning
	Disabled       EventSubscriptionStatus = original.Disabled
	Enabled        EventSubscriptionStatus = original.Enabled
	Provisioning   EventSubscriptionStatus = original.Provisioning
	Unknown        EventSubscriptionStatus = original.Unknown
)

type FtpAuthenticationType = original.FtpAuthenticationType

const (
	FtpAuthenticationTypeAnonymous FtpAuthenticationType = original.FtpAuthenticationTypeAnonymous
	FtpAuthenticationTypeBasic     FtpAuthenticationType = original.FtpAuthenticationTypeBasic
)

type GoogleAdWordsAuthenticationType = original.GoogleAdWordsAuthenticationType

const (
	ServiceAuthentication GoogleAdWordsAuthenticationType = original.ServiceAuthentication
	UserAuthentication    GoogleAdWordsAuthenticationType = original.UserAuthentication
)

type GoogleBigQueryAuthenticationType = original.GoogleBigQueryAuthenticationType

const (
	GoogleBigQueryAuthenticationTypeServiceAuthentication GoogleBigQueryAuthenticationType = original.GoogleBigQueryAuthenticationTypeServiceAuthentication
	GoogleBigQueryAuthenticationTypeUserAuthentication    GoogleBigQueryAuthenticationType = original.GoogleBigQueryAuthenticationTypeUserAuthentication
)

type HBaseAuthenticationType = original.HBaseAuthenticationType

const (
	HBaseAuthenticationTypeAnonymous HBaseAuthenticationType = original.HBaseAuthenticationTypeAnonymous
	HBaseAuthenticationTypeBasic     HBaseAuthenticationType = original.HBaseAuthenticationTypeBasic
)

type HDInsightActivityDebugInfoOption = original.HDInsightActivityDebugInfoOption

const (
	HDInsightActivityDebugInfoOptionAlways  HDInsightActivityDebugInfoOption = original.HDInsightActivityDebugInfoOptionAlways
	HDInsightActivityDebugInfoOptionFailure HDInsightActivityDebugInfoOption = original.HDInsightActivityDebugInfoOptionFailure
	HDInsightActivityDebugInfoOptionNone    HDInsightActivityDebugInfoOption = original.HDInsightActivityDebugInfoOptionNone
)

type HTTPAuthenticationType = original.HTTPAuthenticationType

const (
	HTTPAuthenticationTypeAnonymous         HTTPAuthenticationType = original.HTTPAuthenticationTypeAnonymous
	HTTPAuthenticationTypeBasic             HTTPAuthenticationType = original.HTTPAuthenticationTypeBasic
	HTTPAuthenticationTypeClientCertificate HTTPAuthenticationType = original.HTTPAuthenticationTypeClientCertificate
	HTTPAuthenticationTypeDigest            HTTPAuthenticationType = original.HTTPAuthenticationTypeDigest
	HTTPAuthenticationTypeWindows           HTTPAuthenticationType = original.HTTPAuthenticationTypeWindows
)

type HiveAuthenticationType = original.HiveAuthenticationType

const (
	Anonymous                    HiveAuthenticationType = original.Anonymous
	Username                     HiveAuthenticationType = original.Username
	UsernameAndPassword          HiveAuthenticationType = original.UsernameAndPassword
	WindowsAzureHDInsightService HiveAuthenticationType = original.WindowsAzureHDInsightService
)

type HiveServerType = original.HiveServerType

const (
	HiveServer1      HiveServerType = original.HiveServer1
	HiveServer2      HiveServerType = original.HiveServer2
	HiveThriftServer HiveServerType = original.HiveThriftServer
)

type HiveThriftTransportProtocol = original.HiveThriftTransportProtocol

const (
	Binary HiveThriftTransportProtocol = original.Binary
	HTTP   HiveThriftTransportProtocol = original.HTTP
	SASL   HiveThriftTransportProtocol = original.SASL
)

type ImpalaAuthenticationType = original.ImpalaAuthenticationType

const (
	ImpalaAuthenticationTypeAnonymous           ImpalaAuthenticationType = original.ImpalaAuthenticationTypeAnonymous
	ImpalaAuthenticationTypeSASLUsername        ImpalaAuthenticationType = original.ImpalaAuthenticationTypeSASLUsername
	ImpalaAuthenticationTypeUsernameAndPassword ImpalaAuthenticationType = original.ImpalaAuthenticationTypeUsernameAndPassword
)

type IntegrationRuntimeAuthKeyName = original.IntegrationRuntimeAuthKeyName

const (
	AuthKey1 IntegrationRuntimeAuthKeyName = original.AuthKey1
	AuthKey2 IntegrationRuntimeAuthKeyName = original.AuthKey2
)

type IntegrationRuntimeAutoUpdate = original.IntegrationRuntimeAutoUpdate

const (
	Off IntegrationRuntimeAutoUpdate = original.Off
	On  IntegrationRuntimeAutoUpdate = original.On
)

type IntegrationRuntimeEdition = original.IntegrationRuntimeEdition

const (
	Enterprise IntegrationRuntimeEdition = original.Enterprise
	Standard   IntegrationRuntimeEdition = original.Standard
)

type IntegrationRuntimeEntityReferenceType = original.IntegrationRuntimeEntityReferenceType

const (
	IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference IntegrationRuntimeEntityReferenceType = original.IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference
	IntegrationRuntimeEntityReferenceTypeLinkedServiceReference      IntegrationRuntimeEntityReferenceType = original.IntegrationRuntimeEntityReferenceTypeLinkedServiceReference
)

type IntegrationRuntimeInternalChannelEncryptionMode = original.IntegrationRuntimeInternalChannelEncryptionMode

const (
	NotEncrypted IntegrationRuntimeInternalChannelEncryptionMode = original.NotEncrypted
	NotSet       IntegrationRuntimeInternalChannelEncryptionMode = original.NotSet
	SslEncrypted IntegrationRuntimeInternalChannelEncryptionMode = original.SslEncrypted
)

type IntegrationRuntimeLicenseType = original.IntegrationRuntimeLicenseType

const (
	BasePrice       IntegrationRuntimeLicenseType = original.BasePrice
	LicenseIncluded IntegrationRuntimeLicenseType = original.LicenseIncluded
)

type IntegrationRuntimeSsisCatalogPricingTier = original.IntegrationRuntimeSsisCatalogPricingTier

const (
	IntegrationRuntimeSsisCatalogPricingTierBasic     IntegrationRuntimeSsisCatalogPricingTier = original.IntegrationRuntimeSsisCatalogPricingTierBasic
	IntegrationRuntimeSsisCatalogPricingTierPremium   IntegrationRuntimeSsisCatalogPricingTier = original.IntegrationRuntimeSsisCatalogPricingTierPremium
	IntegrationRuntimeSsisCatalogPricingTierPremiumRS IntegrationRuntimeSsisCatalogPricingTier = original.IntegrationRuntimeSsisCatalogPricingTierPremiumRS
	IntegrationRuntimeSsisCatalogPricingTierStandard  IntegrationRuntimeSsisCatalogPricingTier = original.IntegrationRuntimeSsisCatalogPricingTierStandard
)

type IntegrationRuntimeState = original.IntegrationRuntimeState

const (
	IntegrationRuntimeStateAccessDenied     IntegrationRuntimeState = original.IntegrationRuntimeStateAccessDenied
	IntegrationRuntimeStateInitial          IntegrationRuntimeState = original.IntegrationRuntimeStateInitial
	IntegrationRuntimeStateLimited          IntegrationRuntimeState = original.IntegrationRuntimeStateLimited
	IntegrationRuntimeStateNeedRegistration IntegrationRuntimeState = original.IntegrationRuntimeStateNeedRegistration
	IntegrationRuntimeStateOffline          IntegrationRuntimeState = original.IntegrationRuntimeStateOffline
	IntegrationRuntimeStateOnline           IntegrationRuntimeState = original.IntegrationRuntimeStateOnline
	IntegrationRuntimeStateStarted          IntegrationRuntimeState = original.IntegrationRuntimeStateStarted
	IntegrationRuntimeStateStarting         IntegrationRuntimeState = original.IntegrationRuntimeStateStarting
	IntegrationRuntimeStateStopped          IntegrationRuntimeState = original.IntegrationRuntimeStateStopped
	IntegrationRuntimeStateStopping         IntegrationRuntimeState = original.IntegrationRuntimeStateStopping
)

type IntegrationRuntimeType = original.IntegrationRuntimeType

const (
	Managed    IntegrationRuntimeType = original.Managed
	SelfHosted IntegrationRuntimeType = original.SelfHosted
)

type IntegrationRuntimeUpdateResult = original.IntegrationRuntimeUpdateResult

const (
	IntegrationRuntimeUpdateResultFail    IntegrationRuntimeUpdateResult = original.IntegrationRuntimeUpdateResultFail
	IntegrationRuntimeUpdateResultNone    IntegrationRuntimeUpdateResult = original.IntegrationRuntimeUpdateResultNone
	IntegrationRuntimeUpdateResultSucceed IntegrationRuntimeUpdateResult = original.IntegrationRuntimeUpdateResultSucceed
)

type JSONWriteFilePattern = original.JSONWriteFilePattern

const (
	ArrayOfObjects JSONWriteFilePattern = original.ArrayOfObjects
	SetOfObjects   JSONWriteFilePattern = original.SetOfObjects
)

type ManagedIntegrationRuntimeNodeStatus = original.ManagedIntegrationRuntimeNodeStatus

const (
	Available   ManagedIntegrationRuntimeNodeStatus = original.Available
	Recycling   ManagedIntegrationRuntimeNodeStatus = original.Recycling
	Starting    ManagedIntegrationRuntimeNodeStatus = original.Starting
	Unavailable ManagedIntegrationRuntimeNodeStatus = original.Unavailable
)

type MongoDbAuthenticationType = original.MongoDbAuthenticationType

const (
	MongoDbAuthenticationTypeAnonymous MongoDbAuthenticationType = original.MongoDbAuthenticationTypeAnonymous
	MongoDbAuthenticationTypeBasic     MongoDbAuthenticationType = original.MongoDbAuthenticationTypeBasic
)

type NetezzaPartitionOption = original.NetezzaPartitionOption

const (
	NetezzaPartitionOptionDataSlice    NetezzaPartitionOption = original.NetezzaPartitionOptionDataSlice
	NetezzaPartitionOptionDynamicRange NetezzaPartitionOption = original.NetezzaPartitionOptionDynamicRange
	NetezzaPartitionOptionNone         NetezzaPartitionOption = original.NetezzaPartitionOptionNone
)

type ODataAadServicePrincipalCredentialType = original.ODataAadServicePrincipalCredentialType

const (
	ServicePrincipalCert ODataAadServicePrincipalCredentialType = original.ServicePrincipalCert
	ServicePrincipalKey  ODataAadServicePrincipalCredentialType = original.ServicePrincipalKey
)

type ODataAuthenticationType = original.ODataAuthenticationType

const (
	ODataAuthenticationTypeAadServicePrincipal    ODataAuthenticationType = original.ODataAuthenticationTypeAadServicePrincipal
	ODataAuthenticationTypeAnonymous              ODataAuthenticationType = original.ODataAuthenticationTypeAnonymous
	ODataAuthenticationTypeBasic                  ODataAuthenticationType = original.ODataAuthenticationTypeBasic
	ODataAuthenticationTypeManagedServiceIdentity ODataAuthenticationType = original.ODataAuthenticationTypeManagedServiceIdentity
	ODataAuthenticationTypeWindows                ODataAuthenticationType = original.ODataAuthenticationTypeWindows
)

type OraclePartitionOption = original.OraclePartitionOption

const (
	OraclePartitionOptionDynamicRange              OraclePartitionOption = original.OraclePartitionOptionDynamicRange
	OraclePartitionOptionNone                      OraclePartitionOption = original.OraclePartitionOptionNone
	OraclePartitionOptionPhysicalPartitionsOfTable OraclePartitionOption = original.OraclePartitionOptionPhysicalPartitionsOfTable
)

type OrcCompressionCodec = original.OrcCompressionCodec

const (
	OrcCompressionCodecNone   OrcCompressionCodec = original.OrcCompressionCodecNone
	OrcCompressionCodecSnappy OrcCompressionCodec = original.OrcCompressionCodecSnappy
	OrcCompressionCodecZlib   OrcCompressionCodec = original.OrcCompressionCodecZlib
)

type ParameterType = original.ParameterType

const (
	ParameterTypeArray        ParameterType = original.ParameterTypeArray
	ParameterTypeBool         ParameterType = original.ParameterTypeBool
	ParameterTypeFloat        ParameterType = original.ParameterTypeFloat
	ParameterTypeInt          ParameterType = original.ParameterTypeInt
	ParameterTypeObject       ParameterType = original.ParameterTypeObject
	ParameterTypeSecureString ParameterType = original.ParameterTypeSecureString
	ParameterTypeString       ParameterType = original.ParameterTypeString
)

type PhoenixAuthenticationType = original.PhoenixAuthenticationType

const (
	PhoenixAuthenticationTypeAnonymous                    PhoenixAuthenticationType = original.PhoenixAuthenticationTypeAnonymous
	PhoenixAuthenticationTypeUsernameAndPassword          PhoenixAuthenticationType = original.PhoenixAuthenticationTypeUsernameAndPassword
	PhoenixAuthenticationTypeWindowsAzureHDInsightService PhoenixAuthenticationType = original.PhoenixAuthenticationTypeWindowsAzureHDInsightService
)

type PolybaseSettingsRejectType = original.PolybaseSettingsRejectType

const (
	Percentage PolybaseSettingsRejectType = original.Percentage
	Value      PolybaseSettingsRejectType = original.Value
)

type PrestoAuthenticationType = original.PrestoAuthenticationType

const (
	PrestoAuthenticationTypeAnonymous PrestoAuthenticationType = original.PrestoAuthenticationTypeAnonymous
	PrestoAuthenticationTypeLDAP      PrestoAuthenticationType = original.PrestoAuthenticationTypeLDAP
)

type RecurrenceFrequency = original.RecurrenceFrequency

const (
	Day          RecurrenceFrequency = original.Day
	Hour         RecurrenceFrequency = original.Hour
	Minute       RecurrenceFrequency = original.Minute
	Month        RecurrenceFrequency = original.Month
	NotSpecified RecurrenceFrequency = original.NotSpecified
	Week         RecurrenceFrequency = original.Week
	Year         RecurrenceFrequency = original.Year
)

type RestServiceAuthenticationType = original.RestServiceAuthenticationType

const (
	RestServiceAuthenticationTypeAadServicePrincipal    RestServiceAuthenticationType = original.RestServiceAuthenticationTypeAadServicePrincipal
	RestServiceAuthenticationTypeAnonymous              RestServiceAuthenticationType = original.RestServiceAuthenticationTypeAnonymous
	RestServiceAuthenticationTypeBasic                  RestServiceAuthenticationType = original.RestServiceAuthenticationTypeBasic
	RestServiceAuthenticationTypeManagedServiceIdentity RestServiceAuthenticationType = original.RestServiceAuthenticationTypeManagedServiceIdentity
)

type RunQueryFilterOperand = original.RunQueryFilterOperand

const (
	ActivityName        RunQueryFilterOperand = original.ActivityName
	ActivityRunEnd      RunQueryFilterOperand = original.ActivityRunEnd
	ActivityRunStart    RunQueryFilterOperand = original.ActivityRunStart
	ActivityType        RunQueryFilterOperand = original.ActivityType
	LatestOnly          RunQueryFilterOperand = original.LatestOnly
	PipelineName        RunQueryFilterOperand = original.PipelineName
	RunEnd              RunQueryFilterOperand = original.RunEnd
	RunGroupID          RunQueryFilterOperand = original.RunGroupID
	RunStart            RunQueryFilterOperand = original.RunStart
	Status              RunQueryFilterOperand = original.Status
	TriggerName         RunQueryFilterOperand = original.TriggerName
	TriggerRunTimestamp RunQueryFilterOperand = original.TriggerRunTimestamp
)

type RunQueryFilterOperator = original.RunQueryFilterOperator

const (
	Equals    RunQueryFilterOperator = original.Equals
	In        RunQueryFilterOperator = original.In
	NotEquals RunQueryFilterOperator = original.NotEquals
	NotIn     RunQueryFilterOperator = original.NotIn
)

type RunQueryOrder = original.RunQueryOrder

const (
	ASC  RunQueryOrder = original.ASC
	DESC RunQueryOrder = original.DESC
)

type RunQueryOrderByField = original.RunQueryOrderByField

const (
	RunQueryOrderByFieldActivityName        RunQueryOrderByField = original.RunQueryOrderByFieldActivityName
	RunQueryOrderByFieldActivityRunEnd      RunQueryOrderByField = original.RunQueryOrderByFieldActivityRunEnd
	RunQueryOrderByFieldActivityRunStart    RunQueryOrderByField = original.RunQueryOrderByFieldActivityRunStart
	RunQueryOrderByFieldPipelineName        RunQueryOrderByField = original.RunQueryOrderByFieldPipelineName
	RunQueryOrderByFieldRunEnd              RunQueryOrderByField = original.RunQueryOrderByFieldRunEnd
	RunQueryOrderByFieldRunStart            RunQueryOrderByField = original.RunQueryOrderByFieldRunStart
	RunQueryOrderByFieldStatus              RunQueryOrderByField = original.RunQueryOrderByFieldStatus
	RunQueryOrderByFieldTriggerName         RunQueryOrderByField = original.RunQueryOrderByFieldTriggerName
	RunQueryOrderByFieldTriggerRunTimestamp RunQueryOrderByField = original.RunQueryOrderByFieldTriggerRunTimestamp
)

type SalesforceSinkWriteBehavior = original.SalesforceSinkWriteBehavior

const (
	Insert SalesforceSinkWriteBehavior = original.Insert
	Upsert SalesforceSinkWriteBehavior = original.Upsert
)

type SalesforceSourceReadBehavior = original.SalesforceSourceReadBehavior

const (
	Query    SalesforceSourceReadBehavior = original.Query
	QueryAll SalesforceSourceReadBehavior = original.QueryAll
)

type SapCloudForCustomerSinkWriteBehavior = original.SapCloudForCustomerSinkWriteBehavior

const (
	SapCloudForCustomerSinkWriteBehaviorInsert SapCloudForCustomerSinkWriteBehavior = original.SapCloudForCustomerSinkWriteBehaviorInsert
	SapCloudForCustomerSinkWriteBehaviorUpdate SapCloudForCustomerSinkWriteBehavior = original.SapCloudForCustomerSinkWriteBehaviorUpdate
)

type SapHanaAuthenticationType = original.SapHanaAuthenticationType

const (
	SapHanaAuthenticationTypeBasic   SapHanaAuthenticationType = original.SapHanaAuthenticationTypeBasic
	SapHanaAuthenticationTypeWindows SapHanaAuthenticationType = original.SapHanaAuthenticationTypeWindows
)

type SapHanaPartitionOption = original.SapHanaPartitionOption

const (
	SapHanaPartitionOptionNone                      SapHanaPartitionOption = original.SapHanaPartitionOptionNone
	SapHanaPartitionOptionPhysicalPartitionsOfTable SapHanaPartitionOption = original.SapHanaPartitionOptionPhysicalPartitionsOfTable
	SapHanaPartitionOptionSapHanaDynamicRange       SapHanaPartitionOption = original.SapHanaPartitionOptionSapHanaDynamicRange
)

type SapTablePartitionOption = original.SapTablePartitionOption

const (
	SapTablePartitionOptionNone                     SapTablePartitionOption = original.SapTablePartitionOptionNone
	SapTablePartitionOptionPartitionOnCalendarDate  SapTablePartitionOption = original.SapTablePartitionOptionPartitionOnCalendarDate
	SapTablePartitionOptionPartitionOnCalendarMonth SapTablePartitionOption = original.SapTablePartitionOptionPartitionOnCalendarMonth
	SapTablePartitionOptionPartitionOnCalendarYear  SapTablePartitionOption = original.SapTablePartitionOptionPartitionOnCalendarYear
	SapTablePartitionOptionPartitionOnInt           SapTablePartitionOption = original.SapTablePartitionOptionPartitionOnInt
	SapTablePartitionOptionPartitionOnTime          SapTablePartitionOption = original.SapTablePartitionOptionPartitionOnTime
)

type SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatus

const (
	SelfHostedIntegrationRuntimeNodeStatusInitializeFailed SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusInitializeFailed
	SelfHostedIntegrationRuntimeNodeStatusInitializing     SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusInitializing
	SelfHostedIntegrationRuntimeNodeStatusLimited          SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusLimited
	SelfHostedIntegrationRuntimeNodeStatusNeedRegistration SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusNeedRegistration
	SelfHostedIntegrationRuntimeNodeStatusOffline          SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusOffline
	SelfHostedIntegrationRuntimeNodeStatusOnline           SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusOnline
	SelfHostedIntegrationRuntimeNodeStatusUpgrading        SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusUpgrading
)

type ServiceNowAuthenticationType = original.ServiceNowAuthenticationType

const (
	ServiceNowAuthenticationTypeBasic  ServiceNowAuthenticationType = original.ServiceNowAuthenticationTypeBasic
	ServiceNowAuthenticationTypeOAuth2 ServiceNowAuthenticationType = original.ServiceNowAuthenticationTypeOAuth2
)

type SftpAuthenticationType = original.SftpAuthenticationType

const (
	SftpAuthenticationTypeBasic        SftpAuthenticationType = original.SftpAuthenticationTypeBasic
	SftpAuthenticationTypeSSHPublicKey SftpAuthenticationType = original.SftpAuthenticationTypeSSHPublicKey
)

type SparkAuthenticationType = original.SparkAuthenticationType

const (
	SparkAuthenticationTypeAnonymous                    SparkAuthenticationType = original.SparkAuthenticationTypeAnonymous
	SparkAuthenticationTypeUsername                     SparkAuthenticationType = original.SparkAuthenticationTypeUsername
	SparkAuthenticationTypeUsernameAndPassword          SparkAuthenticationType = original.SparkAuthenticationTypeUsernameAndPassword
	SparkAuthenticationTypeWindowsAzureHDInsightService SparkAuthenticationType = original.SparkAuthenticationTypeWindowsAzureHDInsightService
)

type SparkServerType = original.SparkServerType

const (
	SharkServer       SparkServerType = original.SharkServer
	SharkServer2      SparkServerType = original.SharkServer2
	SparkThriftServer SparkServerType = original.SparkThriftServer
)

type SparkThriftTransportProtocol = original.SparkThriftTransportProtocol

const (
	SparkThriftTransportProtocolBinary SparkThriftTransportProtocol = original.SparkThriftTransportProtocolBinary
	SparkThriftTransportProtocolHTTP   SparkThriftTransportProtocol = original.SparkThriftTransportProtocolHTTP
	SparkThriftTransportProtocolSASL   SparkThriftTransportProtocol = original.SparkThriftTransportProtocolSASL
)

type SsisObjectMetadataType = original.SsisObjectMetadataType

const (
	Environment SsisObjectMetadataType = original.Environment
	Folder      SsisObjectMetadataType = original.Folder
	Package     SsisObjectMetadataType = original.Package
	Project     SsisObjectMetadataType = original.Project
)

type SsisPackageLocationType = original.SsisPackageLocationType

const (
	File          SsisPackageLocationType = original.File
	InlinePackage SsisPackageLocationType = original.InlinePackage
	SSISDB        SsisPackageLocationType = original.SSISDB
)

type StoredProcedureParameterType = original.StoredProcedureParameterType

const (
	Boolean StoredProcedureParameterType = original.Boolean
	Date    StoredProcedureParameterType = original.Date
	Decimal StoredProcedureParameterType = original.Decimal
	GUID    StoredProcedureParameterType = original.GUID
	Int     StoredProcedureParameterType = original.Int
	Int64   StoredProcedureParameterType = original.Int64
	String  StoredProcedureParameterType = original.String
)

type SybaseAuthenticationType = original.SybaseAuthenticationType

const (
	SybaseAuthenticationTypeBasic   SybaseAuthenticationType = original.SybaseAuthenticationTypeBasic
	SybaseAuthenticationTypeWindows SybaseAuthenticationType = original.SybaseAuthenticationTypeWindows
)

type TeradataAuthenticationType = original.TeradataAuthenticationType

const (
	TeradataAuthenticationTypeBasic   TeradataAuthenticationType = original.TeradataAuthenticationTypeBasic
	TeradataAuthenticationTypeWindows TeradataAuthenticationType = original.TeradataAuthenticationTypeWindows
)

type TeradataPartitionOption = original.TeradataPartitionOption

const (
	TeradataPartitionOptionDynamicRange TeradataPartitionOption = original.TeradataPartitionOptionDynamicRange
	TeradataPartitionOptionHash         TeradataPartitionOption = original.TeradataPartitionOptionHash
	TeradataPartitionOptionNone         TeradataPartitionOption = original.TeradataPartitionOptionNone
)

type TriggerRunStatus = original.TriggerRunStatus

const (
	TriggerRunStatusFailed     TriggerRunStatus = original.TriggerRunStatusFailed
	TriggerRunStatusInprogress TriggerRunStatus = original.TriggerRunStatusInprogress
	TriggerRunStatusSucceeded  TriggerRunStatus = original.TriggerRunStatusSucceeded
)

type TriggerRuntimeState = original.TriggerRuntimeState

const (
	TriggerRuntimeStateDisabled TriggerRuntimeState = original.TriggerRuntimeStateDisabled
	TriggerRuntimeStateStarted  TriggerRuntimeState = original.TriggerRuntimeStateStarted
	TriggerRuntimeStateStopped  TriggerRuntimeState = original.TriggerRuntimeStateStopped
)

type TumblingWindowFrequency = original.TumblingWindowFrequency

const (
	TumblingWindowFrequencyHour   TumblingWindowFrequency = original.TumblingWindowFrequencyHour
	TumblingWindowFrequencyMinute TumblingWindowFrequency = original.TumblingWindowFrequencyMinute
)

type Type = original.Type

const (
	TypeAzureKeyVaultSecret Type = original.TypeAzureKeyVaultSecret
	TypeSecretBase          Type = original.TypeSecretBase
	TypeSecureString        Type = original.TypeSecureString
)

type TypeBasicActivity = original.TypeBasicActivity

const (
	TypeActivity                 TypeBasicActivity = original.TypeActivity
	TypeAppendVariable           TypeBasicActivity = original.TypeAppendVariable
	TypeAzureDataExplorerCommand TypeBasicActivity = original.TypeAzureDataExplorerCommand
	TypeAzureFunctionActivity    TypeBasicActivity = original.TypeAzureFunctionActivity
	TypeAzureMLBatchExecution    TypeBasicActivity = original.TypeAzureMLBatchExecution
	TypeAzureMLExecutePipeline   TypeBasicActivity = original.TypeAzureMLExecutePipeline
	TypeAzureMLUpdateResource    TypeBasicActivity = original.TypeAzureMLUpdateResource
	TypeContainer                TypeBasicActivity = original.TypeContainer
	TypeCopy                     TypeBasicActivity = original.TypeCopy
	TypeCustom                   TypeBasicActivity = original.TypeCustom
	TypeDatabricksNotebook       TypeBasicActivity = original.TypeDatabricksNotebook
	TypeDatabricksSparkJar       TypeBasicActivity = original.TypeDatabricksSparkJar
	TypeDatabricksSparkPython    TypeBasicActivity = original.TypeDatabricksSparkPython
	TypeDataLakeAnalyticsUSQL    TypeBasicActivity = original.TypeDataLakeAnalyticsUSQL
	TypeDelete                   TypeBasicActivity = original.TypeDelete
	TypeExecuteDataFlow          TypeBasicActivity = original.TypeExecuteDataFlow
	TypeExecutePipeline          TypeBasicActivity = original.TypeExecutePipeline
	TypeExecuteSSISPackage       TypeBasicActivity = original.TypeExecuteSSISPackage
	TypeExecution                TypeBasicActivity = original.TypeExecution
	TypeFilter                   TypeBasicActivity = original.TypeFilter
	TypeForEach                  TypeBasicActivity = original.TypeForEach
	TypeGetMetadata              TypeBasicActivity = original.TypeGetMetadata
	TypeHDInsightHive            TypeBasicActivity = original.TypeHDInsightHive
	TypeHDInsightMapReduce       TypeBasicActivity = original.TypeHDInsightMapReduce
	TypeHDInsightPig             TypeBasicActivity = original.TypeHDInsightPig
	TypeHDInsightSpark           TypeBasicActivity = original.TypeHDInsightSpark
	TypeHDInsightStreaming       TypeBasicActivity = original.TypeHDInsightStreaming
	TypeIfCondition              TypeBasicActivity = original.TypeIfCondition
	TypeLookup                   TypeBasicActivity = original.TypeLookup
	TypeSetVariable              TypeBasicActivity = original.TypeSetVariable
	TypeSQLServerStoredProcedure TypeBasicActivity = original.TypeSQLServerStoredProcedure
	TypeSwitch                   TypeBasicActivity = original.TypeSwitch
	TypeUntil                    TypeBasicActivity = original.TypeUntil
	TypeValidation               TypeBasicActivity = original.TypeValidation
	TypeWait                     TypeBasicActivity = original.TypeWait
	TypeWebActivity              TypeBasicActivity = original.TypeWebActivity
	TypeWebHook                  TypeBasicActivity = original.TypeWebHook
)

type TypeBasicCopySink = original.TypeBasicCopySink

const (
	TypeAvroSink                     TypeBasicCopySink = original.TypeAvroSink
	TypeAzureBlobFSSink              TypeBasicCopySink = original.TypeAzureBlobFSSink
	TypeAzureDataExplorerSink        TypeBasicCopySink = original.TypeAzureDataExplorerSink
	TypeAzureDataLakeStoreSink       TypeBasicCopySink = original.TypeAzureDataLakeStoreSink
	TypeAzureMySQLSink               TypeBasicCopySink = original.TypeAzureMySQLSink
	TypeAzurePostgreSQLSink          TypeBasicCopySink = original.TypeAzurePostgreSQLSink
	TypeAzureQueueSink               TypeBasicCopySink = original.TypeAzureQueueSink
	TypeAzureSearchIndexSink         TypeBasicCopySink = original.TypeAzureSearchIndexSink
	TypeAzureSQLSink                 TypeBasicCopySink = original.TypeAzureSQLSink
	TypeAzureTableSink               TypeBasicCopySink = original.TypeAzureTableSink
	TypeBinarySink                   TypeBasicCopySink = original.TypeBinarySink
	TypeBlobSink                     TypeBasicCopySink = original.TypeBlobSink
	TypeCommonDataServiceForAppsSink TypeBasicCopySink = original.TypeCommonDataServiceForAppsSink
	TypeCopySink                     TypeBasicCopySink = original.TypeCopySink
	TypeCosmosDbMongoDbAPISink       TypeBasicCopySink = original.TypeCosmosDbMongoDbAPISink
	TypeCosmosDbSQLAPISink           TypeBasicCopySink = original.TypeCosmosDbSQLAPISink
	TypeDelimitedTextSink            TypeBasicCopySink = original.TypeDelimitedTextSink
	TypeDocumentDbCollectionSink     TypeBasicCopySink = original.TypeDocumentDbCollectionSink
	TypeDynamicsCrmSink              TypeBasicCopySink = original.TypeDynamicsCrmSink
	TypeDynamicsSink                 TypeBasicCopySink = original.TypeDynamicsSink
	TypeFileSystemSink               TypeBasicCopySink = original.TypeFileSystemSink
	TypeInformixSink                 TypeBasicCopySink = original.TypeInformixSink
	TypeJSONSink                     TypeBasicCopySink = original.TypeJSONSink
	TypeMicrosoftAccessSink          TypeBasicCopySink = original.TypeMicrosoftAccessSink
	TypeOdbcSink                     TypeBasicCopySink = original.TypeOdbcSink
	TypeOracleSink                   TypeBasicCopySink = original.TypeOracleSink
	TypeOrcSink                      TypeBasicCopySink = original.TypeOrcSink
	TypeParquetSink                  TypeBasicCopySink = original.TypeParquetSink
	TypeSalesforceServiceCloudSink   TypeBasicCopySink = original.TypeSalesforceServiceCloudSink
	TypeSalesforceSink               TypeBasicCopySink = original.TypeSalesforceSink
	TypeSapCloudForCustomerSink      TypeBasicCopySink = original.TypeSapCloudForCustomerSink
	TypeSQLDWSink                    TypeBasicCopySink = original.TypeSQLDWSink
	TypeSQLMISink                    TypeBasicCopySink = original.TypeSQLMISink
	TypeSQLServerSink                TypeBasicCopySink = original.TypeSQLServerSink
	TypeSQLSink                      TypeBasicCopySink = original.TypeSQLSink
)

type TypeBasicCopySource = original.TypeBasicCopySource

const (
	TypeAmazonMWSSource                TypeBasicCopySource = original.TypeAmazonMWSSource
	TypeAmazonRedshiftSource           TypeBasicCopySource = original.TypeAmazonRedshiftSource
	TypeAvroSource                     TypeBasicCopySource = original.TypeAvroSource
	TypeAzureBlobFSSource              TypeBasicCopySource = original.TypeAzureBlobFSSource
	TypeAzureDataExplorerSource        TypeBasicCopySource = original.TypeAzureDataExplorerSource
	TypeAzureDataLakeStoreSource       TypeBasicCopySource = original.TypeAzureDataLakeStoreSource
	TypeAzureMariaDBSource             TypeBasicCopySource = original.TypeAzureMariaDBSource
	TypeAzureMySQLSource               TypeBasicCopySource = original.TypeAzureMySQLSource
	TypeAzurePostgreSQLSource          TypeBasicCopySource = original.TypeAzurePostgreSQLSource
	TypeAzureSQLSource                 TypeBasicCopySource = original.TypeAzureSQLSource
	TypeAzureTableSource               TypeBasicCopySource = original.TypeAzureTableSource
	TypeBinarySource                   TypeBasicCopySource = original.TypeBinarySource
	TypeBlobSource                     TypeBasicCopySource = original.TypeBlobSource
	TypeCassandraSource                TypeBasicCopySource = original.TypeCassandraSource
	TypeCommonDataServiceForAppsSource TypeBasicCopySource = original.TypeCommonDataServiceForAppsSource
	TypeConcurSource                   TypeBasicCopySource = original.TypeConcurSource
	TypeCopySource                     TypeBasicCopySource = original.TypeCopySource
	TypeCosmosDbMongoDbAPISource       TypeBasicCopySource = original.TypeCosmosDbMongoDbAPISource
	TypeCosmosDbSQLAPISource           TypeBasicCopySource = original.TypeCosmosDbSQLAPISource
	TypeCouchbaseSource                TypeBasicCopySource = original.TypeCouchbaseSource
	TypeDb2Source                      TypeBasicCopySource = original.TypeDb2Source
	TypeDelimitedTextSource            TypeBasicCopySource = original.TypeDelimitedTextSource
	TypeDocumentDbCollectionSource     TypeBasicCopySource = original.TypeDocumentDbCollectionSource
	TypeDrillSource                    TypeBasicCopySource = original.TypeDrillSource
	TypeDynamicsAXSource               TypeBasicCopySource = original.TypeDynamicsAXSource
	TypeDynamicsCrmSource              TypeBasicCopySource = original.TypeDynamicsCrmSource
	TypeDynamicsSource                 TypeBasicCopySource = original.TypeDynamicsSource
	TypeEloquaSource                   TypeBasicCopySource = original.TypeEloquaSource
	TypeFileSystemSource               TypeBasicCopySource = original.TypeFileSystemSource
	TypeGoogleAdWordsSource            TypeBasicCopySource = original.TypeGoogleAdWordsSource
	TypeGoogleBigQuerySource           TypeBasicCopySource = original.TypeGoogleBigQuerySource
	TypeGreenplumSource                TypeBasicCopySource = original.TypeGreenplumSource
	TypeHBaseSource                    TypeBasicCopySource = original.TypeHBaseSource
	TypeHdfsSource                     TypeBasicCopySource = original.TypeHdfsSource
	TypeHiveSource                     TypeBasicCopySource = original.TypeHiveSource
	TypeHTTPSource                     TypeBasicCopySource = original.TypeHTTPSource
	TypeHubspotSource                  TypeBasicCopySource = original.TypeHubspotSource
	TypeImpalaSource                   TypeBasicCopySource = original.TypeImpalaSource
	TypeInformixSource                 TypeBasicCopySource = original.TypeInformixSource
	TypeJiraSource                     TypeBasicCopySource = original.TypeJiraSource
	TypeJSONSource                     TypeBasicCopySource = original.TypeJSONSource
	TypeMagentoSource                  TypeBasicCopySource = original.TypeMagentoSource
	TypeMariaDBSource                  TypeBasicCopySource = original.TypeMariaDBSource
	TypeMarketoSource                  TypeBasicCopySource = original.TypeMarketoSource
	TypeMicrosoftAccessSource          TypeBasicCopySource = original.TypeMicrosoftAccessSource
	TypeMongoDbSource                  TypeBasicCopySource = original.TypeMongoDbSource
	TypeMongoDbV2Source                TypeBasicCopySource = original.TypeMongoDbV2Source
	TypeMySQLSource                    TypeBasicCopySource = original.TypeMySQLSource
	TypeNetezzaSource                  TypeBasicCopySource = original.TypeNetezzaSource
	TypeODataSource                    TypeBasicCopySource = original.TypeODataSource
	TypeOdbcSource                     TypeBasicCopySource = original.TypeOdbcSource
	TypeOffice365Source                TypeBasicCopySource = original.TypeOffice365Source
	TypeOracleServiceCloudSource       TypeBasicCopySource = original.TypeOracleServiceCloudSource
	TypeOracleSource                   TypeBasicCopySource = original.TypeOracleSource
	TypeOrcSource                      TypeBasicCopySource = original.TypeOrcSource
	TypeParquetSource                  TypeBasicCopySource = original.TypeParquetSource
	TypePaypalSource                   TypeBasicCopySource = original.TypePaypalSource
	TypePhoenixSource                  TypeBasicCopySource = original.TypePhoenixSource
	TypePostgreSQLSource               TypeBasicCopySource = original.TypePostgreSQLSource
	TypePrestoSource                   TypeBasicCopySource = original.TypePrestoSource
	TypeQuickBooksSource               TypeBasicCopySource = original.TypeQuickBooksSource
	TypeRelationalSource               TypeBasicCopySource = original.TypeRelationalSource
	TypeResponsysSource                TypeBasicCopySource = original.TypeResponsysSource
	TypeRestSource                     TypeBasicCopySource = original.TypeRestSource
	TypeSalesforceMarketingCloudSource TypeBasicCopySource = original.TypeSalesforceMarketingCloudSource
	TypeSalesforceServiceCloudSource   TypeBasicCopySource = original.TypeSalesforceServiceCloudSource
	TypeSalesforceSource               TypeBasicCopySource = original.TypeSalesforceSource
	TypeSapBwSource                    TypeBasicCopySource = original.TypeSapBwSource
	TypeSapCloudForCustomerSource      TypeBasicCopySource = original.TypeSapCloudForCustomerSource
	TypeSapEccSource                   TypeBasicCopySource = original.TypeSapEccSource
	TypeSapHanaSource                  TypeBasicCopySource = original.TypeSapHanaSource
	TypeSapOpenHubSource               TypeBasicCopySource = original.TypeSapOpenHubSource
	TypeSapTableSource                 TypeBasicCopySource = original.TypeSapTableSource
	TypeServiceNowSource               TypeBasicCopySource = original.TypeServiceNowSource
	TypeShopifySource                  TypeBasicCopySource = original.TypeShopifySource
	TypeSparkSource                    TypeBasicCopySource = original.TypeSparkSource
	TypeSQLDWSource                    TypeBasicCopySource = original.TypeSQLDWSource
	TypeSQLMISource                    TypeBasicCopySource = original.TypeSQLMISource
	TypeSQLServerSource                TypeBasicCopySource = original.TypeSQLServerSource
	TypeSQLSource                      TypeBasicCopySource = original.TypeSQLSource
	TypeSquareSource                   TypeBasicCopySource = original.TypeSquareSource
	TypeSybaseSource                   TypeBasicCopySource = original.TypeSybaseSource
	TypeTabularSource                  TypeBasicCopySource = original.TypeTabularSource
	TypeTeradataSource                 TypeBasicCopySource = original.TypeTeradataSource
	TypeVerticaSource                  TypeBasicCopySource = original.TypeVerticaSource
	TypeWebSource                      TypeBasicCopySource = original.TypeWebSource
	TypeXeroSource                     TypeBasicCopySource = original.TypeXeroSource
	TypeZohoSource                     TypeBasicCopySource = original.TypeZohoSource
)

type TypeBasicCustomSetupBase = original.TypeBasicCustomSetupBase

const (
	TypeCmdkeySetup              TypeBasicCustomSetupBase = original.TypeCmdkeySetup
	TypeComponentSetup           TypeBasicCustomSetupBase = original.TypeComponentSetup
	TypeCustomSetupBase          TypeBasicCustomSetupBase = original.TypeCustomSetupBase
	TypeEnvironmentVariableSetup TypeBasicCustomSetupBase = original.TypeEnvironmentVariableSetup
)

type TypeBasicDataFlow = original.TypeBasicDataFlow

const (
	TypeDataFlow        TypeBasicDataFlow = original.TypeDataFlow
	TypeMappingDataFlow TypeBasicDataFlow = original.TypeMappingDataFlow
)

type TypeBasicDataset = original.TypeBasicDataset

const (
	TypeAmazonMWSObject                TypeBasicDataset = original.TypeAmazonMWSObject
	TypeAmazonRedshiftTable            TypeBasicDataset = original.TypeAmazonRedshiftTable
	TypeAmazonS3Object                 TypeBasicDataset = original.TypeAmazonS3Object
	TypeAvro                           TypeBasicDataset = original.TypeAvro
	TypeAzureBlob                      TypeBasicDataset = original.TypeAzureBlob
	TypeAzureBlobFSFile                TypeBasicDataset = original.TypeAzureBlobFSFile
	TypeAzureDataExplorerTable         TypeBasicDataset = original.TypeAzureDataExplorerTable
	TypeAzureDataLakeStoreFile         TypeBasicDataset = original.TypeAzureDataLakeStoreFile
	TypeAzureMariaDBTable              TypeBasicDataset = original.TypeAzureMariaDBTable
	TypeAzureMySQLTable                TypeBasicDataset = original.TypeAzureMySQLTable
	TypeAzurePostgreSQLTable           TypeBasicDataset = original.TypeAzurePostgreSQLTable
	TypeAzureSearchIndex               TypeBasicDataset = original.TypeAzureSearchIndex
	TypeAzureSQLDWTable                TypeBasicDataset = original.TypeAzureSQLDWTable
	TypeAzureSQLMITable                TypeBasicDataset = original.TypeAzureSQLMITable
	TypeAzureSQLTable                  TypeBasicDataset = original.TypeAzureSQLTable
	TypeAzureTable                     TypeBasicDataset = original.TypeAzureTable
	TypeBinary                         TypeBasicDataset = original.TypeBinary
	TypeCassandraTable                 TypeBasicDataset = original.TypeCassandraTable
	TypeCommonDataServiceForAppsEntity TypeBasicDataset = original.TypeCommonDataServiceForAppsEntity
	TypeConcurObject                   TypeBasicDataset = original.TypeConcurObject
	TypeCosmosDbMongoDbAPICollection   TypeBasicDataset = original.TypeCosmosDbMongoDbAPICollection
	TypeCosmosDbSQLAPICollection       TypeBasicDataset = original.TypeCosmosDbSQLAPICollection
	TypeCouchbaseTable                 TypeBasicDataset = original.TypeCouchbaseTable
	TypeCustomDataset                  TypeBasicDataset = original.TypeCustomDataset
	TypeDataset                        TypeBasicDataset = original.TypeDataset
	TypeDb2Table                       TypeBasicDataset = original.TypeDb2Table
	TypeDelimitedText                  TypeBasicDataset = original.TypeDelimitedText
	TypeDocumentDbCollection           TypeBasicDataset = original.TypeDocumentDbCollection
	TypeDrillTable                     TypeBasicDataset = original.TypeDrillTable
	TypeDynamicsAXResource             TypeBasicDataset = original.TypeDynamicsAXResource
	TypeDynamicsCrmEntity              TypeBasicDataset = original.TypeDynamicsCrmEntity
	TypeDynamicsEntity                 TypeBasicDataset = original.TypeDynamicsEntity
	TypeEloquaObject                   TypeBasicDataset = original.TypeEloquaObject
	TypeFileShare                      TypeBasicDataset = original.TypeFileShare
	TypeGoogleAdWordsObject            TypeBasicDataset = original.TypeGoogleAdWordsObject
	TypeGoogleBigQueryObject           TypeBasicDataset = original.TypeGoogleBigQueryObject
	TypeGreenplumTable                 TypeBasicDataset = original.TypeGreenplumTable
	TypeHBaseObject                    TypeBasicDataset = original.TypeHBaseObject
	TypeHiveObject                     TypeBasicDataset = original.TypeHiveObject
	TypeHTTPFile                       TypeBasicDataset = original.TypeHTTPFile
	TypeHubspotObject                  TypeBasicDataset = original.TypeHubspotObject
	TypeImpalaObject                   TypeBasicDataset = original.TypeImpalaObject
	TypeInformixTable                  TypeBasicDataset = original.TypeInformixTable
	TypeJiraObject                     TypeBasicDataset = original.TypeJiraObject
	TypeJSON                           TypeBasicDataset = original.TypeJSON
	TypeMagentoObject                  TypeBasicDataset = original.TypeMagentoObject
	TypeMariaDBTable                   TypeBasicDataset = original.TypeMariaDBTable
	TypeMarketoObject                  TypeBasicDataset = original.TypeMarketoObject
	TypeMicrosoftAccessTable           TypeBasicDataset = original.TypeMicrosoftAccessTable
	TypeMongoDbCollection              TypeBasicDataset = original.TypeMongoDbCollection
	TypeMongoDbV2Collection            TypeBasicDataset = original.TypeMongoDbV2Collection
	TypeMySQLTable                     TypeBasicDataset = original.TypeMySQLTable
	TypeNetezzaTable                   TypeBasicDataset = original.TypeNetezzaTable
	TypeODataResource                  TypeBasicDataset = original.TypeODataResource
	TypeOdbcTable                      TypeBasicDataset = original.TypeOdbcTable
	TypeOffice365Table                 TypeBasicDataset = original.TypeOffice365Table
	TypeOracleServiceCloudObject       TypeBasicDataset = original.TypeOracleServiceCloudObject
	TypeOracleTable                    TypeBasicDataset = original.TypeOracleTable
	TypeOrc                            TypeBasicDataset = original.TypeOrc
	TypeParquet                        TypeBasicDataset = original.TypeParquet
	TypePaypalObject                   TypeBasicDataset = original.TypePaypalObject
	TypePhoenixObject                  TypeBasicDataset = original.TypePhoenixObject
	TypePostgreSQLTable                TypeBasicDataset = original.TypePostgreSQLTable
	TypePrestoObject                   TypeBasicDataset = original.TypePrestoObject
	TypeQuickBooksObject               TypeBasicDataset = original.TypeQuickBooksObject
	TypeRelationalTable                TypeBasicDataset = original.TypeRelationalTable
	TypeResponsysObject                TypeBasicDataset = original.TypeResponsysObject
	TypeRestResource                   TypeBasicDataset = original.TypeRestResource
	TypeSalesforceMarketingCloudObject TypeBasicDataset = original.TypeSalesforceMarketingCloudObject
	TypeSalesforceObject               TypeBasicDataset = original.TypeSalesforceObject
	TypeSalesforceServiceCloudObject   TypeBasicDataset = original.TypeSalesforceServiceCloudObject
	TypeSapBwCube                      TypeBasicDataset = original.TypeSapBwCube
	TypeSapCloudForCustomerResource    TypeBasicDataset = original.TypeSapCloudForCustomerResource
	TypeSapEccResource                 TypeBasicDataset = original.TypeSapEccResource
	TypeSapHanaTable                   TypeBasicDataset = original.TypeSapHanaTable
	TypeSapOpenHubTable                TypeBasicDataset = original.TypeSapOpenHubTable
	TypeSapTableResource               TypeBasicDataset = original.TypeSapTableResource
	TypeServiceNowObject               TypeBasicDataset = original.TypeServiceNowObject
	TypeShopifyObject                  TypeBasicDataset = original.TypeShopifyObject
	TypeSparkObject                    TypeBasicDataset = original.TypeSparkObject
	TypeSQLServerTable                 TypeBasicDataset = original.TypeSQLServerTable
	TypeSquareObject                   TypeBasicDataset = original.TypeSquareObject
	TypeSybaseTable                    TypeBasicDataset = original.TypeSybaseTable
	TypeTeradataTable                  TypeBasicDataset = original.TypeTeradataTable
	TypeVerticaTable                   TypeBasicDataset = original.TypeVerticaTable
	TypeWebTable                       TypeBasicDataset = original.TypeWebTable
	TypeXeroObject                     TypeBasicDataset = original.TypeXeroObject
	TypeZohoObject                     TypeBasicDataset = original.TypeZohoObject
)

type TypeBasicDatasetCompression = original.TypeBasicDatasetCompression

const (
	TypeBZip2              TypeBasicDatasetCompression = original.TypeBZip2
	TypeDatasetCompression TypeBasicDatasetCompression = original.TypeDatasetCompression
	TypeDeflate            TypeBasicDatasetCompression = original.TypeDeflate
	TypeGZip               TypeBasicDatasetCompression = original.TypeGZip
	TypeZipDeflate         TypeBasicDatasetCompression = original.TypeZipDeflate
)

type TypeBasicDatasetStorageFormat = original.TypeBasicDatasetStorageFormat

const (
	TypeAvroFormat           TypeBasicDatasetStorageFormat = original.TypeAvroFormat
	TypeDatasetStorageFormat TypeBasicDatasetStorageFormat = original.TypeDatasetStorageFormat
	TypeJSONFormat           TypeBasicDatasetStorageFormat = original.TypeJSONFormat
	TypeOrcFormat            TypeBasicDatasetStorageFormat = original.TypeOrcFormat
	TypeParquetFormat        TypeBasicDatasetStorageFormat = original.TypeParquetFormat
	TypeTextFormat           TypeBasicDatasetStorageFormat = original.TypeTextFormat
)

type TypeBasicDependencyReference = original.TypeBasicDependencyReference

const (
	TypeDependencyReference                          TypeBasicDependencyReference = original.TypeDependencyReference
	TypeSelfDependencyTumblingWindowTriggerReference TypeBasicDependencyReference = original.TypeSelfDependencyTumblingWindowTriggerReference
	TypeTriggerDependencyReference                   TypeBasicDependencyReference = original.TypeTriggerDependencyReference
	TypeTumblingWindowTriggerDependencyReference     TypeBasicDependencyReference = original.TypeTumblingWindowTriggerDependencyReference
)

type TypeBasicFactoryRepoConfiguration = original.TypeBasicFactoryRepoConfiguration

const (
	TypeFactoryGitHubConfiguration TypeBasicFactoryRepoConfiguration = original.TypeFactoryGitHubConfiguration
	TypeFactoryRepoConfiguration   TypeBasicFactoryRepoConfiguration = original.TypeFactoryRepoConfiguration
	TypeFactoryVSTSConfiguration   TypeBasicFactoryRepoConfiguration = original.TypeFactoryVSTSConfiguration
)

type TypeBasicIntegrationRuntime = original.TypeBasicIntegrationRuntime

const (
	TypeIntegrationRuntime TypeBasicIntegrationRuntime = original.TypeIntegrationRuntime
	TypeManaged            TypeBasicIntegrationRuntime = original.TypeManaged
	TypeSelfHosted         TypeBasicIntegrationRuntime = original.TypeSelfHosted
)

type TypeBasicIntegrationRuntimeStatus = original.TypeBasicIntegrationRuntimeStatus

const (
	TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus TypeBasicIntegrationRuntimeStatus = original.TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus
	TypeBasicIntegrationRuntimeStatusTypeManaged                  TypeBasicIntegrationRuntimeStatus = original.TypeBasicIntegrationRuntimeStatusTypeManaged
	TypeBasicIntegrationRuntimeStatusTypeSelfHosted               TypeBasicIntegrationRuntimeStatus = original.TypeBasicIntegrationRuntimeStatusTypeSelfHosted
)

type TypeBasicLinkedService = original.TypeBasicLinkedService

const (
	TypeAmazonMWS                TypeBasicLinkedService = original.TypeAmazonMWS
	TypeAmazonRedshift           TypeBasicLinkedService = original.TypeAmazonRedshift
	TypeAmazonS3                 TypeBasicLinkedService = original.TypeAmazonS3
	TypeAzureBatch               TypeBasicLinkedService = original.TypeAzureBatch
	TypeAzureBlobFS              TypeBasicLinkedService = original.TypeAzureBlobFS
	TypeAzureBlobStorage         TypeBasicLinkedService = original.TypeAzureBlobStorage
	TypeAzureDatabricks          TypeBasicLinkedService = original.TypeAzureDatabricks
	TypeAzureDataExplorer        TypeBasicLinkedService = original.TypeAzureDataExplorer
	TypeAzureDataLakeAnalytics   TypeBasicLinkedService = original.TypeAzureDataLakeAnalytics
	TypeAzureDataLakeStore       TypeBasicLinkedService = original.TypeAzureDataLakeStore
	TypeAzureFileStorage         TypeBasicLinkedService = original.TypeAzureFileStorage
	TypeAzureFunction            TypeBasicLinkedService = original.TypeAzureFunction
	TypeAzureKeyVault            TypeBasicLinkedService = original.TypeAzureKeyVault
	TypeAzureMariaDB             TypeBasicLinkedService = original.TypeAzureMariaDB
	TypeAzureML                  TypeBasicLinkedService = original.TypeAzureML
	TypeAzureMLService           TypeBasicLinkedService = original.TypeAzureMLService
	TypeAzureMySQL               TypeBasicLinkedService = original.TypeAzureMySQL
	TypeAzurePostgreSQL          TypeBasicLinkedService = original.TypeAzurePostgreSQL
	TypeAzureSearch              TypeBasicLinkedService = original.TypeAzureSearch
	TypeAzureSQLDatabase         TypeBasicLinkedService = original.TypeAzureSQLDatabase
	TypeAzureSQLDW               TypeBasicLinkedService = original.TypeAzureSQLDW
	TypeAzureSQLMI               TypeBasicLinkedService = original.TypeAzureSQLMI
	TypeAzureStorage             TypeBasicLinkedService = original.TypeAzureStorage
	TypeAzureTableStorage        TypeBasicLinkedService = original.TypeAzureTableStorage
	TypeCassandra                TypeBasicLinkedService = original.TypeCassandra
	TypeCommonDataServiceForApps TypeBasicLinkedService = original.TypeCommonDataServiceForApps
	TypeConcur                   TypeBasicLinkedService = original.TypeConcur
	TypeCosmosDb                 TypeBasicLinkedService = original.TypeCosmosDb
	TypeCosmosDbMongoDbAPI       TypeBasicLinkedService = original.TypeCosmosDbMongoDbAPI
	TypeCouchbase                TypeBasicLinkedService = original.TypeCouchbase
	TypeCustomDataSource         TypeBasicLinkedService = original.TypeCustomDataSource
	TypeDb2                      TypeBasicLinkedService = original.TypeDb2
	TypeDrill                    TypeBasicLinkedService = original.TypeDrill
	TypeDynamics                 TypeBasicLinkedService = original.TypeDynamics
	TypeDynamicsAX               TypeBasicLinkedService = original.TypeDynamicsAX
	TypeDynamicsCrm              TypeBasicLinkedService = original.TypeDynamicsCrm
	TypeEloqua                   TypeBasicLinkedService = original.TypeEloqua
	TypeFileServer               TypeBasicLinkedService = original.TypeFileServer
	TypeFtpServer                TypeBasicLinkedService = original.TypeFtpServer
	TypeGoogleAdWords            TypeBasicLinkedService = original.TypeGoogleAdWords
	TypeGoogleBigQuery           TypeBasicLinkedService = original.TypeGoogleBigQuery
	TypeGoogleCloudStorage       TypeBasicLinkedService = original.TypeGoogleCloudStorage
	TypeGreenplum                TypeBasicLinkedService = original.TypeGreenplum
	TypeHBase                    TypeBasicLinkedService = original.TypeHBase
	TypeHdfs                     TypeBasicLinkedService = original.TypeHdfs
	TypeHDInsight                TypeBasicLinkedService = original.TypeHDInsight
	TypeHDInsightOnDemand        TypeBasicLinkedService = original.TypeHDInsightOnDemand
	TypeHive                     TypeBasicLinkedService = original.TypeHive
	TypeHTTPServer               TypeBasicLinkedService = original.TypeHTTPServer
	TypeHubspot                  TypeBasicLinkedService = original.TypeHubspot
	TypeImpala                   TypeBasicLinkedService = original.TypeImpala
	TypeInformix                 TypeBasicLinkedService = original.TypeInformix
	TypeJira                     TypeBasicLinkedService = original.TypeJira
	TypeLinkedService            TypeBasicLinkedService = original.TypeLinkedService
	TypeMagento                  TypeBasicLinkedService = original.TypeMagento
	TypeMariaDB                  TypeBasicLinkedService = original.TypeMariaDB
	TypeMarketo                  TypeBasicLinkedService = original.TypeMarketo
	TypeMicrosoftAccess          TypeBasicLinkedService = original.TypeMicrosoftAccess
	TypeMongoDb                  TypeBasicLinkedService = original.TypeMongoDb
	TypeMongoDbV2                TypeBasicLinkedService = original.TypeMongoDbV2
	TypeMySQL                    TypeBasicLinkedService = original.TypeMySQL
	TypeNetezza                  TypeBasicLinkedService = original.TypeNetezza
	TypeOData                    TypeBasicLinkedService = original.TypeOData
	TypeOdbc                     TypeBasicLinkedService = original.TypeOdbc
	TypeOffice365                TypeBasicLinkedService = original.TypeOffice365
	TypeOracle                   TypeBasicLinkedService = original.TypeOracle
	TypeOracleServiceCloud       TypeBasicLinkedService = original.TypeOracleServiceCloud
	TypePaypal                   TypeBasicLinkedService = original.TypePaypal
	TypePhoenix                  TypeBasicLinkedService = original.TypePhoenix
	TypePostgreSQL               TypeBasicLinkedService = original.TypePostgreSQL
	TypePresto                   TypeBasicLinkedService = original.TypePresto
	TypeQuickBooks               TypeBasicLinkedService = original.TypeQuickBooks
	TypeResponsys                TypeBasicLinkedService = original.TypeResponsys
	TypeRestService              TypeBasicLinkedService = original.TypeRestService
	TypeSalesforce               TypeBasicLinkedService = original.TypeSalesforce
	TypeSalesforceMarketingCloud TypeBasicLinkedService = original.TypeSalesforceMarketingCloud
	TypeSalesforceServiceCloud   TypeBasicLinkedService = original.TypeSalesforceServiceCloud
	TypeSapBW                    TypeBasicLinkedService = original.TypeSapBW
	TypeSapCloudForCustomer      TypeBasicLinkedService = original.TypeSapCloudForCustomer
	TypeSapEcc                   TypeBasicLinkedService = original.TypeSapEcc
	TypeSapHana                  TypeBasicLinkedService = original.TypeSapHana
	TypeSapOpenHub               TypeBasicLinkedService = original.TypeSapOpenHub
	TypeSapTable                 TypeBasicLinkedService = original.TypeSapTable
	TypeServiceNow               TypeBasicLinkedService = original.TypeServiceNow
	TypeSftp                     TypeBasicLinkedService = original.TypeSftp
	TypeShopify                  TypeBasicLinkedService = original.TypeShopify
	TypeSpark                    TypeBasicLinkedService = original.TypeSpark
	TypeSQLServer                TypeBasicLinkedService = original.TypeSQLServer
	TypeSquare                   TypeBasicLinkedService = original.TypeSquare
	TypeSybase                   TypeBasicLinkedService = original.TypeSybase
	TypeTeradata                 TypeBasicLinkedService = original.TypeTeradata
	TypeVertica                  TypeBasicLinkedService = original.TypeVertica
	TypeWeb                      TypeBasicLinkedService = original.TypeWeb
	TypeXero                     TypeBasicLinkedService = original.TypeXero
	TypeZoho                     TypeBasicLinkedService = original.TypeZoho
)

type TypeBasicSsisObjectMetadata = original.TypeBasicSsisObjectMetadata

const (
	TypeEnvironment        TypeBasicSsisObjectMetadata = original.TypeEnvironment
	TypeFolder             TypeBasicSsisObjectMetadata = original.TypeFolder
	TypePackage            TypeBasicSsisObjectMetadata = original.TypePackage
	TypeProject            TypeBasicSsisObjectMetadata = original.TypeProject
	TypeSsisObjectMetadata TypeBasicSsisObjectMetadata = original.TypeSsisObjectMetadata
)

type TypeBasicStoreWriteSettings = original.TypeBasicStoreWriteSettings

const (
	TypeAzureBlobFSWriteSettings        TypeBasicStoreWriteSettings = original.TypeAzureBlobFSWriteSettings
	TypeAzureBlobStorageWriteSettings   TypeBasicStoreWriteSettings = original.TypeAzureBlobStorageWriteSettings
	TypeAzureDataLakeStoreWriteSettings TypeBasicStoreWriteSettings = original.TypeAzureDataLakeStoreWriteSettings
	TypeFileServerWriteSettings         TypeBasicStoreWriteSettings = original.TypeFileServerWriteSettings
	TypeStoreWriteSettings              TypeBasicStoreWriteSettings = original.TypeStoreWriteSettings
)

type TypeBasicTrigger = original.TypeBasicTrigger

const (
	TypeBlobEventsTrigger          TypeBasicTrigger = original.TypeBlobEventsTrigger
	TypeBlobTrigger                TypeBasicTrigger = original.TypeBlobTrigger
	TypeChainingTrigger            TypeBasicTrigger = original.TypeChainingTrigger
	TypeMultiplePipelineTrigger    TypeBasicTrigger = original.TypeMultiplePipelineTrigger
	TypeRerunTumblingWindowTrigger TypeBasicTrigger = original.TypeRerunTumblingWindowTrigger
	TypeScheduleTrigger            TypeBasicTrigger = original.TypeScheduleTrigger
	TypeTrigger                    TypeBasicTrigger = original.TypeTrigger
	TypeTumblingWindowTrigger      TypeBasicTrigger = original.TypeTumblingWindowTrigger
)

type VariableType = original.VariableType

const (
	VariableTypeArray  VariableType = original.VariableTypeArray
	VariableTypeBool   VariableType = original.VariableTypeBool
	VariableTypeString VariableType = original.VariableTypeString
)

type WebActivityMethod = original.WebActivityMethod

const (
	WebActivityMethodDELETE WebActivityMethod = original.WebActivityMethodDELETE
	WebActivityMethodGET    WebActivityMethod = original.WebActivityMethodGET
	WebActivityMethodPOST   WebActivityMethod = original.WebActivityMethodPOST
	WebActivityMethodPUT    WebActivityMethod = original.WebActivityMethodPUT
)

type WebHookActivityMethod = original.WebHookActivityMethod

const (
	WebHookActivityMethodPOST WebHookActivityMethod = original.WebHookActivityMethodPOST
)

type AccessPolicyResponse = original.AccessPolicyResponse
type Activity = original.Activity
type ActivityDependency = original.ActivityDependency
type ActivityPolicy = original.ActivityPolicy
type ActivityRun = original.ActivityRun
type ActivityRunsClient = original.ActivityRunsClient
type ActivityRunsQueryResponse = original.ActivityRunsQueryResponse
type AddDataFlowToDebugSessionResponse = original.AddDataFlowToDebugSessionResponse
type AmazonMWSLinkedService = original.AmazonMWSLinkedService
type AmazonMWSLinkedServiceTypeProperties = original.AmazonMWSLinkedServiceTypeProperties
type AmazonMWSObjectDataset = original.AmazonMWSObjectDataset
type AmazonMWSSource = original.AmazonMWSSource
type AmazonRedshiftLinkedService = original.AmazonRedshiftLinkedService
type AmazonRedshiftLinkedServiceTypeProperties = original.AmazonRedshiftLinkedServiceTypeProperties
type AmazonRedshiftSource = original.AmazonRedshiftSource
type AmazonRedshiftTableDataset = original.AmazonRedshiftTableDataset
type AmazonRedshiftTableDatasetTypeProperties = original.AmazonRedshiftTableDatasetTypeProperties
type AmazonS3Dataset = original.AmazonS3Dataset
type AmazonS3DatasetTypeProperties = original.AmazonS3DatasetTypeProperties
type AmazonS3LinkedService = original.AmazonS3LinkedService
type AmazonS3LinkedServiceTypeProperties = original.AmazonS3LinkedServiceTypeProperties
type AmazonS3Location = original.AmazonS3Location
type AmazonS3ReadSettings = original.AmazonS3ReadSettings
type AppendVariableActivity = original.AppendVariableActivity
type AppendVariableActivityTypeProperties = original.AppendVariableActivityTypeProperties
type AvroDataset = original.AvroDataset
type AvroDatasetTypeProperties = original.AvroDatasetTypeProperties
type AvroFormat = original.AvroFormat
type AvroSink = original.AvroSink
type AvroSource = original.AvroSource
type AvroWriteSettings = original.AvroWriteSettings
type AzureBatchLinkedService = original.AzureBatchLinkedService
type AzureBatchLinkedServiceTypeProperties = original.AzureBatchLinkedServiceTypeProperties
type AzureBlobDataset = original.AzureBlobDataset
type AzureBlobDatasetTypeProperties = original.AzureBlobDatasetTypeProperties
type AzureBlobFSDataset = original.AzureBlobFSDataset
type AzureBlobFSDatasetTypeProperties = original.AzureBlobFSDatasetTypeProperties
type AzureBlobFSLinkedService = original.AzureBlobFSLinkedService
type AzureBlobFSLinkedServiceTypeProperties = original.AzureBlobFSLinkedServiceTypeProperties
type AzureBlobFSLocation = original.AzureBlobFSLocation
type AzureBlobFSReadSettings = original.AzureBlobFSReadSettings
type AzureBlobFSSink = original.AzureBlobFSSink
type AzureBlobFSSource = original.AzureBlobFSSource
type AzureBlobFSWriteSettings = original.AzureBlobFSWriteSettings
type AzureBlobStorageLinkedService = original.AzureBlobStorageLinkedService
type AzureBlobStorageLinkedServiceTypeProperties = original.AzureBlobStorageLinkedServiceTypeProperties
type AzureBlobStorageLocation = original.AzureBlobStorageLocation
type AzureBlobStorageReadSettings = original.AzureBlobStorageReadSettings
type AzureBlobStorageWriteSettings = original.AzureBlobStorageWriteSettings
type AzureDataExplorerCommandActivity = original.AzureDataExplorerCommandActivity
type AzureDataExplorerCommandActivityTypeProperties = original.AzureDataExplorerCommandActivityTypeProperties
type AzureDataExplorerDatasetTypeProperties = original.AzureDataExplorerDatasetTypeProperties
type AzureDataExplorerLinkedService = original.AzureDataExplorerLinkedService
type AzureDataExplorerLinkedServiceTypeProperties = original.AzureDataExplorerLinkedServiceTypeProperties
type AzureDataExplorerSink = original.AzureDataExplorerSink
type AzureDataExplorerSource = original.AzureDataExplorerSource
type AzureDataExplorerTableDataset = original.AzureDataExplorerTableDataset
type AzureDataLakeAnalyticsLinkedService = original.AzureDataLakeAnalyticsLinkedService
type AzureDataLakeAnalyticsLinkedServiceTypeProperties = original.AzureDataLakeAnalyticsLinkedServiceTypeProperties
type AzureDataLakeStoreDataset = original.AzureDataLakeStoreDataset
type AzureDataLakeStoreDatasetTypeProperties = original.AzureDataLakeStoreDatasetTypeProperties
type AzureDataLakeStoreLinkedService = original.AzureDataLakeStoreLinkedService
type AzureDataLakeStoreLinkedServiceTypeProperties = original.AzureDataLakeStoreLinkedServiceTypeProperties
type AzureDataLakeStoreLocation = original.AzureDataLakeStoreLocation
type AzureDataLakeStoreReadSettings = original.AzureDataLakeStoreReadSettings
type AzureDataLakeStoreSink = original.AzureDataLakeStoreSink
type AzureDataLakeStoreSource = original.AzureDataLakeStoreSource
type AzureDataLakeStoreWriteSettings = original.AzureDataLakeStoreWriteSettings
type AzureDatabricksLinkedService = original.AzureDatabricksLinkedService
type AzureDatabricksLinkedServiceTypeProperties = original.AzureDatabricksLinkedServiceTypeProperties
type AzureFileStorageLinkedService = original.AzureFileStorageLinkedService
type AzureFileStorageLinkedServiceTypeProperties = original.AzureFileStorageLinkedServiceTypeProperties
type AzureFileStorageLocation = original.AzureFileStorageLocation
type AzureFileStorageReadSettings = original.AzureFileStorageReadSettings
type AzureFunctionActivity = original.AzureFunctionActivity
type AzureFunctionActivityTypeProperties = original.AzureFunctionActivityTypeProperties
type AzureFunctionLinkedService = original.AzureFunctionLinkedService
type AzureFunctionLinkedServiceTypeProperties = original.AzureFunctionLinkedServiceTypeProperties
type AzureKeyVaultLinkedService = original.AzureKeyVaultLinkedService
type AzureKeyVaultLinkedServiceTypeProperties = original.AzureKeyVaultLinkedServiceTypeProperties
type AzureKeyVaultSecretReference = original.AzureKeyVaultSecretReference
type AzureMLBatchExecutionActivity = original.AzureMLBatchExecutionActivity
type AzureMLBatchExecutionActivityTypeProperties = original.AzureMLBatchExecutionActivityTypeProperties
type AzureMLExecutePipelineActivity = original.AzureMLExecutePipelineActivity
type AzureMLExecutePipelineActivityTypeProperties = original.AzureMLExecutePipelineActivityTypeProperties
type AzureMLLinkedService = original.AzureMLLinkedService
type AzureMLLinkedServiceTypeProperties = original.AzureMLLinkedServiceTypeProperties
type AzureMLServiceLinkedService = original.AzureMLServiceLinkedService
type AzureMLServiceLinkedServiceTypeProperties = original.AzureMLServiceLinkedServiceTypeProperties
type AzureMLUpdateResourceActivity = original.AzureMLUpdateResourceActivity
type AzureMLUpdateResourceActivityTypeProperties = original.AzureMLUpdateResourceActivityTypeProperties
type AzureMLWebServiceFile = original.AzureMLWebServiceFile
type AzureMariaDBLinkedService = original.AzureMariaDBLinkedService
type AzureMariaDBLinkedServiceTypeProperties = original.AzureMariaDBLinkedServiceTypeProperties
type AzureMariaDBSource = original.AzureMariaDBSource
type AzureMariaDBTableDataset = original.AzureMariaDBTableDataset
type AzureMySQLLinkedService = original.AzureMySQLLinkedService
type AzureMySQLLinkedServiceTypeProperties = original.AzureMySQLLinkedServiceTypeProperties
type AzureMySQLSink = original.AzureMySQLSink
type AzureMySQLSource = original.AzureMySQLSource
type AzureMySQLTableDataset = original.AzureMySQLTableDataset
type AzureMySQLTableDatasetTypeProperties = original.AzureMySQLTableDatasetTypeProperties
type AzurePostgreSQLLinkedService = original.AzurePostgreSQLLinkedService
type AzurePostgreSQLLinkedServiceTypeProperties = original.AzurePostgreSQLLinkedServiceTypeProperties
type AzurePostgreSQLSink = original.AzurePostgreSQLSink
type AzurePostgreSQLSource = original.AzurePostgreSQLSource
type AzurePostgreSQLTableDataset = original.AzurePostgreSQLTableDataset
type AzurePostgreSQLTableDatasetTypeProperties = original.AzurePostgreSQLTableDatasetTypeProperties
type AzureQueueSink = original.AzureQueueSink
type AzureSQLDWLinkedService = original.AzureSQLDWLinkedService
type AzureSQLDWLinkedServiceTypeProperties = original.AzureSQLDWLinkedServiceTypeProperties
type AzureSQLDWTableDataset = original.AzureSQLDWTableDataset
type AzureSQLDWTableDatasetTypeProperties = original.AzureSQLDWTableDatasetTypeProperties
type AzureSQLDatabaseLinkedService = original.AzureSQLDatabaseLinkedService
type AzureSQLDatabaseLinkedServiceTypeProperties = original.AzureSQLDatabaseLinkedServiceTypeProperties
type AzureSQLMILinkedService = original.AzureSQLMILinkedService
type AzureSQLMILinkedServiceTypeProperties = original.AzureSQLMILinkedServiceTypeProperties
type AzureSQLMITableDataset = original.AzureSQLMITableDataset
type AzureSQLMITableDatasetTypeProperties = original.AzureSQLMITableDatasetTypeProperties
type AzureSQLSink = original.AzureSQLSink
type AzureSQLSource = original.AzureSQLSource
type AzureSQLTableDataset = original.AzureSQLTableDataset
type AzureSQLTableDatasetTypeProperties = original.AzureSQLTableDatasetTypeProperties
type AzureSearchIndexDataset = original.AzureSearchIndexDataset
type AzureSearchIndexDatasetTypeProperties = original.AzureSearchIndexDatasetTypeProperties
type AzureSearchIndexSink = original.AzureSearchIndexSink
type AzureSearchLinkedService = original.AzureSearchLinkedService
type AzureSearchLinkedServiceTypeProperties = original.AzureSearchLinkedServiceTypeProperties
type AzureStorageLinkedService = original.AzureStorageLinkedService
type AzureStorageLinkedServiceTypeProperties = original.AzureStorageLinkedServiceTypeProperties
type AzureTableDataset = original.AzureTableDataset
type AzureTableDatasetTypeProperties = original.AzureTableDatasetTypeProperties
type AzureTableSink = original.AzureTableSink
type AzureTableSource = original.AzureTableSource
type AzureTableStorageLinkedService = original.AzureTableStorageLinkedService
type BaseClient = original.BaseClient
type BasicActivity = original.BasicActivity
type BasicControlActivity = original.BasicControlActivity
type BasicCopySink = original.BasicCopySink
type BasicCopySource = original.BasicCopySource
type BasicCustomSetupBase = original.BasicCustomSetupBase
type BasicDataFlow = original.BasicDataFlow
type BasicDataset = original.BasicDataset
type BasicDatasetCompression = original.BasicDatasetCompression
type BasicDatasetStorageFormat = original.BasicDatasetStorageFormat
type BasicDependencyReference = original.BasicDependencyReference
type BasicExecutionActivity = original.BasicExecutionActivity
type BasicFactoryRepoConfiguration = original.BasicFactoryRepoConfiguration
type BasicIntegrationRuntime = original.BasicIntegrationRuntime
type BasicIntegrationRuntimeStatus = original.BasicIntegrationRuntimeStatus
type BasicLinkedIntegrationRuntimeType = original.BasicLinkedIntegrationRuntimeType
type BasicLinkedService = original.BasicLinkedService
type BasicMultiplePipelineTrigger = original.BasicMultiplePipelineTrigger
type BasicSecretBase = original.BasicSecretBase
type BasicSsisObjectMetadata = original.BasicSsisObjectMetadata
type BasicStoreWriteSettings = original.BasicStoreWriteSettings
type BasicTabularSource = original.BasicTabularSource
type BasicTrigger = original.BasicTrigger
type BasicTriggerDependencyReference = original.BasicTriggerDependencyReference
type BasicWebLinkedServiceTypeProperties = original.BasicWebLinkedServiceTypeProperties
type BinaryDataset = original.BinaryDataset
type BinaryDatasetTypeProperties = original.BinaryDatasetTypeProperties
type BinarySink = original.BinarySink
type BinarySource = original.BinarySource
type BlobEventsTrigger = original.BlobEventsTrigger
type BlobEventsTriggerTypeProperties = original.BlobEventsTriggerTypeProperties
type BlobSink = original.BlobSink
type BlobSource = original.BlobSource
type BlobTrigger = original.BlobTrigger
type BlobTriggerTypeProperties = original.BlobTriggerTypeProperties
type CassandraLinkedService = original.CassandraLinkedService
type CassandraLinkedServiceTypeProperties = original.CassandraLinkedServiceTypeProperties
type CassandraSource = original.CassandraSource
type CassandraTableDataset = original.CassandraTableDataset
type CassandraTableDatasetTypeProperties = original.CassandraTableDatasetTypeProperties
type ChainingTrigger = original.ChainingTrigger
type ChainingTriggerTypeProperties = original.ChainingTriggerTypeProperties
type CloudError = original.CloudError
type CloudErrorBody = original.CloudErrorBody
type CmdkeySetup = original.CmdkeySetup
type CmdkeySetupTypeProperties = original.CmdkeySetupTypeProperties
type CommonDataServiceForAppsEntityDataset = original.CommonDataServiceForAppsEntityDataset
type CommonDataServiceForAppsEntityDatasetTypeProperties = original.CommonDataServiceForAppsEntityDatasetTypeProperties
type CommonDataServiceForAppsLinkedService = original.CommonDataServiceForAppsLinkedService
type CommonDataServiceForAppsLinkedServiceTypeProperties = original.CommonDataServiceForAppsLinkedServiceTypeProperties
type CommonDataServiceForAppsSink = original.CommonDataServiceForAppsSink
type CommonDataServiceForAppsSource = original.CommonDataServiceForAppsSource
type ComponentSetup = original.ComponentSetup
type ConcurLinkedService = original.ConcurLinkedService
type ConcurLinkedServiceTypeProperties = original.ConcurLinkedServiceTypeProperties
type ConcurObjectDataset = original.ConcurObjectDataset
type ConcurSource = original.ConcurSource
type ControlActivity = original.ControlActivity
type CopyActivity = original.CopyActivity
type CopyActivityTypeProperties = original.CopyActivityTypeProperties
type CopySink = original.CopySink
type CopySource = original.CopySource
type CosmosDbLinkedService = original.CosmosDbLinkedService
type CosmosDbLinkedServiceTypeProperties = original.CosmosDbLinkedServiceTypeProperties
type CosmosDbMongoDbAPICollectionDataset = original.CosmosDbMongoDbAPICollectionDataset
type CosmosDbMongoDbAPICollectionDatasetTypeProperties = original.CosmosDbMongoDbAPICollectionDatasetTypeProperties
type CosmosDbMongoDbAPILinkedService = original.CosmosDbMongoDbAPILinkedService
type CosmosDbMongoDbAPILinkedServiceTypeProperties = original.CosmosDbMongoDbAPILinkedServiceTypeProperties
type CosmosDbMongoDbAPISink = original.CosmosDbMongoDbAPISink
type CosmosDbMongoDbAPISource = original.CosmosDbMongoDbAPISource
type CosmosDbSQLAPICollectionDataset = original.CosmosDbSQLAPICollectionDataset
type CosmosDbSQLAPICollectionDatasetTypeProperties = original.CosmosDbSQLAPICollectionDatasetTypeProperties
type CosmosDbSQLAPISink = original.CosmosDbSQLAPISink
type CosmosDbSQLAPISource = original.CosmosDbSQLAPISource
type CouchbaseLinkedService = original.CouchbaseLinkedService
type CouchbaseLinkedServiceTypeProperties = original.CouchbaseLinkedServiceTypeProperties
type CouchbaseSource = original.CouchbaseSource
type CouchbaseTableDataset = original.CouchbaseTableDataset
type CreateDataFlowDebugSessionRequest = original.CreateDataFlowDebugSessionRequest
type CreateDataFlowDebugSessionResponse = original.CreateDataFlowDebugSessionResponse
type CreateLinkedIntegrationRuntimeRequest = original.CreateLinkedIntegrationRuntimeRequest
type CreateRunResponse = original.CreateRunResponse
type CustomActivity = original.CustomActivity
type CustomActivityReferenceObject = original.CustomActivityReferenceObject
type CustomActivityTypeProperties = original.CustomActivityTypeProperties
type CustomDataSourceLinkedService = original.CustomDataSourceLinkedService
type CustomDataset = original.CustomDataset
type CustomSetupBase = original.CustomSetupBase
type DWCopyCommandDefaultValue = original.DWCopyCommandDefaultValue
type DWCopyCommandSettings = original.DWCopyCommandSettings
type DataFlow = original.DataFlow
type DataFlowDebugCommandPayload = original.DataFlowDebugCommandPayload
type DataFlowDebugCommandRequest = original.DataFlowDebugCommandRequest
type DataFlowDebugCommandResponse = original.DataFlowDebugCommandResponse
type DataFlowDebugPackage = original.DataFlowDebugPackage
type DataFlowDebugPackageDebugSettings = original.DataFlowDebugPackageDebugSettings
type DataFlowDebugResource = original.DataFlowDebugResource
type DataFlowDebugSessionClient = original.DataFlowDebugSessionClient
type DataFlowDebugSessionCreateFuture = original.DataFlowDebugSessionCreateFuture
type DataFlowDebugSessionExecuteCommandFuture = original.DataFlowDebugSessionExecuteCommandFuture
type DataFlowDebugSessionInfo = original.DataFlowDebugSessionInfo
type DataFlowFolder = original.DataFlowFolder
type DataFlowListResponse = original.DataFlowListResponse
type DataFlowListResponseIterator = original.DataFlowListResponseIterator
type DataFlowListResponsePage = original.DataFlowListResponsePage
type DataFlowReference = original.DataFlowReference
type DataFlowResource = original.DataFlowResource
type DataFlowSink = original.DataFlowSink
type DataFlowSource = original.DataFlowSource
type DataFlowSourceSetting = original.DataFlowSourceSetting
type DataFlowStagingInfo = original.DataFlowStagingInfo
type DataFlowsClient = original.DataFlowsClient
type DataLakeAnalyticsUSQLActivity = original.DataLakeAnalyticsUSQLActivity
type DataLakeAnalyticsUSQLActivityTypeProperties = original.DataLakeAnalyticsUSQLActivityTypeProperties
type DatabricksNotebookActivity = original.DatabricksNotebookActivity
type DatabricksNotebookActivityTypeProperties = original.DatabricksNotebookActivityTypeProperties
type DatabricksSparkJarActivity = original.DatabricksSparkJarActivity
type DatabricksSparkJarActivityTypeProperties = original.DatabricksSparkJarActivityTypeProperties
type DatabricksSparkPythonActivity = original.DatabricksSparkPythonActivity
type DatabricksSparkPythonActivityTypeProperties = original.DatabricksSparkPythonActivityTypeProperties
type Dataset = original.Dataset
type DatasetBZip2Compression = original.DatasetBZip2Compression
type DatasetCompression = original.DatasetCompression
type DatasetDebugResource = original.DatasetDebugResource
type DatasetDeflateCompression = original.DatasetDeflateCompression
type DatasetFolder = original.DatasetFolder
type DatasetGZipCompression = original.DatasetGZipCompression
type DatasetListResponse = original.DatasetListResponse
type DatasetListResponseIterator = original.DatasetListResponseIterator
type DatasetListResponsePage = original.DatasetListResponsePage
type DatasetLocation = original.DatasetLocation
type DatasetReference = original.DatasetReference
type DatasetResource = original.DatasetResource
type DatasetStorageFormat = original.DatasetStorageFormat
type DatasetZipDeflateCompression = original.DatasetZipDeflateCompression
type DatasetsClient = original.DatasetsClient
type Db2LinkedService = original.Db2LinkedService
type Db2LinkedServiceTypeProperties = original.Db2LinkedServiceTypeProperties
type Db2Source = original.Db2Source
type Db2TableDataset = original.Db2TableDataset
type Db2TableDatasetTypeProperties = original.Db2TableDatasetTypeProperties
type DeleteActivity = original.DeleteActivity
type DeleteActivityTypeProperties = original.DeleteActivityTypeProperties
type DeleteDataFlowDebugSessionRequest = original.DeleteDataFlowDebugSessionRequest
type DelimitedTextDataset = original.DelimitedTextDataset
type DelimitedTextDatasetTypeProperties = original.DelimitedTextDatasetTypeProperties
type DelimitedTextReadSettings = original.DelimitedTextReadSettings
type DelimitedTextSink = original.DelimitedTextSink
type DelimitedTextSource = original.DelimitedTextSource
type DelimitedTextWriteSettings = original.DelimitedTextWriteSettings
type DependencyReference = original.DependencyReference
type DistcpSettings = original.DistcpSettings
type DocumentDbCollectionDataset = original.DocumentDbCollectionDataset
type DocumentDbCollectionDatasetTypeProperties = original.DocumentDbCollectionDatasetTypeProperties
type DocumentDbCollectionSink = original.DocumentDbCollectionSink
type DocumentDbCollectionSource = original.DocumentDbCollectionSource
type DrillDatasetTypeProperties = original.DrillDatasetTypeProperties
type DrillLinkedService = original.DrillLinkedService
type DrillLinkedServiceTypeProperties = original.DrillLinkedServiceTypeProperties
type DrillSource = original.DrillSource
type DrillTableDataset = original.DrillTableDataset
type DynamicsAXLinkedService = original.DynamicsAXLinkedService
type DynamicsAXLinkedServiceTypeProperties = original.DynamicsAXLinkedServiceTypeProperties
type DynamicsAXResourceDataset = original.DynamicsAXResourceDataset
type DynamicsAXResourceDatasetTypeProperties = original.DynamicsAXResourceDatasetTypeProperties
type DynamicsAXSource = original.DynamicsAXSource
type DynamicsCrmEntityDataset = original.DynamicsCrmEntityDataset
type DynamicsCrmEntityDatasetTypeProperties = original.DynamicsCrmEntityDatasetTypeProperties
type DynamicsCrmLinkedService = original.DynamicsCrmLinkedService
type DynamicsCrmLinkedServiceTypeProperties = original.DynamicsCrmLinkedServiceTypeProperties
type DynamicsCrmSink = original.DynamicsCrmSink
type DynamicsCrmSource = original.DynamicsCrmSource
type DynamicsEntityDataset = original.DynamicsEntityDataset
type DynamicsEntityDatasetTypeProperties = original.DynamicsEntityDatasetTypeProperties
type DynamicsLinkedService = original.DynamicsLinkedService
type DynamicsLinkedServiceTypeProperties = original.DynamicsLinkedServiceTypeProperties
type DynamicsSink = original.DynamicsSink
type DynamicsSource = original.DynamicsSource
type EloquaLinkedService = original.EloquaLinkedService
type EloquaLinkedServiceTypeProperties = original.EloquaLinkedServiceTypeProperties
type EloquaObjectDataset = original.EloquaObjectDataset
type EloquaSource = original.EloquaSource
type EntityReference = original.EntityReference
type EnvironmentVariableSetup = original.EnvironmentVariableSetup
type EnvironmentVariableSetupTypeProperties = original.EnvironmentVariableSetupTypeProperties
type ExecuteDataFlowActivity = original.ExecuteDataFlowActivity
type ExecuteDataFlowActivityTypeProperties = original.ExecuteDataFlowActivityTypeProperties
type ExecutePipelineActivity = original.ExecutePipelineActivity
type ExecutePipelineActivityTypeProperties = original.ExecutePipelineActivityTypeProperties
type ExecuteSSISPackageActivity = original.ExecuteSSISPackageActivity
type ExecuteSSISPackageActivityTypeProperties = original.ExecuteSSISPackageActivityTypeProperties
type ExecutionActivity = original.ExecutionActivity
type ExposureControlClient = original.ExposureControlClient
type ExposureControlRequest = original.ExposureControlRequest
type ExposureControlResponse = original.ExposureControlResponse
type Expression = original.Expression
type FactoriesClient = original.FactoriesClient
type Factory = original.Factory
type FactoryGitHubConfiguration = original.FactoryGitHubConfiguration
type FactoryIdentity = original.FactoryIdentity
type FactoryListResponse = original.FactoryListResponse
type FactoryListResponseIterator = original.FactoryListResponseIterator
type FactoryListResponsePage = original.FactoryListResponsePage
type FactoryProperties = original.FactoryProperties
type FactoryRepoConfiguration = original.FactoryRepoConfiguration
type FactoryRepoUpdate = original.FactoryRepoUpdate
type FactoryUpdateParameters = original.FactoryUpdateParameters
type FactoryVSTSConfiguration = original.FactoryVSTSConfiguration
type FileServerLinkedService = original.FileServerLinkedService
type FileServerLinkedServiceTypeProperties = original.FileServerLinkedServiceTypeProperties
type FileServerLocation = original.FileServerLocation
type FileServerReadSettings = original.FileServerReadSettings
type FileServerWriteSettings = original.FileServerWriteSettings
type FileShareDataset = original.FileShareDataset
type FileShareDatasetTypeProperties = original.FileShareDatasetTypeProperties
type FileSystemSink = original.FileSystemSink
type FileSystemSource = original.FileSystemSource
type FilterActivity = original.FilterActivity
type FilterActivityTypeProperties = original.FilterActivityTypeProperties
type ForEachActivity = original.ForEachActivity
type ForEachActivityTypeProperties = original.ForEachActivityTypeProperties
type FormatReadSettings = original.FormatReadSettings
type FormatWriteSettings = original.FormatWriteSettings
type FtpReadSettings = original.FtpReadSettings
type FtpServerLinkedService = original.FtpServerLinkedService
type FtpServerLinkedServiceTypeProperties = original.FtpServerLinkedServiceTypeProperties
type FtpServerLocation = original.FtpServerLocation
type GenericDatasetTypeProperties = original.GenericDatasetTypeProperties
type GetDataFactoryOperationStatusResponse = original.GetDataFactoryOperationStatusResponse
type GetMetadataActivity = original.GetMetadataActivity
type GetMetadataActivityTypeProperties = original.GetMetadataActivityTypeProperties
type GetSsisObjectMetadataRequest = original.GetSsisObjectMetadataRequest
type GitHubAccessTokenRequest = original.GitHubAccessTokenRequest
type GitHubAccessTokenResponse = original.GitHubAccessTokenResponse
type GoogleAdWordsLinkedService = original.GoogleAdWordsLinkedService
type GoogleAdWordsLinkedServiceTypeProperties = original.GoogleAdWordsLinkedServiceTypeProperties
type GoogleAdWordsObjectDataset = original.GoogleAdWordsObjectDataset
type GoogleAdWordsSource = original.GoogleAdWordsSource
type GoogleBigQueryDatasetTypeProperties = original.GoogleBigQueryDatasetTypeProperties
type GoogleBigQueryLinkedService = original.GoogleBigQueryLinkedService
type GoogleBigQueryLinkedServiceTypeProperties = original.GoogleBigQueryLinkedServiceTypeProperties
type GoogleBigQueryObjectDataset = original.GoogleBigQueryObjectDataset
type GoogleBigQuerySource = original.GoogleBigQuerySource
type GoogleCloudStorageLinkedService = original.GoogleCloudStorageLinkedService
type GoogleCloudStorageLinkedServiceTypeProperties = original.GoogleCloudStorageLinkedServiceTypeProperties
type GoogleCloudStorageLocation = original.GoogleCloudStorageLocation
type GoogleCloudStorageReadSettings = original.GoogleCloudStorageReadSettings
type GreenplumDatasetTypeProperties = original.GreenplumDatasetTypeProperties
type GreenplumLinkedService = original.GreenplumLinkedService
type GreenplumLinkedServiceTypeProperties = original.GreenplumLinkedServiceTypeProperties
type GreenplumSource = original.GreenplumSource
type GreenplumTableDataset = original.GreenplumTableDataset
type HBaseLinkedService = original.HBaseLinkedService
type HBaseLinkedServiceTypeProperties = original.HBaseLinkedServiceTypeProperties
type HBaseObjectDataset = original.HBaseObjectDataset
type HBaseSource = original.HBaseSource
type HDInsightHiveActivity = original.HDInsightHiveActivity
type HDInsightHiveActivityTypeProperties = original.HDInsightHiveActivityTypeProperties
type HDInsightLinkedService = original.HDInsightLinkedService
type HDInsightLinkedServiceTypeProperties = original.HDInsightLinkedServiceTypeProperties
type HDInsightMapReduceActivity = original.HDInsightMapReduceActivity
type HDInsightMapReduceActivityTypeProperties = original.HDInsightMapReduceActivityTypeProperties
type HDInsightOnDemandLinkedService = original.HDInsightOnDemandLinkedService
type HDInsightOnDemandLinkedServiceTypeProperties = original.HDInsightOnDemandLinkedServiceTypeProperties
type HDInsightPigActivity = original.HDInsightPigActivity
type HDInsightPigActivityTypeProperties = original.HDInsightPigActivityTypeProperties
type HDInsightSparkActivity = original.HDInsightSparkActivity
type HDInsightSparkActivityTypeProperties = original.HDInsightSparkActivityTypeProperties
type HDInsightStreamingActivity = original.HDInsightStreamingActivity
type HDInsightStreamingActivityTypeProperties = original.HDInsightStreamingActivityTypeProperties
type HTTPDataset = original.HTTPDataset
type HTTPDatasetTypeProperties = original.HTTPDatasetTypeProperties
type HTTPLinkedService = original.HTTPLinkedService
type HTTPLinkedServiceTypeProperties = original.HTTPLinkedServiceTypeProperties
type HTTPReadSettings = original.HTTPReadSettings
type HTTPServerLocation = original.HTTPServerLocation
type HTTPSource = original.HTTPSource
type HdfsLinkedService = original.HdfsLinkedService
type HdfsLinkedServiceTypeProperties = original.HdfsLinkedServiceTypeProperties
type HdfsLocation = original.HdfsLocation
type HdfsReadSettings = original.HdfsReadSettings
type HdfsSource = original.HdfsSource
type HiveDatasetTypeProperties = original.HiveDatasetTypeProperties
type HiveLinkedService = original.HiveLinkedService
type HiveLinkedServiceTypeProperties = original.HiveLinkedServiceTypeProperties
type HiveObjectDataset = original.HiveObjectDataset
type HiveSource = original.HiveSource
type HubspotLinkedService = original.HubspotLinkedService
type HubspotLinkedServiceTypeProperties = original.HubspotLinkedServiceTypeProperties
type HubspotObjectDataset = original.HubspotObjectDataset
type HubspotSource = original.HubspotSource
type IfConditionActivity = original.IfConditionActivity
type IfConditionActivityTypeProperties = original.IfConditionActivityTypeProperties
type ImpalaDatasetTypeProperties = original.ImpalaDatasetTypeProperties
type ImpalaLinkedService = original.ImpalaLinkedService
type ImpalaLinkedServiceTypeProperties = original.ImpalaLinkedServiceTypeProperties
type ImpalaObjectDataset = original.ImpalaObjectDataset
type ImpalaSource = original.ImpalaSource
type InformixLinkedService = original.InformixLinkedService
type InformixLinkedServiceTypeProperties = original.InformixLinkedServiceTypeProperties
type InformixSink = original.InformixSink
type InformixSource = original.InformixSource
type InformixTableDataset = original.InformixTableDataset
type InformixTableDatasetTypeProperties = original.InformixTableDatasetTypeProperties
type IntegrationRuntime = original.IntegrationRuntime
type IntegrationRuntimeAuthKeys = original.IntegrationRuntimeAuthKeys
type IntegrationRuntimeComputeProperties = original.IntegrationRuntimeComputeProperties
type IntegrationRuntimeConnectionInfo = original.IntegrationRuntimeConnectionInfo
type IntegrationRuntimeCustomSetupScriptProperties = original.IntegrationRuntimeCustomSetupScriptProperties
type IntegrationRuntimeDataFlowProperties = original.IntegrationRuntimeDataFlowProperties
type IntegrationRuntimeDataProxyProperties = original.IntegrationRuntimeDataProxyProperties
type IntegrationRuntimeDebugResource = original.IntegrationRuntimeDebugResource
type IntegrationRuntimeListResponse = original.IntegrationRuntimeListResponse
type IntegrationRuntimeListResponseIterator = original.IntegrationRuntimeListResponseIterator
type IntegrationRuntimeListResponsePage = original.IntegrationRuntimeListResponsePage
type IntegrationRuntimeMonitoringData = original.IntegrationRuntimeMonitoringData
type IntegrationRuntimeNodeIPAddress = original.IntegrationRuntimeNodeIPAddress
type IntegrationRuntimeNodeMonitoringData = original.IntegrationRuntimeNodeMonitoringData
type IntegrationRuntimeNodesClient = original.IntegrationRuntimeNodesClient
type IntegrationRuntimeObjectMetadataClient = original.IntegrationRuntimeObjectMetadataClient
type IntegrationRuntimeObjectMetadataRefreshFuture = original.IntegrationRuntimeObjectMetadataRefreshFuture
type IntegrationRuntimeReference = original.IntegrationRuntimeReference
type IntegrationRuntimeRegenerateKeyParameters = original.IntegrationRuntimeRegenerateKeyParameters
type IntegrationRuntimeResource = original.IntegrationRuntimeResource
type IntegrationRuntimeSsisCatalogInfo = original.IntegrationRuntimeSsisCatalogInfo
type IntegrationRuntimeSsisProperties = original.IntegrationRuntimeSsisProperties
type IntegrationRuntimeStatus = original.IntegrationRuntimeStatus
type IntegrationRuntimeStatusListResponse = original.IntegrationRuntimeStatusListResponse
type IntegrationRuntimeStatusResponse = original.IntegrationRuntimeStatusResponse
type IntegrationRuntimeVNetProperties = original.IntegrationRuntimeVNetProperties
type IntegrationRuntimesClient = original.IntegrationRuntimesClient
type IntegrationRuntimesStartFuture = original.IntegrationRuntimesStartFuture
type IntegrationRuntimesStopFuture = original.IntegrationRuntimesStopFuture
type JSONDataset = original.JSONDataset
type JSONDatasetTypeProperties = original.JSONDatasetTypeProperties
type JSONFormat = original.JSONFormat
type JSONSink = original.JSONSink
type JSONSource = original.JSONSource
type JSONWriteSettings = original.JSONWriteSettings
type JiraLinkedService = original.JiraLinkedService
type JiraLinkedServiceTypeProperties = original.JiraLinkedServiceTypeProperties
type JiraObjectDataset = original.JiraObjectDataset
type JiraSource = original.JiraSource
type LicensedComponentSetupTypeProperties = original.LicensedComponentSetupTypeProperties
type LinkedIntegrationRuntime = original.LinkedIntegrationRuntime
type LinkedIntegrationRuntimeKeyAuthorization = original.LinkedIntegrationRuntimeKeyAuthorization
type LinkedIntegrationRuntimeRbacAuthorization = original.LinkedIntegrationRuntimeRbacAuthorization
type LinkedIntegrationRuntimeRequest = original.LinkedIntegrationRuntimeRequest
type LinkedIntegrationRuntimeType = original.LinkedIntegrationRuntimeType
type LinkedService = original.LinkedService
type LinkedServiceDebugResource = original.LinkedServiceDebugResource
type LinkedServiceListResponse = original.LinkedServiceListResponse
type LinkedServiceListResponseIterator = original.LinkedServiceListResponseIterator
type LinkedServiceListResponsePage = original.LinkedServiceListResponsePage
type LinkedServiceReference = original.LinkedServiceReference
type LinkedServiceResource = original.LinkedServiceResource
type LinkedServicesClient = original.LinkedServicesClient
type LogStorageSettings = original.LogStorageSettings
type LookupActivity = original.LookupActivity
type LookupActivityTypeProperties = original.LookupActivityTypeProperties
type MagentoLinkedService = original.MagentoLinkedService
type MagentoLinkedServiceTypeProperties = original.MagentoLinkedServiceTypeProperties
type MagentoObjectDataset = original.MagentoObjectDataset
type MagentoSource = original.MagentoSource
type ManagedIntegrationRuntime = original.ManagedIntegrationRuntime
type ManagedIntegrationRuntimeError = original.ManagedIntegrationRuntimeError
type ManagedIntegrationRuntimeNode = original.ManagedIntegrationRuntimeNode
type ManagedIntegrationRuntimeOperationResult = original.ManagedIntegrationRuntimeOperationResult
type ManagedIntegrationRuntimeStatus = original.ManagedIntegrationRuntimeStatus
type ManagedIntegrationRuntimeStatusTypeProperties = original.ManagedIntegrationRuntimeStatusTypeProperties
type ManagedIntegrationRuntimeTypeProperties = original.ManagedIntegrationRuntimeTypeProperties
type MappingDataFlow = original.MappingDataFlow
type MappingDataFlowTypeProperties = original.MappingDataFlowTypeProperties
type MariaDBLinkedService = original.MariaDBLinkedService
type MariaDBLinkedServiceTypeProperties = original.MariaDBLinkedServiceTypeProperties
type MariaDBSource = original.MariaDBSource
type MariaDBTableDataset = original.MariaDBTableDataset
type MarketoLinkedService = original.MarketoLinkedService
type MarketoLinkedServiceTypeProperties = original.MarketoLinkedServiceTypeProperties
type MarketoObjectDataset = original.MarketoObjectDataset
type MarketoSource = original.MarketoSource
type MicrosoftAccessLinkedService = original.MicrosoftAccessLinkedService
type MicrosoftAccessLinkedServiceTypeProperties = original.MicrosoftAccessLinkedServiceTypeProperties
type MicrosoftAccessSink = original.MicrosoftAccessSink
type MicrosoftAccessSource = original.MicrosoftAccessSource
type MicrosoftAccessTableDataset = original.MicrosoftAccessTableDataset
type MicrosoftAccessTableDatasetTypeProperties = original.MicrosoftAccessTableDatasetTypeProperties
type MongoDbCollectionDataset = original.MongoDbCollectionDataset
type MongoDbCollectionDatasetTypeProperties = original.MongoDbCollectionDatasetTypeProperties
type MongoDbCursorMethodsProperties = original.MongoDbCursorMethodsProperties
type MongoDbLinkedService = original.MongoDbLinkedService
type MongoDbLinkedServiceTypeProperties = original.MongoDbLinkedServiceTypeProperties
type MongoDbSource = original.MongoDbSource
type MongoDbV2CollectionDataset = original.MongoDbV2CollectionDataset
type MongoDbV2CollectionDatasetTypeProperties = original.MongoDbV2CollectionDatasetTypeProperties
type MongoDbV2LinkedService = original.MongoDbV2LinkedService
type MongoDbV2LinkedServiceTypeProperties = original.MongoDbV2LinkedServiceTypeProperties
type MongoDbV2Source = original.MongoDbV2Source
type MultiplePipelineTrigger = original.MultiplePipelineTrigger
type MySQLLinkedService = original.MySQLLinkedService
type MySQLLinkedServiceTypeProperties = original.MySQLLinkedServiceTypeProperties
type MySQLSource = original.MySQLSource
type MySQLTableDataset = original.MySQLTableDataset
type MySQLTableDatasetTypeProperties = original.MySQLTableDatasetTypeProperties
type NetezzaLinkedService = original.NetezzaLinkedService
type NetezzaLinkedServiceTypeProperties = original.NetezzaLinkedServiceTypeProperties
type NetezzaPartitionSettings = original.NetezzaPartitionSettings
type NetezzaSource = original.NetezzaSource
type NetezzaTableDataset = original.NetezzaTableDataset
type NetezzaTableDatasetTypeProperties = original.NetezzaTableDatasetTypeProperties
type ODataLinkedService = original.ODataLinkedService
type ODataLinkedServiceTypeProperties = original.ODataLinkedServiceTypeProperties
type ODataResourceDataset = original.ODataResourceDataset
type ODataResourceDatasetTypeProperties = original.ODataResourceDatasetTypeProperties
type ODataSource = original.ODataSource
type OdbcLinkedService = original.OdbcLinkedService
type OdbcLinkedServiceTypeProperties = original.OdbcLinkedServiceTypeProperties
type OdbcSink = original.OdbcSink
type OdbcSource = original.OdbcSource
type OdbcTableDataset = original.OdbcTableDataset
type OdbcTableDatasetTypeProperties = original.OdbcTableDatasetTypeProperties
type Office365Dataset = original.Office365Dataset
type Office365DatasetTypeProperties = original.Office365DatasetTypeProperties
type Office365LinkedService = original.Office365LinkedService
type Office365LinkedServiceTypeProperties = original.Office365LinkedServiceTypeProperties
type Office365Source = original.Office365Source
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResponse = original.OperationListResponse
type OperationListResponseIterator = original.OperationListResponseIterator
type OperationListResponsePage = original.OperationListResponsePage
type OperationLogSpecification = original.OperationLogSpecification
type OperationMetricAvailability = original.OperationMetricAvailability
type OperationMetricDimension = original.OperationMetricDimension
type OperationMetricSpecification = original.OperationMetricSpecification
type OperationProperties = original.OperationProperties
type OperationServiceSpecification = original.OperationServiceSpecification
type OperationsClient = original.OperationsClient
type OracleLinkedService = original.OracleLinkedService
type OracleLinkedServiceTypeProperties = original.OracleLinkedServiceTypeProperties
type OraclePartitionSettings = original.OraclePartitionSettings
type OracleServiceCloudLinkedService = original.OracleServiceCloudLinkedService
type OracleServiceCloudLinkedServiceTypeProperties = original.OracleServiceCloudLinkedServiceTypeProperties
type OracleServiceCloudObjectDataset = original.OracleServiceCloudObjectDataset
type OracleServiceCloudSource = original.OracleServiceCloudSource
type OracleSink = original.OracleSink
type OracleSource = original.OracleSource
type OracleTableDataset = original.OracleTableDataset
type OracleTableDatasetTypeProperties = original.OracleTableDatasetTypeProperties
type OrcDataset = original.OrcDataset
type OrcDatasetTypeProperties = original.OrcDatasetTypeProperties
type OrcFormat = original.OrcFormat
type OrcSink = original.OrcSink
type OrcSource = original.OrcSource
type ParameterSpecification = original.ParameterSpecification
type ParquetDataset = original.ParquetDataset
type ParquetDatasetTypeProperties = original.ParquetDatasetTypeProperties
type ParquetFormat = original.ParquetFormat
type ParquetSink = original.ParquetSink
type ParquetSource = original.ParquetSource
type PaypalLinkedService = original.PaypalLinkedService
type PaypalLinkedServiceTypeProperties = original.PaypalLinkedServiceTypeProperties
type PaypalObjectDataset = original.PaypalObjectDataset
type PaypalSource = original.PaypalSource
type PhoenixDatasetTypeProperties = original.PhoenixDatasetTypeProperties
type PhoenixLinkedService = original.PhoenixLinkedService
type PhoenixLinkedServiceTypeProperties = original.PhoenixLinkedServiceTypeProperties
type PhoenixObjectDataset = original.PhoenixObjectDataset
type PhoenixSource = original.PhoenixSource
type Pipeline = original.Pipeline
type PipelineFolder = original.PipelineFolder
type PipelineListResponse = original.PipelineListResponse
type PipelineListResponseIterator = original.PipelineListResponseIterator
type PipelineListResponsePage = original.PipelineListResponsePage
type PipelineReference = original.PipelineReference
type PipelineResource = original.PipelineResource
type PipelineRun = original.PipelineRun
type PipelineRunInvokedBy = original.PipelineRunInvokedBy
type PipelineRunsClient = original.PipelineRunsClient
type PipelineRunsQueryResponse = original.PipelineRunsQueryResponse
type PipelinesClient = original.PipelinesClient
type PolybaseSettings = original.PolybaseSettings
type PostgreSQLLinkedService = original.PostgreSQLLinkedService
type PostgreSQLLinkedServiceTypeProperties = original.PostgreSQLLinkedServiceTypeProperties
type PostgreSQLSource = original.PostgreSQLSource
type PostgreSQLTableDataset = original.PostgreSQLTableDataset
type PostgreSQLTableDatasetTypeProperties = original.PostgreSQLTableDatasetTypeProperties
type PrestoDatasetTypeProperties = original.PrestoDatasetTypeProperties
type PrestoLinkedService = original.PrestoLinkedService
type PrestoLinkedServiceTypeProperties = original.PrestoLinkedServiceTypeProperties
type PrestoObjectDataset = original.PrestoObjectDataset
type PrestoSource = original.PrestoSource
type QueryDataFlowDebugSessionsResponse = original.QueryDataFlowDebugSessionsResponse
type QueryDataFlowDebugSessionsResponseIterator = original.QueryDataFlowDebugSessionsResponseIterator
type QueryDataFlowDebugSessionsResponsePage = original.QueryDataFlowDebugSessionsResponsePage
type QuickBooksLinkedService = original.QuickBooksLinkedService
type QuickBooksLinkedServiceTypeProperties = original.QuickBooksLinkedServiceTypeProperties
type QuickBooksObjectDataset = original.QuickBooksObjectDataset
type QuickBooksSource = original.QuickBooksSource
type RecurrenceSchedule = original.RecurrenceSchedule
type RecurrenceScheduleOccurrence = original.RecurrenceScheduleOccurrence
type RedirectIncompatibleRowSettings = original.RedirectIncompatibleRowSettings
type RedshiftUnloadSettings = original.RedshiftUnloadSettings
type RelationalSource = original.RelationalSource
type RelationalTableDataset = original.RelationalTableDataset
type RelationalTableDatasetTypeProperties = original.RelationalTableDatasetTypeProperties
type RerunTriggerListResponse = original.RerunTriggerListResponse
type RerunTriggerListResponseIterator = original.RerunTriggerListResponseIterator
type RerunTriggerListResponsePage = original.RerunTriggerListResponsePage
type RerunTriggerResource = original.RerunTriggerResource
type RerunTriggersCancelFuture = original.RerunTriggersCancelFuture
type RerunTriggersClient = original.RerunTriggersClient
type RerunTriggersStartFuture = original.RerunTriggersStartFuture
type RerunTriggersStopFuture = original.RerunTriggersStopFuture
type RerunTumblingWindowTrigger = original.RerunTumblingWindowTrigger
type RerunTumblingWindowTriggerActionParameters = original.RerunTumblingWindowTriggerActionParameters
type RerunTumblingWindowTriggerTypeProperties = original.RerunTumblingWindowTriggerTypeProperties
type Resource = original.Resource
type ResponsysLinkedService = original.ResponsysLinkedService
type ResponsysLinkedServiceTypeProperties = original.ResponsysLinkedServiceTypeProperties
type ResponsysObjectDataset = original.ResponsysObjectDataset
type ResponsysSource = original.ResponsysSource
type RestResourceDataset = original.RestResourceDataset
type RestResourceDatasetTypeProperties = original.RestResourceDatasetTypeProperties
type RestServiceLinkedService = original.RestServiceLinkedService
type RestServiceLinkedServiceTypeProperties = original.RestServiceLinkedServiceTypeProperties
type RestSource = original.RestSource
type RetryPolicy = original.RetryPolicy
type RunFilterParameters = original.RunFilterParameters
type RunQueryFilter = original.RunQueryFilter
type RunQueryOrderBy = original.RunQueryOrderBy
type SQLDWSink = original.SQLDWSink
type SQLDWSource = original.SQLDWSource
type SQLMISink = original.SQLMISink
type SQLMISource = original.SQLMISource
type SQLServerLinkedService = original.SQLServerLinkedService
type SQLServerLinkedServiceTypeProperties = original.SQLServerLinkedServiceTypeProperties
type SQLServerSink = original.SQLServerSink
type SQLServerSource = original.SQLServerSource
type SQLServerStoredProcedureActivity = original.SQLServerStoredProcedureActivity
type SQLServerStoredProcedureActivityTypeProperties = original.SQLServerStoredProcedureActivityTypeProperties
type SQLServerTableDataset = original.SQLServerTableDataset
type SQLServerTableDatasetTypeProperties = original.SQLServerTableDatasetTypeProperties
type SQLSink = original.SQLSink
type SQLSource = original.SQLSource
type SSISAccessCredential = original.SSISAccessCredential
type SSISChildPackage = original.SSISChildPackage
type SSISExecutionCredential = original.SSISExecutionCredential
type SSISExecutionParameter = original.SSISExecutionParameter
type SSISLogLocation = original.SSISLogLocation
type SSISLogLocationTypeProperties = original.SSISLogLocationTypeProperties
type SSISPackageLocation = original.SSISPackageLocation
type SSISPackageLocationTypeProperties = original.SSISPackageLocationTypeProperties
type SSISPropertyOverride = original.SSISPropertyOverride
type SalesforceLinkedService = original.SalesforceLinkedService
type SalesforceLinkedServiceTypeProperties = original.SalesforceLinkedServiceTypeProperties
type SalesforceMarketingCloudLinkedService = original.SalesforceMarketingCloudLinkedService
type SalesforceMarketingCloudLinkedServiceTypeProperties = original.SalesforceMarketingCloudLinkedServiceTypeProperties
type SalesforceMarketingCloudObjectDataset = original.SalesforceMarketingCloudObjectDataset
type SalesforceMarketingCloudSource = original.SalesforceMarketingCloudSource
type SalesforceObjectDataset = original.SalesforceObjectDataset
type SalesforceObjectDatasetTypeProperties = original.SalesforceObjectDatasetTypeProperties
type SalesforceServiceCloudLinkedService = original.SalesforceServiceCloudLinkedService
type SalesforceServiceCloudLinkedServiceTypeProperties = original.SalesforceServiceCloudLinkedServiceTypeProperties
type SalesforceServiceCloudObjectDataset = original.SalesforceServiceCloudObjectDataset
type SalesforceServiceCloudObjectDatasetTypeProperties = original.SalesforceServiceCloudObjectDatasetTypeProperties
type SalesforceServiceCloudSink = original.SalesforceServiceCloudSink
type SalesforceServiceCloudSource = original.SalesforceServiceCloudSource
type SalesforceSink = original.SalesforceSink
type SalesforceSource = original.SalesforceSource
type SapBWLinkedService = original.SapBWLinkedService
type SapBWLinkedServiceTypeProperties = original.SapBWLinkedServiceTypeProperties
type SapBwCubeDataset = original.SapBwCubeDataset
type SapBwSource = original.SapBwSource
type SapCloudForCustomerLinkedService = original.SapCloudForCustomerLinkedService
type SapCloudForCustomerLinkedServiceTypeProperties = original.SapCloudForCustomerLinkedServiceTypeProperties
type SapCloudForCustomerResourceDataset = original.SapCloudForCustomerResourceDataset
type SapCloudForCustomerResourceDatasetTypeProperties = original.SapCloudForCustomerResourceDatasetTypeProperties
type SapCloudForCustomerSink = original.SapCloudForCustomerSink
type SapCloudForCustomerSource = original.SapCloudForCustomerSource
type SapEccLinkedService = original.SapEccLinkedService
type SapEccLinkedServiceTypeProperties = original.SapEccLinkedServiceTypeProperties
type SapEccResourceDataset = original.SapEccResourceDataset
type SapEccResourceDatasetTypeProperties = original.SapEccResourceDatasetTypeProperties
type SapEccSource = original.SapEccSource
type SapHanaLinkedService = original.SapHanaLinkedService
type SapHanaLinkedServiceProperties = original.SapHanaLinkedServiceProperties
type SapHanaPartitionSettings = original.SapHanaPartitionSettings
type SapHanaSource = original.SapHanaSource
type SapHanaTableDataset = original.SapHanaTableDataset
type SapHanaTableDatasetTypeProperties = original.SapHanaTableDatasetTypeProperties
type SapOpenHubLinkedService = original.SapOpenHubLinkedService
type SapOpenHubLinkedServiceTypeProperties = original.SapOpenHubLinkedServiceTypeProperties
type SapOpenHubSource = original.SapOpenHubSource
type SapOpenHubTableDataset = original.SapOpenHubTableDataset
type SapOpenHubTableDatasetTypeProperties = original.SapOpenHubTableDatasetTypeProperties
type SapTableLinkedService = original.SapTableLinkedService
type SapTableLinkedServiceTypeProperties = original.SapTableLinkedServiceTypeProperties
type SapTablePartitionSettings = original.SapTablePartitionSettings
type SapTableResourceDataset = original.SapTableResourceDataset
type SapTableResourceDatasetTypeProperties = original.SapTableResourceDatasetTypeProperties
type SapTableSource = original.SapTableSource
type ScheduleTrigger = original.ScheduleTrigger
type ScheduleTriggerRecurrence = original.ScheduleTriggerRecurrence
type ScheduleTriggerTypeProperties = original.ScheduleTriggerTypeProperties
type ScriptAction = original.ScriptAction
type SecretBase = original.SecretBase
type SecureString = original.SecureString
type SelfDependencyTumblingWindowTriggerReference = original.SelfDependencyTumblingWindowTriggerReference
type SelfHostedIntegrationRuntime = original.SelfHostedIntegrationRuntime
type SelfHostedIntegrationRuntimeNode = original.SelfHostedIntegrationRuntimeNode
type SelfHostedIntegrationRuntimeStatus = original.SelfHostedIntegrationRuntimeStatus
type SelfHostedIntegrationRuntimeStatusTypeProperties = original.SelfHostedIntegrationRuntimeStatusTypeProperties
type SelfHostedIntegrationRuntimeTypeProperties = original.SelfHostedIntegrationRuntimeTypeProperties
type ServiceNowLinkedService = original.ServiceNowLinkedService
type ServiceNowLinkedServiceTypeProperties = original.ServiceNowLinkedServiceTypeProperties
type ServiceNowObjectDataset = original.ServiceNowObjectDataset
type ServiceNowSource = original.ServiceNowSource
type SetVariableActivity = original.SetVariableActivity
type SetVariableActivityTypeProperties = original.SetVariableActivityTypeProperties
type SftpLocation = original.SftpLocation
type SftpReadSettings = original.SftpReadSettings
type SftpServerLinkedService = original.SftpServerLinkedService
type SftpServerLinkedServiceTypeProperties = original.SftpServerLinkedServiceTypeProperties
type ShopifyLinkedService = original.ShopifyLinkedService
type ShopifyLinkedServiceTypeProperties = original.ShopifyLinkedServiceTypeProperties
type ShopifyObjectDataset = original.ShopifyObjectDataset
type ShopifySource = original.ShopifySource
type SparkDatasetTypeProperties = original.SparkDatasetTypeProperties
type SparkLinkedService = original.SparkLinkedService
type SparkLinkedServiceTypeProperties = original.SparkLinkedServiceTypeProperties
type SparkObjectDataset = original.SparkObjectDataset
type SparkSource = original.SparkSource
type SquareLinkedService = original.SquareLinkedService
type SquareLinkedServiceTypeProperties = original.SquareLinkedServiceTypeProperties
type SquareObjectDataset = original.SquareObjectDataset
type SquareSource = original.SquareSource
type SsisEnvironment = original.SsisEnvironment
type SsisEnvironmentReference = original.SsisEnvironmentReference
type SsisFolder = original.SsisFolder
type SsisObjectMetadata = original.SsisObjectMetadata
type SsisObjectMetadataListResponse = original.SsisObjectMetadataListResponse
type SsisObjectMetadataStatusResponse = original.SsisObjectMetadataStatusResponse
type SsisPackage = original.SsisPackage
type SsisParameter = original.SsisParameter
type SsisProject = original.SsisProject
type SsisVariable = original.SsisVariable
type StagingSettings = original.StagingSettings
type StoreReadSettings = original.StoreReadSettings
type StoreWriteSettings = original.StoreWriteSettings
type StoredProcedureParameter = original.StoredProcedureParameter
type SubResource = original.SubResource
type SubResourceDebugResource = original.SubResourceDebugResource
type SwitchActivity = original.SwitchActivity
type SwitchActivityTypeProperties = original.SwitchActivityTypeProperties
type SwitchCase = original.SwitchCase
type SybaseLinkedService = original.SybaseLinkedService
type SybaseLinkedServiceTypeProperties = original.SybaseLinkedServiceTypeProperties
type SybaseSource = original.SybaseSource
type SybaseTableDataset = original.SybaseTableDataset
type SybaseTableDatasetTypeProperties = original.SybaseTableDatasetTypeProperties
type TabularSource = original.TabularSource
type TeradataLinkedService = original.TeradataLinkedService
type TeradataLinkedServiceTypeProperties = original.TeradataLinkedServiceTypeProperties
type TeradataPartitionSettings = original.TeradataPartitionSettings
type TeradataSource = original.TeradataSource
type TeradataTableDataset = original.TeradataTableDataset
type TeradataTableDatasetTypeProperties = original.TeradataTableDatasetTypeProperties
type TextFormat = original.TextFormat
type Transformation = original.Transformation
type Trigger = original.Trigger
type TriggerDependencyReference = original.TriggerDependencyReference
type TriggerListResponse = original.TriggerListResponse
type TriggerListResponseIterator = original.TriggerListResponseIterator
type TriggerListResponsePage = original.TriggerListResponsePage
type TriggerPipelineReference = original.TriggerPipelineReference
type TriggerReference = original.TriggerReference
type TriggerResource = original.TriggerResource
type TriggerRun = original.TriggerRun
type TriggerRunsClient = original.TriggerRunsClient
type TriggerRunsQueryResponse = original.TriggerRunsQueryResponse
type TriggerSubscriptionOperationStatus = original.TriggerSubscriptionOperationStatus
type TriggersClient = original.TriggersClient
type TriggersStartFuture = original.TriggersStartFuture
type TriggersStopFuture = original.TriggersStopFuture
type TriggersSubscribeToEventsFuture = original.TriggersSubscribeToEventsFuture
type TriggersUnsubscribeFromEventsFuture = original.TriggersUnsubscribeFromEventsFuture
type TumblingWindowTrigger = original.TumblingWindowTrigger
type TumblingWindowTriggerDependencyReference = original.TumblingWindowTriggerDependencyReference
type TumblingWindowTriggerTypeProperties = original.TumblingWindowTriggerTypeProperties
type UntilActivity = original.UntilActivity
type UntilActivityTypeProperties = original.UntilActivityTypeProperties
type UpdateIntegrationRuntimeNodeRequest = original.UpdateIntegrationRuntimeNodeRequest
type UpdateIntegrationRuntimeRequest = original.UpdateIntegrationRuntimeRequest
type UserAccessPolicy = original.UserAccessPolicy
type UserProperty = original.UserProperty
type ValidationActivity = original.ValidationActivity
type ValidationActivityTypeProperties = original.ValidationActivityTypeProperties
type VariableSpecification = original.VariableSpecification
type VerticaDatasetTypeProperties = original.VerticaDatasetTypeProperties
type VerticaLinkedService = original.VerticaLinkedService
type VerticaLinkedServiceTypeProperties = original.VerticaLinkedServiceTypeProperties
type VerticaSource = original.VerticaSource
type VerticaTableDataset = original.VerticaTableDataset
type WaitActivity = original.WaitActivity
type WaitActivityTypeProperties = original.WaitActivityTypeProperties
type WebActivity = original.WebActivity
type WebActivityAuthentication = original.WebActivityAuthentication
type WebActivityTypeProperties = original.WebActivityTypeProperties
type WebAnonymousAuthentication = original.WebAnonymousAuthentication
type WebBasicAuthentication = original.WebBasicAuthentication
type WebClientCertificateAuthentication = original.WebClientCertificateAuthentication
type WebHookActivity = original.WebHookActivity
type WebHookActivityTypeProperties = original.WebHookActivityTypeProperties
type WebLinkedService = original.WebLinkedService
type WebLinkedServiceTypeProperties = original.WebLinkedServiceTypeProperties
type WebSource = original.WebSource
type WebTableDataset = original.WebTableDataset
type WebTableDatasetTypeProperties = original.WebTableDatasetTypeProperties
type XeroLinkedService = original.XeroLinkedService
type XeroLinkedServiceTypeProperties = original.XeroLinkedServiceTypeProperties
type XeroObjectDataset = original.XeroObjectDataset
type XeroSource = original.XeroSource
type ZohoLinkedService = original.ZohoLinkedService
type ZohoLinkedServiceTypeProperties = original.ZohoLinkedServiceTypeProperties
type ZohoObjectDataset = original.ZohoObjectDataset
type ZohoSource = original.ZohoSource

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewActivityRunsClient(subscriptionID string) ActivityRunsClient {
	return original.NewActivityRunsClient(subscriptionID)
}
func NewActivityRunsClientWithBaseURI(baseURI string, subscriptionID string) ActivityRunsClient {
	return original.NewActivityRunsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDataFlowDebugSessionClient(subscriptionID string) DataFlowDebugSessionClient {
	return original.NewDataFlowDebugSessionClient(subscriptionID)
}
func NewDataFlowDebugSessionClientWithBaseURI(baseURI string, subscriptionID string) DataFlowDebugSessionClient {
	return original.NewDataFlowDebugSessionClientWithBaseURI(baseURI, subscriptionID)
}
func NewDataFlowListResponseIterator(page DataFlowListResponsePage) DataFlowListResponseIterator {
	return original.NewDataFlowListResponseIterator(page)
}
func NewDataFlowListResponsePage(getNextPage func(context.Context, DataFlowListResponse) (DataFlowListResponse, error)) DataFlowListResponsePage {
	return original.NewDataFlowListResponsePage(getNextPage)
}
func NewDataFlowsClient(subscriptionID string) DataFlowsClient {
	return original.NewDataFlowsClient(subscriptionID)
}
func NewDataFlowsClientWithBaseURI(baseURI string, subscriptionID string) DataFlowsClient {
	return original.NewDataFlowsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDatasetListResponseIterator(page DatasetListResponsePage) DatasetListResponseIterator {
	return original.NewDatasetListResponseIterator(page)
}
func NewDatasetListResponsePage(getNextPage func(context.Context, DatasetListResponse) (DatasetListResponse, error)) DatasetListResponsePage {
	return original.NewDatasetListResponsePage(getNextPage)
}
func NewDatasetsClient(subscriptionID string) DatasetsClient {
	return original.NewDatasetsClient(subscriptionID)
}
func NewDatasetsClientWithBaseURI(baseURI string, subscriptionID string) DatasetsClient {
	return original.NewDatasetsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExposureControlClient(subscriptionID string) ExposureControlClient {
	return original.NewExposureControlClient(subscriptionID)
}
func NewExposureControlClientWithBaseURI(baseURI string, subscriptionID string) ExposureControlClient {
	return original.NewExposureControlClientWithBaseURI(baseURI, subscriptionID)
}
func NewFactoriesClient(subscriptionID string) FactoriesClient {
	return original.NewFactoriesClient(subscriptionID)
}
func NewFactoriesClientWithBaseURI(baseURI string, subscriptionID string) FactoriesClient {
	return original.NewFactoriesClientWithBaseURI(baseURI, subscriptionID)
}
func NewFactoryListResponseIterator(page FactoryListResponsePage) FactoryListResponseIterator {
	return original.NewFactoryListResponseIterator(page)
}
func NewFactoryListResponsePage(getNextPage func(context.Context, FactoryListResponse) (FactoryListResponse, error)) FactoryListResponsePage {
	return original.NewFactoryListResponsePage(getNextPage)
}
func NewIntegrationRuntimeListResponseIterator(page IntegrationRuntimeListResponsePage) IntegrationRuntimeListResponseIterator {
	return original.NewIntegrationRuntimeListResponseIterator(page)
}
func NewIntegrationRuntimeListResponsePage(getNextPage func(context.Context, IntegrationRuntimeListResponse) (IntegrationRuntimeListResponse, error)) IntegrationRuntimeListResponsePage {
	return original.NewIntegrationRuntimeListResponsePage(getNextPage)
}
func NewIntegrationRuntimeNodesClient(subscriptionID string) IntegrationRuntimeNodesClient {
	return original.NewIntegrationRuntimeNodesClient(subscriptionID)
}
func NewIntegrationRuntimeNodesClientWithBaseURI(baseURI string, subscriptionID string) IntegrationRuntimeNodesClient {
	return original.NewIntegrationRuntimeNodesClientWithBaseURI(baseURI, subscriptionID)
}
func NewIntegrationRuntimeObjectMetadataClient(subscriptionID string) IntegrationRuntimeObjectMetadataClient {
	return original.NewIntegrationRuntimeObjectMetadataClient(subscriptionID)
}
func NewIntegrationRuntimeObjectMetadataClientWithBaseURI(baseURI string, subscriptionID string) IntegrationRuntimeObjectMetadataClient {
	return original.NewIntegrationRuntimeObjectMetadataClientWithBaseURI(baseURI, subscriptionID)
}
func NewIntegrationRuntimesClient(subscriptionID string) IntegrationRuntimesClient {
	return original.NewIntegrationRuntimesClient(subscriptionID)
}
func NewIntegrationRuntimesClientWithBaseURI(baseURI string, subscriptionID string) IntegrationRuntimesClient {
	return original.NewIntegrationRuntimesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLinkedServiceListResponseIterator(page LinkedServiceListResponsePage) LinkedServiceListResponseIterator {
	return original.NewLinkedServiceListResponseIterator(page)
}
func NewLinkedServiceListResponsePage(getNextPage func(context.Context, LinkedServiceListResponse) (LinkedServiceListResponse, error)) LinkedServiceListResponsePage {
	return original.NewLinkedServiceListResponsePage(getNextPage)
}
func NewLinkedServicesClient(subscriptionID string) LinkedServicesClient {
	return original.NewLinkedServicesClient(subscriptionID)
}
func NewLinkedServicesClientWithBaseURI(baseURI string, subscriptionID string) LinkedServicesClient {
	return original.NewLinkedServicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationListResponseIterator(page OperationListResponsePage) OperationListResponseIterator {
	return original.NewOperationListResponseIterator(page)
}
func NewOperationListResponsePage(getNextPage func(context.Context, OperationListResponse) (OperationListResponse, error)) OperationListResponsePage {
	return original.NewOperationListResponsePage(getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPipelineListResponseIterator(page PipelineListResponsePage) PipelineListResponseIterator {
	return original.NewPipelineListResponseIterator(page)
}
func NewPipelineListResponsePage(getNextPage func(context.Context, PipelineListResponse) (PipelineListResponse, error)) PipelineListResponsePage {
	return original.NewPipelineListResponsePage(getNextPage)
}
func NewPipelineRunsClient(subscriptionID string) PipelineRunsClient {
	return original.NewPipelineRunsClient(subscriptionID)
}
func NewPipelineRunsClientWithBaseURI(baseURI string, subscriptionID string) PipelineRunsClient {
	return original.NewPipelineRunsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPipelinesClient(subscriptionID string) PipelinesClient {
	return original.NewPipelinesClient(subscriptionID)
}
func NewPipelinesClientWithBaseURI(baseURI string, subscriptionID string) PipelinesClient {
	return original.NewPipelinesClientWithBaseURI(baseURI, subscriptionID)
}
func NewQueryDataFlowDebugSessionsResponseIterator(page QueryDataFlowDebugSessionsResponsePage) QueryDataFlowDebugSessionsResponseIterator {
	return original.NewQueryDataFlowDebugSessionsResponseIterator(page)
}
func NewQueryDataFlowDebugSessionsResponsePage(getNextPage func(context.Context, QueryDataFlowDebugSessionsResponse) (QueryDataFlowDebugSessionsResponse, error)) QueryDataFlowDebugSessionsResponsePage {
	return original.NewQueryDataFlowDebugSessionsResponsePage(getNextPage)
}
func NewRerunTriggerListResponseIterator(page RerunTriggerListResponsePage) RerunTriggerListResponseIterator {
	return original.NewRerunTriggerListResponseIterator(page)
}
func NewRerunTriggerListResponsePage(getNextPage func(context.Context, RerunTriggerListResponse) (RerunTriggerListResponse, error)) RerunTriggerListResponsePage {
	return original.NewRerunTriggerListResponsePage(getNextPage)
}
func NewRerunTriggersClient(subscriptionID string) RerunTriggersClient {
	return original.NewRerunTriggersClient(subscriptionID)
}
func NewRerunTriggersClientWithBaseURI(baseURI string, subscriptionID string) RerunTriggersClient {
	return original.NewRerunTriggersClientWithBaseURI(baseURI, subscriptionID)
}
func NewTriggerListResponseIterator(page TriggerListResponsePage) TriggerListResponseIterator {
	return original.NewTriggerListResponseIterator(page)
}
func NewTriggerListResponsePage(getNextPage func(context.Context, TriggerListResponse) (TriggerListResponse, error)) TriggerListResponsePage {
	return original.NewTriggerListResponsePage(getNextPage)
}
func NewTriggerRunsClient(subscriptionID string) TriggerRunsClient {
	return original.NewTriggerRunsClient(subscriptionID)
}
func NewTriggerRunsClientWithBaseURI(baseURI string, subscriptionID string) TriggerRunsClient {
	return original.NewTriggerRunsClientWithBaseURI(baseURI, subscriptionID)
}
func NewTriggersClient(subscriptionID string) TriggersClient {
	return original.NewTriggersClient(subscriptionID)
}
func NewTriggersClientWithBaseURI(baseURI string, subscriptionID string) TriggersClient {
	return original.NewTriggersClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return original.PossibleAuthenticationTypeValues()
}
func PossibleAuthorizationTypeValues() []AuthorizationType {
	return original.PossibleAuthorizationTypeValues()
}
func PossibleAvroCompressionCodecValues() []AvroCompressionCodec {
	return original.PossibleAvroCompressionCodecValues()
}
func PossibleAzureFunctionActivityMethodValues() []AzureFunctionActivityMethod {
	return original.PossibleAzureFunctionActivityMethodValues()
}
func PossibleAzureSearchIndexWriteBehaviorTypeValues() []AzureSearchIndexWriteBehaviorType {
	return original.PossibleAzureSearchIndexWriteBehaviorTypeValues()
}
func PossibleBlobEventTypesValues() []BlobEventTypes {
	return original.PossibleBlobEventTypesValues()
}
func PossibleCassandraSourceReadConsistencyLevelsValues() []CassandraSourceReadConsistencyLevels {
	return original.PossibleCassandraSourceReadConsistencyLevelsValues()
}
func PossibleDataFlowComputeTypeValues() []DataFlowComputeType {
	return original.PossibleDataFlowComputeTypeValues()
}
func PossibleDataFlowDebugCommandTypeValues() []DataFlowDebugCommandType {
	return original.PossibleDataFlowDebugCommandTypeValues()
}
func PossibleDayOfWeekValues() []DayOfWeek {
	return original.PossibleDayOfWeekValues()
}
func PossibleDaysOfWeekValues() []DaysOfWeek {
	return original.PossibleDaysOfWeekValues()
}
func PossibleDb2AuthenticationTypeValues() []Db2AuthenticationType {
	return original.PossibleDb2AuthenticationTypeValues()
}
func PossibleDependencyConditionValues() []DependencyCondition {
	return original.PossibleDependencyConditionValues()
}
func PossibleDynamicsAuthenticationTypeValues() []DynamicsAuthenticationType {
	return original.PossibleDynamicsAuthenticationTypeValues()
}
func PossibleDynamicsDeploymentTypeValues() []DynamicsDeploymentType {
	return original.PossibleDynamicsDeploymentTypeValues()
}
func PossibleEventSubscriptionStatusValues() []EventSubscriptionStatus {
	return original.PossibleEventSubscriptionStatusValues()
}
func PossibleFtpAuthenticationTypeValues() []FtpAuthenticationType {
	return original.PossibleFtpAuthenticationTypeValues()
}
func PossibleGoogleAdWordsAuthenticationTypeValues() []GoogleAdWordsAuthenticationType {
	return original.PossibleGoogleAdWordsAuthenticationTypeValues()
}
func PossibleGoogleBigQueryAuthenticationTypeValues() []GoogleBigQueryAuthenticationType {
	return original.PossibleGoogleBigQueryAuthenticationTypeValues()
}
func PossibleHBaseAuthenticationTypeValues() []HBaseAuthenticationType {
	return original.PossibleHBaseAuthenticationTypeValues()
}
func PossibleHDInsightActivityDebugInfoOptionValues() []HDInsightActivityDebugInfoOption {
	return original.PossibleHDInsightActivityDebugInfoOptionValues()
}
func PossibleHTTPAuthenticationTypeValues() []HTTPAuthenticationType {
	return original.PossibleHTTPAuthenticationTypeValues()
}
func PossibleHiveAuthenticationTypeValues() []HiveAuthenticationType {
	return original.PossibleHiveAuthenticationTypeValues()
}
func PossibleHiveServerTypeValues() []HiveServerType {
	return original.PossibleHiveServerTypeValues()
}
func PossibleHiveThriftTransportProtocolValues() []HiveThriftTransportProtocol {
	return original.PossibleHiveThriftTransportProtocolValues()
}
func PossibleImpalaAuthenticationTypeValues() []ImpalaAuthenticationType {
	return original.PossibleImpalaAuthenticationTypeValues()
}
func PossibleIntegrationRuntimeAuthKeyNameValues() []IntegrationRuntimeAuthKeyName {
	return original.PossibleIntegrationRuntimeAuthKeyNameValues()
}
func PossibleIntegrationRuntimeAutoUpdateValues() []IntegrationRuntimeAutoUpdate {
	return original.PossibleIntegrationRuntimeAutoUpdateValues()
}
func PossibleIntegrationRuntimeEditionValues() []IntegrationRuntimeEdition {
	return original.PossibleIntegrationRuntimeEditionValues()
}
func PossibleIntegrationRuntimeEntityReferenceTypeValues() []IntegrationRuntimeEntityReferenceType {
	return original.PossibleIntegrationRuntimeEntityReferenceTypeValues()
}
func PossibleIntegrationRuntimeInternalChannelEncryptionModeValues() []IntegrationRuntimeInternalChannelEncryptionMode {
	return original.PossibleIntegrationRuntimeInternalChannelEncryptionModeValues()
}
func PossibleIntegrationRuntimeLicenseTypeValues() []IntegrationRuntimeLicenseType {
	return original.PossibleIntegrationRuntimeLicenseTypeValues()
}
func PossibleIntegrationRuntimeSsisCatalogPricingTierValues() []IntegrationRuntimeSsisCatalogPricingTier {
	return original.PossibleIntegrationRuntimeSsisCatalogPricingTierValues()
}
func PossibleIntegrationRuntimeStateValues() []IntegrationRuntimeState {
	return original.PossibleIntegrationRuntimeStateValues()
}
func PossibleIntegrationRuntimeTypeValues() []IntegrationRuntimeType {
	return original.PossibleIntegrationRuntimeTypeValues()
}
func PossibleIntegrationRuntimeUpdateResultValues() []IntegrationRuntimeUpdateResult {
	return original.PossibleIntegrationRuntimeUpdateResultValues()
}
func PossibleJSONWriteFilePatternValues() []JSONWriteFilePattern {
	return original.PossibleJSONWriteFilePatternValues()
}
func PossibleManagedIntegrationRuntimeNodeStatusValues() []ManagedIntegrationRuntimeNodeStatus {
	return original.PossibleManagedIntegrationRuntimeNodeStatusValues()
}
func PossibleMongoDbAuthenticationTypeValues() []MongoDbAuthenticationType {
	return original.PossibleMongoDbAuthenticationTypeValues()
}
func PossibleNetezzaPartitionOptionValues() []NetezzaPartitionOption {
	return original.PossibleNetezzaPartitionOptionValues()
}
func PossibleODataAadServicePrincipalCredentialTypeValues() []ODataAadServicePrincipalCredentialType {
	return original.PossibleODataAadServicePrincipalCredentialTypeValues()
}
func PossibleODataAuthenticationTypeValues() []ODataAuthenticationType {
	return original.PossibleODataAuthenticationTypeValues()
}
func PossibleOraclePartitionOptionValues() []OraclePartitionOption {
	return original.PossibleOraclePartitionOptionValues()
}
func PossibleOrcCompressionCodecValues() []OrcCompressionCodec {
	return original.PossibleOrcCompressionCodecValues()
}
func PossibleParameterTypeValues() []ParameterType {
	return original.PossibleParameterTypeValues()
}
func PossiblePhoenixAuthenticationTypeValues() []PhoenixAuthenticationType {
	return original.PossiblePhoenixAuthenticationTypeValues()
}
func PossiblePolybaseSettingsRejectTypeValues() []PolybaseSettingsRejectType {
	return original.PossiblePolybaseSettingsRejectTypeValues()
}
func PossiblePrestoAuthenticationTypeValues() []PrestoAuthenticationType {
	return original.PossiblePrestoAuthenticationTypeValues()
}
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return original.PossibleRecurrenceFrequencyValues()
}
func PossibleRestServiceAuthenticationTypeValues() []RestServiceAuthenticationType {
	return original.PossibleRestServiceAuthenticationTypeValues()
}
func PossibleRunQueryFilterOperandValues() []RunQueryFilterOperand {
	return original.PossibleRunQueryFilterOperandValues()
}
func PossibleRunQueryFilterOperatorValues() []RunQueryFilterOperator {
	return original.PossibleRunQueryFilterOperatorValues()
}
func PossibleRunQueryOrderByFieldValues() []RunQueryOrderByField {
	return original.PossibleRunQueryOrderByFieldValues()
}
func PossibleRunQueryOrderValues() []RunQueryOrder {
	return original.PossibleRunQueryOrderValues()
}
func PossibleSalesforceSinkWriteBehaviorValues() []SalesforceSinkWriteBehavior {
	return original.PossibleSalesforceSinkWriteBehaviorValues()
}
func PossibleSalesforceSourceReadBehaviorValues() []SalesforceSourceReadBehavior {
	return original.PossibleSalesforceSourceReadBehaviorValues()
}
func PossibleSapCloudForCustomerSinkWriteBehaviorValues() []SapCloudForCustomerSinkWriteBehavior {
	return original.PossibleSapCloudForCustomerSinkWriteBehaviorValues()
}
func PossibleSapHanaAuthenticationTypeValues() []SapHanaAuthenticationType {
	return original.PossibleSapHanaAuthenticationTypeValues()
}
func PossibleSapHanaPartitionOptionValues() []SapHanaPartitionOption {
	return original.PossibleSapHanaPartitionOptionValues()
}
func PossibleSapTablePartitionOptionValues() []SapTablePartitionOption {
	return original.PossibleSapTablePartitionOptionValues()
}
func PossibleSelfHostedIntegrationRuntimeNodeStatusValues() []SelfHostedIntegrationRuntimeNodeStatus {
	return original.PossibleSelfHostedIntegrationRuntimeNodeStatusValues()
}
func PossibleServiceNowAuthenticationTypeValues() []ServiceNowAuthenticationType {
	return original.PossibleServiceNowAuthenticationTypeValues()
}
func PossibleSftpAuthenticationTypeValues() []SftpAuthenticationType {
	return original.PossibleSftpAuthenticationTypeValues()
}
func PossibleSparkAuthenticationTypeValues() []SparkAuthenticationType {
	return original.PossibleSparkAuthenticationTypeValues()
}
func PossibleSparkServerTypeValues() []SparkServerType {
	return original.PossibleSparkServerTypeValues()
}
func PossibleSparkThriftTransportProtocolValues() []SparkThriftTransportProtocol {
	return original.PossibleSparkThriftTransportProtocolValues()
}
func PossibleSsisObjectMetadataTypeValues() []SsisObjectMetadataType {
	return original.PossibleSsisObjectMetadataTypeValues()
}
func PossibleSsisPackageLocationTypeValues() []SsisPackageLocationType {
	return original.PossibleSsisPackageLocationTypeValues()
}
func PossibleStoredProcedureParameterTypeValues() []StoredProcedureParameterType {
	return original.PossibleStoredProcedureParameterTypeValues()
}
func PossibleSybaseAuthenticationTypeValues() []SybaseAuthenticationType {
	return original.PossibleSybaseAuthenticationTypeValues()
}
func PossibleTeradataAuthenticationTypeValues() []TeradataAuthenticationType {
	return original.PossibleTeradataAuthenticationTypeValues()
}
func PossibleTeradataPartitionOptionValues() []TeradataPartitionOption {
	return original.PossibleTeradataPartitionOptionValues()
}
func PossibleTriggerRunStatusValues() []TriggerRunStatus {
	return original.PossibleTriggerRunStatusValues()
}
func PossibleTriggerRuntimeStateValues() []TriggerRuntimeState {
	return original.PossibleTriggerRuntimeStateValues()
}
func PossibleTumblingWindowFrequencyValues() []TumblingWindowFrequency {
	return original.PossibleTumblingWindowFrequencyValues()
}
func PossibleTypeBasicActivityValues() []TypeBasicActivity {
	return original.PossibleTypeBasicActivityValues()
}
func PossibleTypeBasicCopySinkValues() []TypeBasicCopySink {
	return original.PossibleTypeBasicCopySinkValues()
}
func PossibleTypeBasicCopySourceValues() []TypeBasicCopySource {
	return original.PossibleTypeBasicCopySourceValues()
}
func PossibleTypeBasicCustomSetupBaseValues() []TypeBasicCustomSetupBase {
	return original.PossibleTypeBasicCustomSetupBaseValues()
}
func PossibleTypeBasicDataFlowValues() []TypeBasicDataFlow {
	return original.PossibleTypeBasicDataFlowValues()
}
func PossibleTypeBasicDatasetCompressionValues() []TypeBasicDatasetCompression {
	return original.PossibleTypeBasicDatasetCompressionValues()
}
func PossibleTypeBasicDatasetStorageFormatValues() []TypeBasicDatasetStorageFormat {
	return original.PossibleTypeBasicDatasetStorageFormatValues()
}
func PossibleTypeBasicDatasetValues() []TypeBasicDataset {
	return original.PossibleTypeBasicDatasetValues()
}
func PossibleTypeBasicDependencyReferenceValues() []TypeBasicDependencyReference {
	return original.PossibleTypeBasicDependencyReferenceValues()
}
func PossibleTypeBasicFactoryRepoConfigurationValues() []TypeBasicFactoryRepoConfiguration {
	return original.PossibleTypeBasicFactoryRepoConfigurationValues()
}
func PossibleTypeBasicIntegrationRuntimeStatusValues() []TypeBasicIntegrationRuntimeStatus {
	return original.PossibleTypeBasicIntegrationRuntimeStatusValues()
}
func PossibleTypeBasicIntegrationRuntimeValues() []TypeBasicIntegrationRuntime {
	return original.PossibleTypeBasicIntegrationRuntimeValues()
}
func PossibleTypeBasicLinkedServiceValues() []TypeBasicLinkedService {
	return original.PossibleTypeBasicLinkedServiceValues()
}
func PossibleTypeBasicSsisObjectMetadataValues() []TypeBasicSsisObjectMetadata {
	return original.PossibleTypeBasicSsisObjectMetadataValues()
}
func PossibleTypeBasicStoreWriteSettingsValues() []TypeBasicStoreWriteSettings {
	return original.PossibleTypeBasicStoreWriteSettingsValues()
}
func PossibleTypeBasicTriggerValues() []TypeBasicTrigger {
	return original.PossibleTypeBasicTriggerValues()
}
func PossibleTypeValues() []Type {
	return original.PossibleTypeValues()
}
func PossibleVariableTypeValues() []VariableType {
	return original.PossibleVariableTypeValues()
}
func PossibleWebActivityMethodValues() []WebActivityMethod {
	return original.PossibleWebActivityMethodValues()
}
func PossibleWebHookActivityMethodValues() []WebHookActivityMethod {
	return original.PossibleWebHookActivityMethodValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/latest"
}
func Version() string {
	return original.Version()
}
