package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTemplate invokes the vs.DescribeTemplate API synchronously
func (client *Client) DescribeTemplate(request *DescribeTemplateRequest) (response *DescribeTemplateResponse, err error) {
	response = CreateDescribeTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTemplateWithChan invokes the vs.DescribeTemplate API asynchronously
func (client *Client) DescribeTemplateWithChan(request *DescribeTemplateRequest) (<-chan *DescribeTemplateResponse, <-chan error) {
	responseChan := make(chan *DescribeTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTemplateWithCallback invokes the vs.DescribeTemplate API asynchronously
func (client *Client) DescribeTemplateWithCallback(request *DescribeTemplateRequest, callback func(response *DescribeTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTemplateResponse
		var err error
		defer close(result)
		response, err = client.DescribeTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTemplateRequest is the request struct for api DescribeTemplate
type DescribeTemplateRequest struct {
	*requests.RpcRequest
	Id      string           `position:"Query" name:"Id"`
	ShowLog string           `position:"Query" name:"ShowLog"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeTemplateResponse is the response struct for api DescribeTemplate
type DescribeTemplateResponse struct {
	*responses.BaseResponse
	Type          string        `json:"Type" xml:"Type"`
	Trigger       string        `json:"Trigger" xml:"Trigger"`
	HlsTs         string        `json:"HlsTs" xml:"HlsTs"`
	Mp4           string        `json:"Mp4" xml:"Mp4"`
	JpgOverwrite  string        `json:"JpgOverwrite" xml:"JpgOverwrite"`
	Callback      string        `json:"Callback" xml:"Callback"`
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	Description   string        `json:"Description" xml:"Description"`
	Region        string        `json:"Region" xml:"Region"`
	Retention     int64         `json:"Retention" xml:"Retention"`
	HlsM3u8       string        `json:"HlsM3u8" xml:"HlsM3u8"`
	Name          string        `json:"Name" xml:"Name"`
	Flv           string        `json:"Flv" xml:"Flv"`
	CreatedTime   string        `json:"CreatedTime" xml:"CreatedTime"`
	OssEndpoint   string        `json:"OssEndpoint" xml:"OssEndpoint"`
	OssFilePrefix string        `json:"OssFilePrefix" xml:"OssFilePrefix"`
	JpgOnDemand   string        `json:"JpgOnDemand" xml:"JpgOnDemand"`
	OssBucket     string        `json:"OssBucket" xml:"OssBucket"`
	FileFormat    string        `json:"FileFormat" xml:"FileFormat"`
	JpgSequence   string        `json:"JpgSequence" xml:"JpgSequence"`
	EndTime       string        `json:"EndTime" xml:"EndTime"`
	StartTime     string        `json:"StartTime" xml:"StartTime"`
	Interval      int64         `json:"Interval" xml:"Interval"`
	Id            string        `json:"Id" xml:"Id"`
	TransConfigs  []TransConfig `json:"TransConfigs" xml:"TransConfigs"`
}

// CreateDescribeTemplateRequest creates a request to invoke DescribeTemplate API
func CreateDescribeTemplateRequest() (request *DescribeTemplateRequest) {
	request = &DescribeTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeTemplate", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeTemplateResponse creates a response to parse from DescribeTemplate response
func CreateDescribeTemplateResponse() (response *DescribeTemplateResponse) {
	response = &DescribeTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
