package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateStreamSnapshot invokes the vs.CreateStreamSnapshot API synchronously
func (client *Client) CreateStreamSnapshot(request *CreateStreamSnapshotRequest) (response *CreateStreamSnapshotResponse, err error) {
	response = CreateCreateStreamSnapshotResponse()
	err = client.DoAction(request, response)
	return
}

// CreateStreamSnapshotWithChan invokes the vs.CreateStreamSnapshot API asynchronously
func (client *Client) CreateStreamSnapshotWithChan(request *CreateStreamSnapshotRequest) (<-chan *CreateStreamSnapshotResponse, <-chan error) {
	responseChan := make(chan *CreateStreamSnapshotResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateStreamSnapshot(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateStreamSnapshotWithCallback invokes the vs.CreateStreamSnapshot API asynchronously
func (client *Client) CreateStreamSnapshotWithCallback(request *CreateStreamSnapshotRequest, callback func(response *CreateStreamSnapshotResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateStreamSnapshotResponse
		var err error
		defer close(result)
		response, err = client.CreateStreamSnapshot(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateStreamSnapshotRequest is the request struct for api CreateStreamSnapshot
type CreateStreamSnapshotRequest struct {
	*requests.RpcRequest
	Id       string           `position:"Query" name:"Id"`
	ShowLog  string           `position:"Query" name:"ShowLog"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
	Location string           `position:"Query" name:"Location"`
}

// CreateStreamSnapshotResponse is the response struct for api CreateStreamSnapshot
type CreateStreamSnapshotResponse struct {
	*responses.BaseResponse
	OssObject   string `json:"OssObject" xml:"OssObject"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
	Width       int64  `json:"Width" xml:"Width"`
	Height      int64  `json:"Height" xml:"Height"`
	Url         string `json:"Url" xml:"Url"`
	Timestamp   int64  `json:"Timestamp" xml:"Timestamp"`
	OssBucket   string `json:"OssBucket" xml:"OssBucket"`
	Format      string `json:"Format" xml:"Format"`
	OssEndpoint string `json:"OssEndpoint" xml:"OssEndpoint"`
	Id          string `json:"Id" xml:"Id"`
}

// CreateCreateStreamSnapshotRequest creates a request to invoke CreateStreamSnapshot API
func CreateCreateStreamSnapshotRequest() (request *CreateStreamSnapshotRequest) {
	request = &CreateStreamSnapshotRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "CreateStreamSnapshot", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateStreamSnapshotResponse creates a response to parse from CreateStreamSnapshot response
func CreateCreateStreamSnapshotResponse() (response *CreateStreamSnapshotResponse) {
	response = &CreateStreamSnapshotResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
