package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFailoverTestJob invokes the vpc.CreateFailoverTestJob API synchronously
func (client *Client) CreateFailoverTestJob(request *CreateFailoverTestJobRequest) (response *CreateFailoverTestJobResponse, err error) {
	response = CreateCreateFailoverTestJobResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFailoverTestJobWithChan invokes the vpc.CreateFailoverTestJob API asynchronously
func (client *Client) CreateFailoverTestJobWithChan(request *CreateFailoverTestJobRequest) (<-chan *CreateFailoverTestJobResponse, <-chan error) {
	responseChan := make(chan *CreateFailoverTestJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFailoverTestJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFailoverTestJobWithCallback invokes the vpc.CreateFailoverTestJob API asynchronously
func (client *Client) CreateFailoverTestJobWithCallback(request *CreateFailoverTestJobRequest, callback func(response *CreateFailoverTestJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFailoverTestJobResponse
		var err error
		defer close(result)
		response, err = client.CreateFailoverTestJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFailoverTestJobRequest is the request struct for api CreateFailoverTestJob
type CreateFailoverTestJobRequest struct {
	*requests.RpcRequest
	ClientToken          string           `position:"Query" name:"ClientToken"`
	Description          string           `position:"Query" name:"Description"`
	JobDuration          requests.Integer `position:"Query" name:"JobDuration"`
	ResourceId           *[]string        `position:"Query" name:"ResourceId"  type:"Repeated"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceType         string           `position:"Query" name:"ResourceType"`
	JobType              string           `position:"Query" name:"JobType"`
	Name                 string           `position:"Query" name:"Name"`
}

// CreateFailoverTestJobResponse is the response struct for api CreateFailoverTestJob
type CreateFailoverTestJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	JobId     string `json:"JobId" xml:"JobId"`
}

// CreateCreateFailoverTestJobRequest creates a request to invoke CreateFailoverTestJob API
func CreateCreateFailoverTestJobRequest() (request *CreateFailoverTestJobRequest) {
	request = &CreateFailoverTestJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "CreateFailoverTestJob", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateFailoverTestJobResponse creates a response to parse from CreateFailoverTestJob response
func CreateCreateFailoverTestJobResponse() (response *CreateFailoverTestJobResponse) {
	response = &CreateFailoverTestJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
