package videorecog

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateVideoCover invokes the videorecog.GenerateVideoCover API synchronously
func (client *Client) GenerateVideoCover(request *GenerateVideoCoverRequest) (response *GenerateVideoCoverResponse, err error) {
	response = CreateGenerateVideoCoverResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateVideoCoverWithChan invokes the videorecog.GenerateVideoCover API asynchronously
func (client *Client) GenerateVideoCoverWithChan(request *GenerateVideoCoverRequest) (<-chan *GenerateVideoCoverResponse, <-chan error) {
	responseChan := make(chan *GenerateVideoCoverResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateVideoCover(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateVideoCoverWithCallback invokes the videorecog.GenerateVideoCover API asynchronously
func (client *Client) GenerateVideoCoverWithCallback(request *GenerateVideoCoverRequest, callback func(response *GenerateVideoCoverResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateVideoCoverResponse
		var err error
		defer close(result)
		response, err = client.GenerateVideoCover(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateVideoCoverRequest is the request struct for api GenerateVideoCover
type GenerateVideoCoverRequest struct {
	*requests.RpcRequest
	IsGif    requests.Boolean `position:"Body" name:"IsGif"`
	Async    requests.Boolean `position:"Body" name:"Async"`
	VideoUrl string           `position:"Body" name:"VideoUrl"`
}

// GenerateVideoCoverResponse is the response struct for api GenerateVideoCover
type GenerateVideoCoverResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGenerateVideoCoverRequest creates a request to invoke GenerateVideoCover API
func CreateGenerateVideoCoverRequest() (request *GenerateVideoCoverRequest) {
	request = &GenerateVideoCoverRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("videorecog", "2020-03-20", "GenerateVideoCover", "videorecog", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGenerateVideoCoverResponse creates a response to parse from GenerateVideoCover response
func CreateGenerateVideoCoverResponse() (response *GenerateVideoCoverResponse) {
	response = &GenerateVideoCoverResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
