package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateService invokes the viapi_regen.CreateService API synchronously
func (client *Client) CreateService(request *CreateServiceRequest) (response *CreateServiceResponse, err error) {
	response = CreateCreateServiceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateServiceWithChan invokes the viapi_regen.CreateService API asynchronously
func (client *Client) CreateServiceWithChan(request *CreateServiceRequest) (<-chan *CreateServiceResponse, <-chan error) {
	responseChan := make(chan *CreateServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateServiceWithCallback invokes the viapi_regen.CreateService API asynchronously
func (client *Client) CreateServiceWithCallback(request *CreateServiceRequest, callback func(response *CreateServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateServiceResponse
		var err error
		defer close(result)
		response, err = client.CreateService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateServiceRequest is the request struct for api CreateService
type CreateServiceRequest struct {
	*requests.RpcRequest
	Description       string           `position:"Body" name:"Description"`
	TrainTaskId       requests.Integer `position:"Body" name:"TrainTaskId"`
	AuthorizationType string           `position:"Body" name:"AuthorizationType"`
	Name              string           `position:"Body" name:"Name"`
	AuthorizedAccount string           `position:"Body" name:"AuthorizedAccount"`
}

// CreateServiceResponse is the response struct for api CreateService
type CreateServiceResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateServiceRequest creates a request to invoke CreateService API
func CreateCreateServiceRequest() (request *CreateServiceRequest) {
	request = &CreateServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "CreateService", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateServiceResponse creates a response to parse from CreateService response
func CreateCreateServiceResponse() (response *CreateServiceResponse) {
	response = &CreateServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
