package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachKeyPair invokes the swas_open.AttachKeyPair API synchronously
func (client *Client) AttachKeyPair(request *AttachKeyPairRequest) (response *AttachKeyPairResponse, err error) {
	response = CreateAttachKeyPairResponse()
	err = client.DoAction(request, response)
	return
}

// AttachKeyPairWithChan invokes the swas_open.AttachKeyPair API asynchronously
func (client *Client) AttachKeyPairWithChan(request *AttachKeyPairRequest) (<-chan *AttachKeyPairResponse, <-chan error) {
	responseChan := make(chan *AttachKeyPairResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachKeyPair(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachKeyPairWithCallback invokes the swas_open.AttachKeyPair API asynchronously
func (client *Client) AttachKeyPairWithCallback(request *AttachKeyPairRequest, callback func(response *AttachKeyPairResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachKeyPairResponse
		var err error
		defer close(result)
		response, err = client.AttachKeyPair(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachKeyPairRequest is the request struct for api AttachKeyPair
type AttachKeyPairRequest struct {
	*requests.RpcRequest
	ClientToken string    `position:"Query" name:"ClientToken"`
	KeyPairName string    `position:"Query" name:"KeyPairName"`
	InstanceIds *[]string `position:"Query" name:"InstanceIds"  type:"Repeated"`
}

// AttachKeyPairResponse is the response struct for api AttachKeyPair
type AttachKeyPairResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	TotalCount int      `json:"TotalCount" xml:"TotalCount"`
	FailCount  int      `json:"FailCount" xml:"FailCount"`
	Results    []Result `json:"Results" xml:"Results"`
}

// CreateAttachKeyPairRequest creates a request to invoke AttachKeyPair API
func CreateAttachKeyPairRequest() (request *AttachKeyPairRequest) {
	request = &AttachKeyPairRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "AttachKeyPair", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAttachKeyPairResponse creates a response to parse from AttachKeyPair response
func CreateAttachKeyPairResponse() (response *AttachKeyPairResponse) {
	response = &AttachKeyPairResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
