package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateIngress invokes the sae.UpdateIngress API synchronously
func (client *Client) UpdateIngress(request *UpdateIngressRequest) (response *UpdateIngressResponse, err error) {
	response = CreateUpdateIngressResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateIngressWithChan invokes the sae.UpdateIngress API asynchronously
func (client *Client) UpdateIngressWithChan(request *UpdateIngressRequest) (<-chan *UpdateIngressResponse, <-chan error) {
	responseChan := make(chan *UpdateIngressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateIngress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateIngressWithCallback invokes the sae.UpdateIngress API asynchronously
func (client *Client) UpdateIngressWithCallback(request *UpdateIngressRequest, callback func(response *UpdateIngressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateIngressResponse
		var err error
		defer close(result)
		response, err = client.UpdateIngress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateIngressRequest is the request struct for api UpdateIngress
type UpdateIngressRequest struct {
	*requests.RoaRequest
	IngressId        requests.Integer `position:"Query" name:"IngressId"`
	ListenerPort     string           `position:"Query" name:"ListenerPort"`
	Description      string           `position:"Query" name:"Description"`
	LoadBalanceType  string           `position:"Query" name:"LoadBalanceType"`
	Rules            string           `position:"Body" name:"Rules"`
	CertId           string           `position:"Query" name:"CertId"`
	CertIds          string           `position:"Query" name:"CertIds"`
	ListenerProtocol string           `position:"Query" name:"ListenerProtocol"`
	DefaultRule      string           `position:"Query" name:"DefaultRule"`
}

// UpdateIngressResponse is the response struct for api UpdateIngress
type UpdateIngressResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateUpdateIngressRequest creates a request to invoke UpdateIngress API
func CreateUpdateIngressRequest() (request *UpdateIngressRequest) {
	request = &UpdateIngressRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "UpdateIngress", "/pop/v1/sam/ingress/Ingress", "serverless", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateIngressResponse creates a response to parse from UpdateIngress response
func CreateUpdateIngressResponse() (response *UpdateIngressResponse) {
	response = &UpdateIngressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
