package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTable invokes the retailadvqa_public.ListTable API synchronously
func (client *Client) ListTable(request *ListTableRequest) (response *ListTableResponse, err error) {
	response = CreateListTableResponse()
	err = client.DoAction(request, response)
	return
}

// ListTableWithChan invokes the retailadvqa_public.ListTable API asynchronously
func (client *Client) ListTableWithChan(request *ListTableRequest) (<-chan *ListTableResponse, <-chan error) {
	responseChan := make(chan *ListTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTableWithCallback invokes the retailadvqa_public.ListTable API asynchronously
func (client *Client) ListTableWithCallback(request *ListTableRequest, callback func(response *ListTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTableResponse
		var err error
		defer close(result)
		response, err = client.ListTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTableRequest is the request struct for api ListTable
type ListTableRequest struct {
	*requests.RpcRequest
	AccessId string `position:"Query" name:"AccessId"`
	TenantId string `position:"Query" name:"TenantId"`
}

// ListTableResponse is the response struct for api ListTable
type ListTableResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	ErrorDesc string     `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string     `json:"TraceId" xml:"TraceId"`
	ErrorCode string     `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool       `json:"Success" xml:"Success"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateListTableRequest creates a request to invoke ListTable API
func CreateListTableRequest() (request *ListTableRequest) {
	request = &ListTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "ListTable", "", "")
	request.Method = requests.POST
	return
}

// CreateListTableResponse creates a response to parse from ListTable response
func CreateListTableResponse() (response *ListTableResponse) {
	response = &ListTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
