package resourcecenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchResources invokes the resourcecenter.SearchResources API synchronously
func (client *Client) SearchResources(request *SearchResourcesRequest) (response *SearchResourcesResponse, err error) {
	response = CreateSearchResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// SearchResourcesWithChan invokes the resourcecenter.SearchResources API asynchronously
func (client *Client) SearchResourcesWithChan(request *SearchResourcesRequest) (<-chan *SearchResourcesResponse, <-chan error) {
	responseChan := make(chan *SearchResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchResourcesWithCallback invokes the resourcecenter.SearchResources API asynchronously
func (client *Client) SearchResourcesWithCallback(request *SearchResourcesRequest, callback func(response *SearchResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchResourcesResponse
		var err error
		defer close(result)
		response, err = client.SearchResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchResourcesRequest is the request struct for api SearchResources
type SearchResourcesRequest struct {
	*requests.RpcRequest
	ResourceGroupId string                       `position:"Query" name:"ResourceGroupId"`
	View            string                       `position:"Query" name:"View"`
	NextToken       string                       `position:"Query" name:"NextToken"`
	SortCriterion   SearchResourcesSortCriterion `position:"Query" name:"SortCriterion"  type:"Struct"`
	Filter          *[]SearchResourcesFilter     `position:"Query" name:"Filter"  type:"Repeated"`
	MaxResults      requests.Integer             `position:"Query" name:"MaxResults"`
}

// SearchResourcesSortCriterion is a repeated param struct in SearchResourcesRequest
type SearchResourcesSortCriterion struct {
	Key   string `name:"Key"`
	Order string `name:"Order"`
}

// SearchResourcesFilter is a repeated param struct in SearchResourcesRequest
type SearchResourcesFilter struct {
	MatchType string    `name:"MatchType"`
	Value     *[]string `name:"Value" type:"Repeated"`
	Key       string    `name:"Key"`
}

// SearchResourcesResponse is the response struct for api SearchResources
type SearchResourcesResponse struct {
	*responses.BaseResponse
	NextToken  string     `json:"NextToken" xml:"NextToken"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	MaxResults int        `json:"MaxResults" xml:"MaxResults"`
	Filters    []Filter   `json:"Filters" xml:"Filters"`
	Resources  []Resource `json:"Resources" xml:"Resources"`
}

// CreateSearchResourcesRequest creates a request to invoke SearchResources API
func CreateSearchResourcesRequest() (request *SearchResourcesRequest) {
	request = &SearchResourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceCenter", "2022-12-01", "SearchResources", "", "")
	request.Method = requests.POST
	return
}

// CreateSearchResourcesResponse creates a response to parse from SearchResources response
func CreateSearchResourcesResponse() (response *SearchResourcesResponse) {
	response = &SearchResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
