package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyAccountMaskingPrivilege invokes the rds.ModifyAccountMaskingPrivilege API synchronously
func (client *Client) ModifyAccountMaskingPrivilege(request *ModifyAccountMaskingPrivilegeRequest) (response *ModifyAccountMaskingPrivilegeResponse, err error) {
	response = CreateModifyAccountMaskingPrivilegeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyAccountMaskingPrivilegeWithChan invokes the rds.ModifyAccountMaskingPrivilege API asynchronously
func (client *Client) ModifyAccountMaskingPrivilegeWithChan(request *ModifyAccountMaskingPrivilegeRequest) (<-chan *ModifyAccountMaskingPrivilegeResponse, <-chan error) {
	responseChan := make(chan *ModifyAccountMaskingPrivilegeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyAccountMaskingPrivilege(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyAccountMaskingPrivilegeWithCallback invokes the rds.ModifyAccountMaskingPrivilege API asynchronously
func (client *Client) ModifyAccountMaskingPrivilegeWithCallback(request *ModifyAccountMaskingPrivilegeRequest, callback func(response *ModifyAccountMaskingPrivilegeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyAccountMaskingPrivilegeResponse
		var err error
		defer close(result)
		response, err = client.ModifyAccountMaskingPrivilege(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyAccountMaskingPrivilegeRequest is the request struct for api ModifyAccountMaskingPrivilege
type ModifyAccountMaskingPrivilegeRequest struct {
	*requests.RpcRequest
	DBInstanceName       string           `position:"Query" name:"DBInstanceName"`
	ExpireTime           string           `position:"Query" name:"ExpireTime"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	Privilege            string           `position:"Query" name:"Privilege"`
	OwnerId              string           `position:"Query" name:"OwnerId"`
	UserName             string           `position:"Query" name:"UserName"`
}

// ModifyAccountMaskingPrivilegeResponse is the response struct for api ModifyAccountMaskingPrivilege
type ModifyAccountMaskingPrivilegeResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Success   string                 `json:"Success" xml:"Success"`
	Message   string                 `json:"Message" xml:"Message"`
	Data      map[string]interface{} `json:"Data" xml:"Data"`
}

// CreateModifyAccountMaskingPrivilegeRequest creates a request to invoke ModifyAccountMaskingPrivilege API
func CreateModifyAccountMaskingPrivilegeRequest() (request *ModifyAccountMaskingPrivilegeRequest) {
	request = &ModifyAccountMaskingPrivilegeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "ModifyAccountMaskingPrivilege", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyAccountMaskingPrivilegeResponse creates a response to parse from ModifyAccountMaskingPrivilege response
func CreateModifyAccountMaskingPrivilegeResponse() (response *ModifyAccountMaskingPrivilegeResponse) {
	response = &ModifyAccountMaskingPrivilegeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
