package quotas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetQuotaAlarm invokes the quotas.GetQuotaAlarm API synchronously
func (client *Client) GetQuotaAlarm(request *GetQuotaAlarmRequest) (response *GetQuotaAlarmResponse, err error) {
	response = CreateGetQuotaAlarmResponse()
	err = client.DoAction(request, response)
	return
}

// GetQuotaAlarmWithChan invokes the quotas.GetQuotaAlarm API asynchronously
func (client *Client) GetQuotaAlarmWithChan(request *GetQuotaAlarmRequest) (<-chan *GetQuotaAlarmResponse, <-chan error) {
	responseChan := make(chan *GetQuotaAlarmResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetQuotaAlarm(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetQuotaAlarmWithCallback invokes the quotas.GetQuotaAlarm API asynchronously
func (client *Client) GetQuotaAlarmWithCallback(request *GetQuotaAlarmRequest, callback func(response *GetQuotaAlarmResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetQuotaAlarmResponse
		var err error
		defer close(result)
		response, err = client.GetQuotaAlarm(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetQuotaAlarmRequest is the request struct for api GetQuotaAlarm
type GetQuotaAlarmRequest struct {
	*requests.RpcRequest
	OriginalContext string `position:"Body" name:"OriginalContext"`
	AlarmId         string `position:"Body" name:"AlarmId"`
}

// GetQuotaAlarmResponse is the response struct for api GetQuotaAlarm
type GetQuotaAlarmResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	QuotaAlarm QuotaAlarm `json:"QuotaAlarm" xml:"QuotaAlarm"`
}

// CreateGetQuotaAlarmRequest creates a request to invoke GetQuotaAlarm API
func CreateGetQuotaAlarmRequest() (request *GetQuotaAlarmRequest) {
	request = &GetQuotaAlarmRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quotas", "2020-05-10", "GetQuotaAlarm", "quotas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetQuotaAlarmResponse creates a response to parse from GetQuotaAlarm response
func CreateGetQuotaAlarmResponse() (response *GetQuotaAlarmResponse) {
	response = &GetQuotaAlarmResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
