package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDatasetList invokes the quickbi_public.QueryDatasetList API synchronously
func (client *Client) QueryDatasetList(request *QueryDatasetListRequest) (response *QueryDatasetListResponse, err error) {
	response = CreateQueryDatasetListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDatasetListWithChan invokes the quickbi_public.QueryDatasetList API asynchronously
func (client *Client) QueryDatasetListWithChan(request *QueryDatasetListRequest) (<-chan *QueryDatasetListResponse, <-chan error) {
	responseChan := make(chan *QueryDatasetListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDatasetList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDatasetListWithCallback invokes the quickbi_public.QueryDatasetList API asynchronously
func (client *Client) QueryDatasetListWithCallback(request *QueryDatasetListRequest, callback func(response *QueryDatasetListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDatasetListResponse
		var err error
		defer close(result)
		response, err = client.QueryDatasetList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDatasetListRequest is the request struct for api QueryDatasetList
type QueryDatasetListRequest struct {
	*requests.RpcRequest
	AccessPoint  string           `position:"Query" name:"AccessPoint"`
	PageNum      requests.Integer `position:"Query" name:"PageNum"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	DirectoryId  string           `position:"Query" name:"DirectoryId"`
	WithChildren requests.Boolean `position:"Query" name:"WithChildren"`
	Keyword      string           `position:"Query" name:"Keyword"`
	SignType     string           `position:"Query" name:"SignType"`
	WorkspaceId  string           `position:"Query" name:"WorkspaceId"`
}

// QueryDatasetListResponse is the response struct for api QueryDatasetList
type QueryDatasetListResponse struct {
	*responses.BaseResponse
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Success   bool                     `json:"Success" xml:"Success"`
	Result    ResultInQueryDatasetList `json:"Result" xml:"Result"`
}

// CreateQueryDatasetListRequest creates a request to invoke QueryDatasetList API
func CreateQueryDatasetListRequest() (request *QueryDatasetListRequest) {
	request = &QueryDatasetListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "QueryDatasetList", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryDatasetListResponse creates a response to parse from QueryDatasetList response
func CreateQueryDatasetListResponse() (response *QueryDatasetListResponse) {
	response = &QueryDatasetListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
