package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCubeDataLevelPermissionConfig invokes the quickbi_public.ListCubeDataLevelPermissionConfig API synchronously
func (client *Client) ListCubeDataLevelPermissionConfig(request *ListCubeDataLevelPermissionConfigRequest) (response *ListCubeDataLevelPermissionConfigResponse, err error) {
	response = CreateListCubeDataLevelPermissionConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ListCubeDataLevelPermissionConfigWithChan invokes the quickbi_public.ListCubeDataLevelPermissionConfig API asynchronously
func (client *Client) ListCubeDataLevelPermissionConfigWithChan(request *ListCubeDataLevelPermissionConfigRequest) (<-chan *ListCubeDataLevelPermissionConfigResponse, <-chan error) {
	responseChan := make(chan *ListCubeDataLevelPermissionConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCubeDataLevelPermissionConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCubeDataLevelPermissionConfigWithCallback invokes the quickbi_public.ListCubeDataLevelPermissionConfig API asynchronously
func (client *Client) ListCubeDataLevelPermissionConfigWithCallback(request *ListCubeDataLevelPermissionConfigRequest, callback func(response *ListCubeDataLevelPermissionConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCubeDataLevelPermissionConfigResponse
		var err error
		defer close(result)
		response, err = client.ListCubeDataLevelPermissionConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCubeDataLevelPermissionConfigRequest is the request struct for api ListCubeDataLevelPermissionConfig
type ListCubeDataLevelPermissionConfigRequest struct {
	*requests.RpcRequest
	RuleType    string `position:"Query" name:"RuleType"`
	AccessPoint string `position:"Query" name:"AccessPoint"`
	SignType    string `position:"Query" name:"SignType"`
	CubeId      string `position:"Query" name:"CubeId"`
}

// ListCubeDataLevelPermissionConfigResponse is the response struct for api ListCubeDataLevelPermissionConfig
type ListCubeDataLevelPermissionConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateListCubeDataLevelPermissionConfigRequest creates a request to invoke ListCubeDataLevelPermissionConfig API
func CreateListCubeDataLevelPermissionConfigRequest() (request *ListCubeDataLevelPermissionConfigRequest) {
	request = &ListCubeDataLevelPermissionConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "ListCubeDataLevelPermissionConfig", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListCubeDataLevelPermissionConfigResponse creates a response to parse from ListCubeDataLevelPermissionConfig response
func CreateListCubeDataLevelPermissionConfigResponse() (response *ListCubeDataLevelPermissionConfigResponse) {
	response = &ListCubeDataLevelPermissionConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
