package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateActivationCode invokes the polardb.CreateActivationCode API synchronously
func (client *Client) CreateActivationCode(request *CreateActivationCodeRequest) (response *CreateActivationCodeResponse, err error) {
	response = CreateCreateActivationCodeResponse()
	err = client.DoAction(request, response)
	return
}

// CreateActivationCodeWithChan invokes the polardb.CreateActivationCode API asynchronously
func (client *Client) CreateActivationCodeWithChan(request *CreateActivationCodeRequest) (<-chan *CreateActivationCodeResponse, <-chan error) {
	responseChan := make(chan *CreateActivationCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateActivationCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateActivationCodeWithCallback invokes the polardb.CreateActivationCode API asynchronously
func (client *Client) CreateActivationCodeWithCallback(request *CreateActivationCodeRequest, callback func(response *CreateActivationCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateActivationCodeResponse
		var err error
		defer close(result)
		response, err = client.CreateActivationCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateActivationCodeRequest is the request struct for api CreateActivationCode
type CreateActivationCodeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Description          string           `position:"Query" name:"Description"`
	AliyunOrderId        string           `position:"Query" name:"AliyunOrderId"`
	MacAddress           string           `position:"Query" name:"MacAddress"`
	SystemIdentifier     string           `position:"Query" name:"SystemIdentifier"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Name                 string           `position:"Query" name:"Name"`
}

// CreateActivationCodeResponse is the response struct for api CreateActivationCode
type CreateActivationCodeResponse struct {
	*responses.BaseResponse
	ActivateAt       string `json:"ActivateAt" xml:"ActivateAt"`
	CertContentB64   string `json:"CertContentB64" xml:"CertContentB64"`
	Description      string `json:"Description" xml:"Description"`
	ExpireAt         string `json:"ExpireAt" xml:"ExpireAt"`
	GmtCreated       string `json:"GmtCreated" xml:"GmtCreated"`
	GmtModified      string `json:"GmtModified" xml:"GmtModified"`
	Id               int    `json:"Id" xml:"Id"`
	MacAddress       string `json:"MacAddress" xml:"MacAddress"`
	Name             string `json:"Name" xml:"Name"`
	RequestId        string `json:"RequestId" xml:"RequestId"`
	SystemIdentifier string `json:"SystemIdentifier" xml:"SystemIdentifier"`
}

// CreateCreateActivationCodeRequest creates a request to invoke CreateActivationCode API
func CreateCreateActivationCodeRequest() (request *CreateActivationCodeRequest) {
	request = &CreateActivationCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "CreateActivationCode", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateActivationCodeResponse creates a response to parse from CreateActivationCode response
func CreateCreateActivationCodeResponse() (response *CreateActivationCodeResponse) {
	response = &CreateActivationCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
