package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopTrafficControlTask invokes the pairecservice.StopTrafficControlTask API synchronously
func (client *Client) StopTrafficControlTask(request *StopTrafficControlTaskRequest) (response *StopTrafficControlTaskResponse, err error) {
	response = CreateStopTrafficControlTaskResponse()
	err = client.DoAction(request, response)
	return
}

// StopTrafficControlTaskWithChan invokes the pairecservice.StopTrafficControlTask API asynchronously
func (client *Client) StopTrafficControlTaskWithChan(request *StopTrafficControlTaskRequest) (<-chan *StopTrafficControlTaskResponse, <-chan error) {
	responseChan := make(chan *StopTrafficControlTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopTrafficControlTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopTrafficControlTaskWithCallback invokes the pairecservice.StopTrafficControlTask API asynchronously
func (client *Client) StopTrafficControlTaskWithCallback(request *StopTrafficControlTaskRequest, callback func(response *StopTrafficControlTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopTrafficControlTaskResponse
		var err error
		defer close(result)
		response, err = client.StopTrafficControlTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopTrafficControlTaskRequest is the request struct for api StopTrafficControlTask
type StopTrafficControlTaskRequest struct {
	*requests.RoaRequest
	TrafficControlTaskId string `position:"Path" name:"TrafficControlTaskId"`
	Body                 string `position:"Body" name:"body"`
}

// StopTrafficControlTaskResponse is the response struct for api StopTrafficControlTask
type StopTrafficControlTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopTrafficControlTaskRequest creates a request to invoke StopTrafficControlTask API
func CreateStopTrafficControlTaskRequest() (request *StopTrafficControlTaskRequest) {
	request = &StopTrafficControlTaskRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "StopTrafficControlTask", "/api/v1/trafficcontroltasks/[TrafficControlTaskId]/action/stop", "", "")
	request.Method = requests.POST
	return
}

// CreateStopTrafficControlTaskResponse creates a response to parse from StopTrafficControlTask response
func CreateStopTrafficControlTaskResponse() (response *StopTrafficControlTaskResponse) {
	response = &StopTrafficControlTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
