package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateTrafficControlTaskCode invokes the pairecservice.GenerateTrafficControlTaskCode API synchronously
func (client *Client) GenerateTrafficControlTaskCode(request *GenerateTrafficControlTaskCodeRequest) (response *GenerateTrafficControlTaskCodeResponse, err error) {
	response = CreateGenerateTrafficControlTaskCodeResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateTrafficControlTaskCodeWithChan invokes the pairecservice.GenerateTrafficControlTaskCode API asynchronously
func (client *Client) GenerateTrafficControlTaskCodeWithChan(request *GenerateTrafficControlTaskCodeRequest) (<-chan *GenerateTrafficControlTaskCodeResponse, <-chan error) {
	responseChan := make(chan *GenerateTrafficControlTaskCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateTrafficControlTaskCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateTrafficControlTaskCodeWithCallback invokes the pairecservice.GenerateTrafficControlTaskCode API asynchronously
func (client *Client) GenerateTrafficControlTaskCodeWithCallback(request *GenerateTrafficControlTaskCodeRequest, callback func(response *GenerateTrafficControlTaskCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateTrafficControlTaskCodeResponse
		var err error
		defer close(result)
		response, err = client.GenerateTrafficControlTaskCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateTrafficControlTaskCodeRequest is the request struct for api GenerateTrafficControlTaskCode
type GenerateTrafficControlTaskCodeRequest struct {
	*requests.RoaRequest
	TrafficControlTaskId string `position:"Path" name:"TrafficControlTaskId"`
	Body                 string `position:"Body" name:"body"`
}

// GenerateTrafficControlTaskCodeResponse is the response struct for api GenerateTrafficControlTaskCode
type GenerateTrafficControlTaskCodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
}

// CreateGenerateTrafficControlTaskCodeRequest creates a request to invoke GenerateTrafficControlTaskCode API
func CreateGenerateTrafficControlTaskCodeRequest() (request *GenerateTrafficControlTaskCodeRequest) {
	request = &GenerateTrafficControlTaskCodeRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "GenerateTrafficControlTaskCode", "/api/v1/trafficcontroltasks/[TrafficControlTaskId]/action/generatecode", "", "")
	request.Method = requests.POST
	return
}

// CreateGenerateTrafficControlTaskCodeResponse creates a response to parse from GenerateTrafficControlTaskCode response
func CreateGenerateTrafficControlTaskCodeResponse() (response *GenerateTrafficControlTaskCodeResponse) {
	response = &GenerateTrafficControlTaskCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
