package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteApplicationGroup invokes the oos.DeleteApplicationGroup API synchronously
func (client *Client) DeleteApplicationGroup(request *DeleteApplicationGroupRequest) (response *DeleteApplicationGroupResponse, err error) {
	response = CreateDeleteApplicationGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteApplicationGroupWithChan invokes the oos.DeleteApplicationGroup API asynchronously
func (client *Client) DeleteApplicationGroupWithChan(request *DeleteApplicationGroupRequest) (<-chan *DeleteApplicationGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteApplicationGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteApplicationGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteApplicationGroupWithCallback invokes the oos.DeleteApplicationGroup API asynchronously
func (client *Client) DeleteApplicationGroupWithCallback(request *DeleteApplicationGroupRequest, callback func(response *DeleteApplicationGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteApplicationGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteApplicationGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteApplicationGroupRequest is the request struct for api DeleteApplicationGroup
type DeleteApplicationGroupRequest struct {
	*requests.RpcRequest
	RetainResource  requests.Boolean `position:"Query" name:"RetainResource"`
	ApplicationName string           `position:"Query" name:"ApplicationName"`
	Name            string           `position:"Query" name:"Name"`
}

// DeleteApplicationGroupResponse is the response struct for api DeleteApplicationGroup
type DeleteApplicationGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteApplicationGroupRequest creates a request to invoke DeleteApplicationGroup API
func CreateDeleteApplicationGroupRequest() (request *DeleteApplicationGroupRequest) {
	request = &DeleteApplicationGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "DeleteApplicationGroup", "oos", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteApplicationGroupResponse creates a response to parse from DeleteApplicationGroup response
func CreateDeleteApplicationGroupResponse() (response *DeleteApplicationGroupResponse) {
	response = &DeleteApplicationGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
