package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopProjectModifyRecords invokes the oceanbasepro.StopProjectModifyRecords API synchronously
func (client *Client) StopProjectModifyRecords(request *StopProjectModifyRecordsRequest) (response *StopProjectModifyRecordsResponse, err error) {
	response = CreateStopProjectModifyRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// StopProjectModifyRecordsWithChan invokes the oceanbasepro.StopProjectModifyRecords API asynchronously
func (client *Client) StopProjectModifyRecordsWithChan(request *StopProjectModifyRecordsRequest) (<-chan *StopProjectModifyRecordsResponse, <-chan error) {
	responseChan := make(chan *StopProjectModifyRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopProjectModifyRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopProjectModifyRecordsWithCallback invokes the oceanbasepro.StopProjectModifyRecords API asynchronously
func (client *Client) StopProjectModifyRecordsWithCallback(request *StopProjectModifyRecordsRequest, callback func(response *StopProjectModifyRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopProjectModifyRecordsResponse
		var err error
		defer close(result)
		response, err = client.StopProjectModifyRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopProjectModifyRecordsRequest is the request struct for api StopProjectModifyRecords
type StopProjectModifyRecordsRequest struct {
	*requests.RpcRequest
	Id string `position:"Body" name:"Id"`
}

// StopProjectModifyRecordsResponse is the response struct for api StopProjectModifyRecords
type StopProjectModifyRecordsResponse struct {
	*responses.BaseResponse
}

// CreateStopProjectModifyRecordsRequest creates a request to invoke StopProjectModifyRecords API
func CreateStopProjectModifyRecordsRequest() (request *StopProjectModifyRecordsRequest) {
	request = &StopProjectModifyRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "StopProjectModifyRecords", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopProjectModifyRecordsResponse creates a response to parse from StopProjectModifyRecords response
func CreateStopProjectModifyRecordsResponse() (response *StopProjectModifyRecordsResponse) {
	response = &StopProjectModifyRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
