package nis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateNetworkReachableAnalysis invokes the nis.CreateNetworkReachableAnalysis API synchronously
func (client *Client) CreateNetworkReachableAnalysis(request *CreateNetworkReachableAnalysisRequest) (response *CreateNetworkReachableAnalysisResponse, err error) {
	response = CreateCreateNetworkReachableAnalysisResponse()
	err = client.DoAction(request, response)
	return
}

// CreateNetworkReachableAnalysisWithChan invokes the nis.CreateNetworkReachableAnalysis API asynchronously
func (client *Client) CreateNetworkReachableAnalysisWithChan(request *CreateNetworkReachableAnalysisRequest) (<-chan *CreateNetworkReachableAnalysisResponse, <-chan error) {
	responseChan := make(chan *CreateNetworkReachableAnalysisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateNetworkReachableAnalysis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateNetworkReachableAnalysisWithCallback invokes the nis.CreateNetworkReachableAnalysis API asynchronously
func (client *Client) CreateNetworkReachableAnalysisWithCallback(request *CreateNetworkReachableAnalysisRequest, callback func(response *CreateNetworkReachableAnalysisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateNetworkReachableAnalysisResponse
		var err error
		defer close(result)
		response, err = client.CreateNetworkReachableAnalysis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateNetworkReachableAnalysisRequest is the request struct for api CreateNetworkReachableAnalysis
type CreateNetworkReachableAnalysisRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer                           `position:"Query" name:"ResourceOwnerId"`
	DryRun          requests.Boolean                           `position:"Query" name:"DryRun"`
	ClientToken     string                                     `position:"Query" name:"ClientToken"`
	SystemTag       *[]CreateNetworkReachableAnalysisSystemTag `position:"Query" name:"SystemTag"  type:"Repeated"`
	NetworkPathId   string                                     `position:"Query" name:"NetworkPathId"`
	AuditParam      string                                     `position:"Query" name:"AuditParam"`
	Tag             *[]CreateNetworkReachableAnalysisTag       `position:"Query" name:"Tag"  type:"Repeated"`
}

// CreateNetworkReachableAnalysisSystemTag is a repeated param struct in CreateNetworkReachableAnalysisRequest
type CreateNetworkReachableAnalysisSystemTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
	Scope string `name:"Scope"`
}

// CreateNetworkReachableAnalysisTag is a repeated param struct in CreateNetworkReachableAnalysisRequest
type CreateNetworkReachableAnalysisTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// CreateNetworkReachableAnalysisResponse is the response struct for api CreateNetworkReachableAnalysis
type CreateNetworkReachableAnalysisResponse struct {
	*responses.BaseResponse
	NetworkReachableAnalysisId string `json:"NetworkReachableAnalysisId" xml:"NetworkReachableAnalysisId"`
	RequestId                  string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateNetworkReachableAnalysisRequest creates a request to invoke CreateNetworkReachableAnalysis API
func CreateCreateNetworkReachableAnalysisRequest() (request *CreateNetworkReachableAnalysisRequest) {
	request = &CreateNetworkReachableAnalysisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("nis", "2021-12-16", "CreateNetworkReachableAnalysis", "networkana", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateNetworkReachableAnalysisResponse creates a response to parse from CreateNetworkReachableAnalysis response
func CreateCreateNetworkReachableAnalysisResponse() (response *CreateNetworkReachableAnalysisResponse) {
	response = &CreateNetworkReachableAnalysisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
