package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloneSentinelRuleFromAhas invokes the mse.CloneSentinelRuleFromAhas API synchronously
func (client *Client) CloneSentinelRuleFromAhas(request *CloneSentinelRuleFromAhasRequest) (response *CloneSentinelRuleFromAhasResponse, err error) {
	response = CreateCloneSentinelRuleFromAhasResponse()
	err = client.DoAction(request, response)
	return
}

// CloneSentinelRuleFromAhasWithChan invokes the mse.CloneSentinelRuleFromAhas API asynchronously
func (client *Client) CloneSentinelRuleFromAhasWithChan(request *CloneSentinelRuleFromAhasRequest) (<-chan *CloneSentinelRuleFromAhasResponse, <-chan error) {
	responseChan := make(chan *CloneSentinelRuleFromAhasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloneSentinelRuleFromAhas(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloneSentinelRuleFromAhasWithCallback invokes the mse.CloneSentinelRuleFromAhas API asynchronously
func (client *Client) CloneSentinelRuleFromAhasWithCallback(request *CloneSentinelRuleFromAhasRequest, callback func(response *CloneSentinelRuleFromAhasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloneSentinelRuleFromAhasResponse
		var err error
		defer close(result)
		response, err = client.CloneSentinelRuleFromAhas(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloneSentinelRuleFromAhasRequest is the request struct for api CloneSentinelRuleFromAhas
type CloneSentinelRuleFromAhasRequest struct {
	*requests.RpcRequest
	MseSessionId         string           `position:"Query" name:"MseSessionId"`
	NeedRemoveRestPrefix requests.Boolean `position:"Query" name:"NeedRemoveRestPrefix"`
	AppName              string           `position:"Query" name:"AppName"`
	Namespace            string           `position:"Query" name:"Namespace"`
	IsAHASPublicRegion   requests.Boolean `position:"Query" name:"IsAHASPublicRegion"`
	AcceptLanguage       string           `position:"Query" name:"AcceptLanguage"`
	AhasNamespace        string           `position:"Query" name:"AhasNamespace"`
}

// CloneSentinelRuleFromAhasResponse is the response struct for api CloneSentinelRuleFromAhas
type CloneSentinelRuleFromAhasResponse struct {
	*responses.BaseResponse
}

// CreateCloneSentinelRuleFromAhasRequest creates a request to invoke CloneSentinelRuleFromAhas API
func CreateCloneSentinelRuleFromAhasRequest() (request *CloneSentinelRuleFromAhasRequest) {
	request = &CloneSentinelRuleFromAhasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "CloneSentinelRuleFromAhas", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCloneSentinelRuleFromAhasResponse creates a response to parse from CloneSentinelRuleFromAhas response
func CreateCloneSentinelRuleFromAhasResponse() (response *CloneSentinelRuleFromAhasResponse) {
	response = &CloneSentinelRuleFromAhasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
