package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMappCenterApps invokes the mpaas.ListMappCenterApps API synchronously
func (client *Client) ListMappCenterApps(request *ListMappCenterAppsRequest) (response *ListMappCenterAppsResponse, err error) {
	response = CreateListMappCenterAppsResponse()
	err = client.DoAction(request, response)
	return
}

// ListMappCenterAppsWithChan invokes the mpaas.ListMappCenterApps API asynchronously
func (client *Client) ListMappCenterAppsWithChan(request *ListMappCenterAppsRequest) (<-chan *ListMappCenterAppsResponse, <-chan error) {
	responseChan := make(chan *ListMappCenterAppsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMappCenterApps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMappCenterAppsWithCallback invokes the mpaas.ListMappCenterApps API asynchronously
func (client *Client) ListMappCenterAppsWithCallback(request *ListMappCenterAppsRequest, callback func(response *ListMappCenterAppsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMappCenterAppsResponse
		var err error
		defer close(result)
		response, err = client.ListMappCenterApps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMappCenterAppsRequest is the request struct for api ListMappCenterApps
type ListMappCenterAppsRequest struct {
	*requests.RpcRequest
}

// ListMappCenterAppsResponse is the response struct for api ListMappCenterApps
type ListMappCenterAppsResponse struct {
	*responses.BaseResponse
	ResultMessage           string                  `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode              string                  `json:"ResultCode" xml:"ResultCode"`
	RequestId               string                  `json:"RequestId" xml:"RequestId"`
	ListMappCenterAppResult ListMappCenterAppResult `json:"ListMappCenterAppResult" xml:"ListMappCenterAppResult"`
}

// CreateListMappCenterAppsRequest creates a request to invoke ListMappCenterApps API
func CreateListMappCenterAppsRequest() (request *ListMappCenterAppsRequest) {
	request = &ListMappCenterAppsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "ListMappCenterApps", "", "")
	request.Method = requests.POST
	return
}

// CreateListMappCenterAppsResponse creates a response to parse from ListMappCenterApps response
func CreateListMappCenterAppsResponse() (response *ListMappCenterAppsResponse) {
	response = &ListMappCenterAppsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
