package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMcdpAim invokes the mpaas.DeleteMcdpAim API synchronously
func (client *Client) DeleteMcdpAim(request *DeleteMcdpAimRequest) (response *DeleteMcdpAimResponse, err error) {
	response = CreateDeleteMcdpAimResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMcdpAimWithChan invokes the mpaas.DeleteMcdpAim API asynchronously
func (client *Client) DeleteMcdpAimWithChan(request *DeleteMcdpAimRequest) (<-chan *DeleteMcdpAimResponse, <-chan error) {
	responseChan := make(chan *DeleteMcdpAimResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMcdpAim(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMcdpAimWithCallback invokes the mpaas.DeleteMcdpAim API asynchronously
func (client *Client) DeleteMcdpAimWithCallback(request *DeleteMcdpAimRequest, callback func(response *DeleteMcdpAimResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMcdpAimResponse
		var err error
		defer close(result)
		response, err = client.DeleteMcdpAim(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMcdpAimRequest is the request struct for api DeleteMcdpAim
type DeleteMcdpAimRequest struct {
	*requests.RpcRequest
	TenantId                            string `position:"Body" name:"TenantId"`
	MpaasMappcenterMcdpAimDeleteJsonStr string `position:"Body" name:"MpaasMappcenterMcdpAimDeleteJsonStr"`
	AppId                               string `position:"Body" name:"AppId"`
	WorkspaceId                         string `position:"Body" name:"WorkspaceId"`
}

// DeleteMcdpAimResponse is the response struct for api DeleteMcdpAim
type DeleteMcdpAimResponse struct {
	*responses.BaseResponse
	ResultMessage string                       `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                       `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                       `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInDeleteMcdpAim `json:"ResultContent" xml:"ResultContent"`
}

// CreateDeleteMcdpAimRequest creates a request to invoke DeleteMcdpAim API
func CreateDeleteMcdpAimRequest() (request *DeleteMcdpAimRequest) {
	request = &DeleteMcdpAimRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "DeleteMcdpAim", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteMcdpAimResponse creates a response to parse from DeleteMcdpAim response
func CreateDeleteMcdpAimResponse() (response *DeleteMcdpAimResponse) {
	response = &DeleteMcdpAimResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
