package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMsacStageInstance invokes the mpaas.CreateMsacStageInstance API synchronously
func (client *Client) CreateMsacStageInstance(request *CreateMsacStageInstanceRequest) (response *CreateMsacStageInstanceResponse, err error) {
	response = CreateCreateMsacStageInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMsacStageInstanceWithChan invokes the mpaas.CreateMsacStageInstance API asynchronously
func (client *Client) CreateMsacStageInstanceWithChan(request *CreateMsacStageInstanceRequest) (<-chan *CreateMsacStageInstanceResponse, <-chan error) {
	responseChan := make(chan *CreateMsacStageInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMsacStageInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMsacStageInstanceWithCallback invokes the mpaas.CreateMsacStageInstance API asynchronously
func (client *Client) CreateMsacStageInstanceWithCallback(request *CreateMsacStageInstanceRequest, callback func(response *CreateMsacStageInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMsacStageInstanceResponse
		var err error
		defer close(result)
		response, err = client.CreateMsacStageInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMsacStageInstanceRequest is the request struct for api CreateMsacStageInstance
type CreateMsacStageInstanceRequest struct {
	*requests.RpcRequest
	TenantId                                      string `position:"Body" name:"TenantId"`
	MpaasMappcenterMsacCreateStageInstanceJsonStr string `position:"Body" name:"MpaasMappcenterMsacCreateStageInstanceJsonStr"`
	AppId                                         string `position:"Body" name:"AppId"`
	WorkspaceId                                   string `position:"Body" name:"WorkspaceId"`
}

// CreateMsacStageInstanceResponse is the response struct for api CreateMsacStageInstance
type CreateMsacStageInstanceResponse struct {
	*responses.BaseResponse
	ResultMessage string                                 `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                                 `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                                 `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInCreateMsacStageInstance `json:"ResultContent" xml:"ResultContent"`
}

// CreateCreateMsacStageInstanceRequest creates a request to invoke CreateMsacStageInstance API
func CreateCreateMsacStageInstanceRequest() (request *CreateMsacStageInstanceRequest) {
	request = &CreateMsacStageInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "CreateMsacStageInstance", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMsacStageInstanceResponse creates a response to parse from CreateMsacStageInstance response
func CreateCreateMsacStageInstanceResponse() (response *CreateMsacStageInstanceResponse) {
	response = &CreateMsacStageInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
