package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelPushScheduler invokes the mpaas.CancelPushScheduler API synchronously
func (client *Client) CancelPushScheduler(request *CancelPushSchedulerRequest) (response *CancelPushSchedulerResponse, err error) {
	response = CreateCancelPushSchedulerResponse()
	err = client.DoAction(request, response)
	return
}

// CancelPushSchedulerWithChan invokes the mpaas.CancelPushScheduler API asynchronously
func (client *Client) CancelPushSchedulerWithChan(request *CancelPushSchedulerRequest) (<-chan *CancelPushSchedulerResponse, <-chan error) {
	responseChan := make(chan *CancelPushSchedulerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelPushScheduler(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelPushSchedulerWithCallback invokes the mpaas.CancelPushScheduler API asynchronously
func (client *Client) CancelPushSchedulerWithCallback(request *CancelPushSchedulerRequest, callback func(response *CancelPushSchedulerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelPushSchedulerResponse
		var err error
		defer close(result)
		response, err = client.CancelPushScheduler(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelPushSchedulerRequest is the request struct for api CancelPushScheduler
type CancelPushSchedulerRequest struct {
	*requests.RpcRequest
	Type        requests.Integer `position:"Body" name:"Type"`
	UniqueIds   string           `position:"Body" name:"UniqueIds"`
	AppId       string           `position:"Body" name:"AppId"`
	WorkspaceId string           `position:"Body" name:"WorkspaceId"`
}

// CancelPushSchedulerResponse is the response struct for api CancelPushScheduler
type CancelPushSchedulerResponse struct {
	*responses.BaseResponse
	ResultMessage string `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string `json:"ResultCode" xml:"ResultCode"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ResultContent string `json:"ResultContent" xml:"ResultContent"`
}

// CreateCancelPushSchedulerRequest creates a request to invoke CancelPushScheduler API
func CreateCancelPushSchedulerRequest() (request *CancelPushSchedulerRequest) {
	request = &CancelPushSchedulerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "CancelPushScheduler", "", "")
	request.Method = requests.POST
	return
}

// CreateCancelPushSchedulerResponse creates a response to parse from CancelPushScheduler response
func CreateCancelPushSchedulerResponse() (response *CancelPushSchedulerResponse) {
	response = &CancelPushSchedulerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
