package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBizChainStatInfo invokes the lto.DescribeBizChainStatInfo API synchronously
func (client *Client) DescribeBizChainStatInfo(request *DescribeBizChainStatInfoRequest) (response *DescribeBizChainStatInfoResponse, err error) {
	response = CreateDescribeBizChainStatInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBizChainStatInfoWithChan invokes the lto.DescribeBizChainStatInfo API asynchronously
func (client *Client) DescribeBizChainStatInfoWithChan(request *DescribeBizChainStatInfoRequest) (<-chan *DescribeBizChainStatInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeBizChainStatInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBizChainStatInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBizChainStatInfoWithCallback invokes the lto.DescribeBizChainStatInfo API asynchronously
func (client *Client) DescribeBizChainStatInfoWithCallback(request *DescribeBizChainStatInfoRequest, callback func(response *DescribeBizChainStatInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBizChainStatInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeBizChainStatInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBizChainStatInfoRequest is the request struct for api DescribeBizChainStatInfo
type DescribeBizChainStatInfoRequest struct {
	*requests.RpcRequest
}

// DescribeBizChainStatInfoResponse is the response struct for api DescribeBizChainStatInfo
type DescribeBizChainStatInfoResponse struct {
	*responses.BaseResponse
	Code           string             `json:"Code" xml:"Code"`
	HttpStatusCode int                `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string             `json:"Message" xml:"Message"`
	RequestId      string             `json:"RequestId" xml:"RequestId"`
	Success        bool               `json:"Success" xml:"Success"`
	Data           []BizChainStatInfo `json:"Data" xml:"Data"`
}

// CreateDescribeBizChainStatInfoRequest creates a request to invoke DescribeBizChainStatInfo API
func CreateDescribeBizChainStatInfoRequest() (request *DescribeBizChainStatInfoRequest) {
	request = &DescribeBizChainStatInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "DescribeBizChainStatInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeBizChainStatInfoResponse creates a response to parse from DescribeBizChainStatInfo response
func CreateDescribeBizChainStatInfoResponse() (response *DescribeBizChainStatInfoResponse) {
	response = &DescribeBizChainStatInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
