package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyMember invokes the ltl.ModifyMember API synchronously
func (client *Client) ModifyMember(request *ModifyMemberRequest) (response *ModifyMemberResponse, err error) {
	response = CreateModifyMemberResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyMemberWithChan invokes the ltl.ModifyMember API asynchronously
func (client *Client) ModifyMemberWithChan(request *ModifyMemberRequest) (<-chan *ModifyMemberResponse, <-chan error) {
	responseChan := make(chan *ModifyMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyMemberWithCallback invokes the ltl.ModifyMember API asynchronously
func (client *Client) ModifyMemberWithCallback(request *ModifyMemberRequest, callback func(response *ModifyMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyMemberResponse
		var err error
		defer close(result)
		response, err = client.ModifyMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyMemberRequest is the request struct for api ModifyMember
type ModifyMemberRequest struct {
	*requests.RpcRequest
	ApiVersion    string `position:"Query" name:"ApiVersion"`
	Remark        string `position:"Query" name:"Remark"`
	BizChainId    string `position:"Query" name:"BizChainId"`
	MemberUid     string `position:"Query" name:"MemberUid"`
	MemberContact string `position:"Query" name:"MemberContact"`
	MemberPhone   string `position:"Query" name:"MemberPhone"`
	MemberName    string `position:"Query" name:"MemberName"`
	MemberId      string `position:"Query" name:"MemberId"`
}

// ModifyMemberResponse is the response struct for api ModifyMember
type ModifyMemberResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateModifyMemberRequest creates a request to invoke ModifyMember API
func CreateModifyMemberRequest() (request *ModifyMemberRequest) {
	request = &ModifyMemberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "ModifyMember", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyMemberResponse creates a response to parse from ModifyMember response
func CreateModifyMemberResponse() (response *ModifyMemberResponse) {
	response = &ModifyMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
