package location

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeServices invokes the location.DescribeServices API synchronously
// api document: https://help.aliyun.com/api/location/describeservices.html
func (client *Client) DescribeServices(request *DescribeServicesRequest) (response *DescribeServicesResponse, err error) {
	response = CreateDescribeServicesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeServicesWithChan invokes the location.DescribeServices API asynchronously
// api document: https://help.aliyun.com/api/location/describeservices.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeServicesWithChan(request *DescribeServicesRequest) (<-chan *DescribeServicesResponse, <-chan error) {
	responseChan := make(chan *DescribeServicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeServices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeServicesWithCallback invokes the location.DescribeServices API asynchronously
// api document: https://help.aliyun.com/api/location/describeservices.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeServicesWithCallback(request *DescribeServicesRequest, callback func(response *DescribeServicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeServicesResponse
		var err error
		defer close(result)
		response, err = client.DescribeServices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeServicesRequest is the request struct for api DescribeServices
type DescribeServicesRequest struct {
	*requests.RpcRequest
	Password string `position:"Query" name:"Password"`
}

// DescribeServicesResponse is the response struct for api DescribeServices
type DescribeServicesResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	TotalCount int      `json:"TotalCount" xml:"TotalCount"`
	Services   Services `json:"Services" xml:"Services"`
}

// CreateDescribeServicesRequest creates a request to invoke DescribeServices API
func CreateDescribeServicesRequest() (request *DescribeServicesRequest) {
	request = &DescribeServicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Location", "2015-06-12", "DescribeServices", "location", "openAPI")
	return
}

// CreateDescribeServicesResponse creates a response to parse from DescribeServices response
func CreateDescribeServicesResponse() (response *DescribeServicesResponse) {
	response = &DescribeServicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
